/*
 * Decompiled with CFR 0.152.
 */
package particleman.items;

import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import particleman.element.Element;
import particleman.entities.EntityParticleControllable;
import particleman.forge.ParticleMan;

public class ItemParticleGlove
extends Item {
    public static HashMap<String, List<EntityParticleControllable>> playerParticles = new HashMap();
    public static HashMap<String, Integer> playerWasSneaking = new HashMap();
    public static int fillRate = 5;
    public static int depleteRate = 5;
    public static int maxStorage = 300;

    public void check(String parUser) {
        if (!playerParticles.containsKey(parUser)) {
            playerParticles.put(parUser, new LinkedList());
            playerWasSneaking.put(parUser, 0);
        }
    }

    public void shieldRetract(EntityPlayer player) {
        for (int i = 0; i < playerParticles.get(CoroUtilEntity.getName((Entity)player)).size(); ++i) {
            EntityParticleControllable particle = playerParticles.get(CoroUtilEntity.getName((Entity)player)).get(i);
            particle.moveMode = 0;
        }
    }

    public int createParticleFromInternal(EntityPlayer player, ItemStack item, boolean forShield, int createCount) {
        int curAmount;
        int fireMode = item.field_77990_d.func_74762_e("pm_fireMode");
        if (!player.field_70170_p.field_72995_K && (curAmount = item.field_77990_d.func_74762_e("pm_storage_" + fireMode)) > 0) {
            int deplete = depleteRate;
            if (fireMode == 2) {
                deplete /= 3;
            }
            item.field_77990_d.func_74768_a("pm_storage_" + fireMode, Math.max(curAmount - deplete * createCount, 0));
            for (int i = 0; i < createCount; ++i) {
                EntityParticleControllable particle = new EntityParticleControllable(player.field_70170_p, CoroUtilEntity.getName((Entity)player), fireMode);
                particle.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
                particle.index = playerParticles.get(CoroUtilEntity.getName((Entity)player)).size();
                player.field_70170_p.func_72838_d((Entity)particle);
                if (forShield) {
                    playerParticles.get(CoroUtilEntity.getName((Entity)player)).add(particle);
                    particle.moveMode = 1;
                    player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ParticleMan.modID + ":fire_shoot", 0.9f, player.field_70170_p.field_73012_v.nextFloat());
                    continue;
                }
                this.fireParticle(player, particle);
                player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ParticleMan.modID + ":redstone_shoot", 0.9f, player.field_70170_p.field_73012_v.nextFloat());
            }
        }
        return fireMode;
    }

    public void fireParticle(EntityPlayer player, EntityParticleControllable particle) {
        particle.state = 1;
        float speed = 0.8f;
        float look = -2.0f;
        double adjAngle = 30.0;
        double dist = 2.5;
        int pitchOffset = 0;
        if (particle.type == 2) {
            pitchOffset = 90;
        }
        double vecX = -Math.sin((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos((player.field_70125_A + (float)pitchOffset) / 180.0f * (float)Math.PI);
        double vecY = -Math.sin((player.field_70125_A + (float)pitchOffset) / 180.0f * (float)Math.PI);
        double vecZ = Math.cos((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos((player.field_70125_A + (float)pitchOffset) / 180.0f * (float)Math.PI);
        particle.field_70159_w += vecX * (double)speed;
        particle.field_70181_x += vecY * (double)speed;
        particle.field_70179_y += vecZ * (double)speed;
        if (particle.type == 2) {
            player.field_70143_R = 0.0f;
        }
    }

    public int shootParticle(EntityPlayer player) {
        for (int i = 0; i < playerParticles.get(CoroUtilEntity.getName((Entity)player)).size(); ++i) {
            EntityParticleControllable particle = playerParticles.get(CoroUtilEntity.getName((Entity)player)).get(i);
            if (!((double)particle.func_70032_d((Entity)player) < 6.0)) continue;
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ParticleMan.modID + ":redstone_shoot", 0.9f, player.field_70170_p.field_73012_v.nextFloat());
            playerParticles.get(CoroUtilEntity.getName((Entity)player)).add(particle);
            particle.state = 1;
            float speed = 0.8f;
            float look = -2.0f;
            double vecX = -Math.sin((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI);
            double vecY = -Math.sin(player.field_70125_A / 180.0f * (float)Math.PI);
            double vecZ = Math.cos((player.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos(player.field_70125_A / 180.0f * (float)Math.PI);
            particle.field_70159_w += vecX * (double)speed;
            particle.field_70181_x += vecY * (double)speed;
            particle.field_70179_y += vecZ * (double)speed;
            if (particle.type == 2) {
                for (int j = 0; j < playerParticles.get(CoroUtilEntity.getName((Entity)player)).size(); ++j) {
                    EntityParticleControllable particle2 = playerParticles.get(CoroUtilEntity.getName((Entity)player)).get(j);
                    if (particle2 == particle) continue;
                    particle2.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                }
                particle.health -= 2;
                if (particle.health <= 0) {
                    particle.func_70106_y();
                    playerParticles.get(CoroUtilEntity.getName((Entity)player)).remove((Object)particle);
                }
            }
            return particle.type;
        }
        return -1;
    }

    public void makeShockwave(EntityPlayer player) {
        for (int i = 0; i < playerParticles.get(CoroUtilEntity.getName((Entity)player)).size(); ++i) {
            EntityParticleControllable particle = playerParticles.get(CoroUtilEntity.getName((Entity)player)).get(i);
            if (!((double)particle.func_70032_d((Entity)player) < 10.0)) continue;
            particle.state = 1;
            float speed2 = 0.8f;
            double vecX = particle.field_70165_t - player.field_70165_t;
            double vecY = particle.field_70163_u - player.field_70163_u;
            double vecZ = particle.field_70161_v - player.field_70161_v;
            double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
            particle.field_70159_w += vecX / dist2 * (double)speed2;
            particle.field_70179_y += vecZ / dist2 * (double)speed2;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_71024_bL().func_75113_a(3.0f);
        }
        player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ParticleMan.modID + ":shockwave_echo_loud", 0.7f, 1.0f - player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        NBTTagCompound plData = player.getEntityData();
        if (plData == null) {
            plData = new NBTTagCompound();
        }
        if (plData.func_74762_e("particleMode") == 0) {
            plData.func_74768_a("particleMode", 1);
        } else {
            plData.func_74768_a("particleMode", 0);
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.field_77990_d = new NBTTagCompound();
        }
        if (par2EntityPlayer.func_71024_bL().func_75116_a() >= 6) {
            this.check(CoroUtilEntity.getName((Entity)par2EntityPlayer));
            Block id = par3World.func_147439_a(par4, par5, par6);
            Block id2 = par3World.func_147439_a(par4, par5 + 1, par6);
            if (!CoroUtilBlock.isAir((Block)id)) {
                int spawnType = -1;
                if (id == Blocks.field_150478_aa || id2 == Blocks.field_150480_ab) {
                    spawnType = 0;
                    par3World.func_72908_a(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u, par2EntityPlayer.field_70161_v, ParticleMan.modID + ":fire_grabb", 0.9f, par3World.field_73012_v.nextFloat());
                } else if (id == Blocks.field_150429_aA || id == Blocks.field_150450_ax || id == Blocks.field_150488_af) {
                    spawnType = 1;
                    par3World.func_72908_a(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u, par2EntityPlayer.field_70161_v, ParticleMan.modID + ":redstone_grab", 0.9f, par3World.field_73012_v.nextFloat());
                } else if (id2.func_149688_o() == Material.field_151586_h) {
                    spawnType = 2;
                    par3World.func_72908_a(par2EntityPlayer.field_70165_t, par2EntityPlayer.field_70163_u, par2EntityPlayer.field_70161_v, ParticleMan.modID + ":redstone_grab", 0.9f, par3World.field_73012_v.nextFloat());
                }
                if (spawnType != -1) {
                    int curAmount;
                    if (!par3World.field_72995_K && (curAmount = par1ItemStack.field_77990_d.func_74762_e("pm_storage_" + spawnType)) < maxStorage) {
                        par1ItemStack.field_77990_d.func_74768_a("pm_storage_" + spawnType, Math.min(curAmount + fillRate, maxStorage));
                        if (!par2EntityPlayer.field_71075_bZ.field_75098_d) {
                            par2EntityPlayer.func_71024_bL().func_75113_a(1.0f);
                        }
                    }
                    return true;
                }
                this.func_77659_a(par1ItemStack, par3World, par2EntityPlayer);
                return true;
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.field_77990_d = new NBTTagCompound();
        }
        if (par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            if (!par2World.field_72995_K) {
                this.check(CoroUtilEntity.getName((Entity)player));
                NBTTagCompound plData = player.getEntityData();
                if (plData == null) {
                    plData = new NBTTagCompound();
                }
                if (player.func_70093_af() && par5) {
                    if (playerWasSneaking.get(CoroUtilEntity.getName((Entity)player)) == 0) {
                        if (plData.func_74762_e("particleMode") == 0) {
                            plData.func_74768_a("particleMode", 1);
                        } else {
                            plData.func_74768_a("particleMode", 0);
                        }
                    }
                    playerWasSneaking.put(CoroUtilEntity.getName((Entity)player), 1);
                } else {
                    playerWasSneaking.put(CoroUtilEntity.getName((Entity)player), 0);
                }
                for (int i = 0; i < playerParticles.get(CoroUtilEntity.getName((Entity)player)).size(); ++i) {
                    EntityParticleControllable particle = playerParticles.get(CoroUtilEntity.getName((Entity)player)).get(i);
                    if (particle == null || particle.field_70128_L || par3Entity.func_70032_d((Entity)particle) > 50.0f) {
                        playerParticles.get(CoroUtilEntity.getName((Entity)player)).remove((Object)particle);
                        continue;
                    }
                    particle.decayTime = 0;
                }
            } else {
                boolean charging = false;
                if (par5) {
                    this.createParticleHandEffect(par1ItemStack, par2World, par3Entity, par4, par5, charging);
                }
                if (par3Entity instanceof EntityPlayerSP) {
                    // empty if block
                }
            }
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.field_77990_d = new NBTTagCompound();
        }
        if (!par2World.field_72995_K) {
            this.check(CoroUtilEntity.getName((Entity)par3EntityPlayer));
            if (par3EntityPlayer.func_70093_af()) {
                if (par3EntityPlayer.func_71024_bL().func_75116_a() >= 6) {
                    this.makeShockwave(par3EntityPlayer);
                }
            } else {
                int chargeAmount = 1;
                this.createParticleFromInternal(par3EntityPlayer, par1ItemStack, false, chargeAmount);
            }
        } else {
            int curAmount;
            int fireMode = par1ItemStack.field_77990_d.func_74762_e("pm_fireMode");
            if (fireMode == 2 && (curAmount = par1ItemStack.field_77990_d.func_74762_e("pm_storage_" + fireMode)) > 0 && !par3EntityPlayer.func_70093_af()) {
                float speed = 0.35f;
                float look = 0.0f;
                double vecX = -Math.sin((par3EntityPlayer.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos((par3EntityPlayer.field_70125_A + 90.0f) / 180.0f * (float)Math.PI);
                double vecY = -Math.sin((par3EntityPlayer.field_70125_A + 90.0f) / 180.0f * (float)Math.PI);
                double vecZ = Math.cos((par3EntityPlayer.field_70177_z + look) / 180.0f * (float)Math.PI) * Math.cos((par3EntityPlayer.field_70125_A + 90.0f) / 180.0f * (float)Math.PI);
                par3EntityPlayer.field_70159_w -= vecX * (double)speed;
                par3EntityPlayer.field_70181_x -= vecY * (double)speed;
                par3EntityPlayer.field_70179_y -= vecZ * (double)speed;
            }
        }
        return par1ItemStack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        int curAmount;
        int fireMode = stack.field_77990_d.func_74762_e("pm_fireMode");
        if (!player.field_70170_p.field_72995_K && (curAmount = stack.field_77990_d.func_74762_e("pm_storage_" + fireMode)) > 0) {
            stack.field_77990_d.func_74768_a("pm_storage_" + fireMode, Math.max(curAmount - depleteRate, 0));
            Element.affectEntity(entity, (Entity)player, fireMode);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71024_bL().func_75113_a(1.0f);
            }
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ParticleMan.modID + ":redstone_shoot", 0.9f, player.field_70170_p.field_73012_v.nextFloat());
        }
        return false;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    @SideOnly(value=Side.CLIENT)
    public void createParticleHandEffect(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5, boolean charging) {
        double adjAngle = 30.0;
        double dist = 0.5;
        Entity center = par3Entity;
        double posX = center.field_70165_t - Math.cos(((double)(-center.field_70177_z) + adjAngle) * 0.01745329) * dist;
        double posY = center.field_70163_u - 0.3 - Math.sin(center.field_70125_A / 180.0f * (float)Math.PI) * dist;
        double posZ = center.field_70161_v + Math.sin(((double)(-center.field_70177_z) + adjAngle) * 0.01745329) * dist;
        Random rand = new Random();
        float speed = 0.05f;
        EntityReddustFX entFX = null;
        int fireMode = par1ItemStack.field_77990_d.func_74762_e("pm_fireMode");
        int chance = 1;
        if (!charging) {
            chance = 3;
            if (fireMode == 0) {
                chance = 5;
            }
        }
        if (rand.nextInt(chance) != 0) {
            return;
        }
        int curAmount = par1ItemStack.field_77990_d.func_74762_e("pm_storage_" + fireMode);
        if (curAmount > 0) {
            if (fireMode == 0) {
                entFX = new EntityFlameFX(par2World, posX, posY, posZ, (double)((rand.nextFloat() - rand.nextFloat()) * speed), (double)((rand.nextFloat() - rand.nextFloat()) * speed), (double)((rand.nextFloat() - rand.nextFloat()) * speed));
            } else if (fireMode == 1) {
                entFX = new EntityReddustFX(par2World, posX, posY, posZ, 1.0f, 1.0f, 0.0f, 0.0f);
            } else if (fireMode == 2) {
                entFX = new EntityReddustFX(par2World, posX, posY, posZ, 1.0f, 1.0f, 0.0f, 0.0f);
                entFX.func_70538_b(0.0f, 0.0f, 0.5f + (float)(Math.random() * 0.5));
            }
        }
        if (entFX != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(entFX);
        }
    }
}

