/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai;

import CoroUtil.ChunkCoordinatesSize;
import CoroUtil.DimensionChunkCache;
import CoroUtil.pathfinding.PFJobData;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.pathfinding.PathEntityEx;
import CoroUtil.util.CoroUtilBlock;
import hostileworlds.HWEventHandler;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.WorldDirectorMultiDim;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AreaScanner
implements Runnable {
    public World world;
    public WorldDirectorMultiDim worldDirector;
    public ArrayList<ChunkCoordinates> tempSurfaceCaves = new ArrayList();
    public ArrayList<ChunkCoordinates> tempCaves = new ArrayList();
    public boolean pfToPlayer = false;

    public AreaScanner(WorldDirectorMultiDim wd, World parWorld) {
        this.world = parWorld;
        this.worldDirector = wd;
    }

    @Override
    public void run() {
        try {
            this.tempSurfaceCaves = (ArrayList)WorldDirectorMultiDim.coordSurfaceCaves.get(this.world.field_73011_w.field_76574_g).clone();
            this.tempCaves = (ArrayList)WorldDirectorMultiDim.coordCaves.get(this.world.field_73011_w.field_76574_g).clone();
            if (this.tempSurfaceCaves == null) {
                this.tempSurfaceCaves = new ArrayList();
            }
            if (this.tempCaves == null) {
                this.tempCaves = new ArrayList();
            }
            this.areaScan();
            this.worldDirector.areaScanCompleteCallback();
        }
        catch (Exception ex) {
            System.out.println("Area scanner aborted due to exception.");
            this.worldDirector.areaScanCompleteCallback();
            ex.printStackTrace();
        }
    }

    public Block getBlock(int x, int y, int z) {
        try {
            if (!this.world.func_72904_c(x, 0, z, x, 128, z)) {
                return Blocks.field_150350_a;
            }
            return this.world.func_147439_a(x, y, z);
        }
        catch (Exception ex) {
            return Blocks.field_150350_a;
        }
    }

    public float distanceTo(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = x2 - x1;
        float f1 = y2 - y1;
        float f2 = z2 - z1;
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void areaScan() {
        HostileWorlds.dbg("started area scan, pf to player? " + this.pfToPlayer);
        if (this.pfToPlayer) {
            this.tempCaves.clear();
        }
        if (PFQueue.lastCacheUpdate < System.currentTimeMillis()) {
            PFQueue.lastCacheUpdate = System.currentTimeMillis() + 10000L;
            DimensionChunkCache.updateAllWorldCache();
        }
        DimensionChunkCache cache = (DimensionChunkCache)DimensionChunkCache.dimCacheLookup.get(this.world.field_73011_w.field_76574_g);
        PFQueue pathfinder = new PFQueue((IBlockAccess)cache, false);
        for (int i = 0; i < this.world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)this.world.field_73010_i.get(i);
            int size = 512;
            if (this.pfToPlayer) {
                size = 96;
            }
            int hsize = size / 2;
            int curX = (int)player.field_70165_t;
            int curY = (int)player.field_70163_u;
            int curZ = (int)player.field_70161_v;
            int firstY = 100;
            int lastY = 30;
            int yDir = -3;
            int horizontalStep = 4;
            int distBetweenLocations = 50;
            if (this.pfToPlayer) {
                firstY = 0;
                lastY = 40;
                yDir = 3;
            }
            for (int xx = curX - hsize; xx < curX + hsize; xx += horizontalStep) {
                for (int yy = firstY; this.pfToPlayer && yy < lastY || !this.pfToPlayer && yy > lastY; yy += yDir) {
                    for (int zz = curZ - hsize; zz < curZ + hsize; zz += horizontalStep) {
                        Block testID;
                        int j;
                        Block id = this.getBlock(xx, yy, zz);
                        if (!CoroUtilBlock.isAir((Block)id)) continue;
                        boolean proxFail = false;
                        boolean proxFail2 = false;
                        for (j = 0; j < this.tempSurfaceCaves.size(); ++j) {
                            if (!(Math.sqrt(this.tempSurfaceCaves.get(j).func_71569_e(xx, yy, zz)) < (double)distBetweenLocations)) continue;
                            proxFail2 = true;
                            break;
                        }
                        for (j = 0; j < this.tempCaves.size(); ++j) {
                            if (!(Math.sqrt(this.tempCaves.get(j).func_71569_e(xx, yy, zz)) < (double)distBetweenLocations)) continue;
                            proxFail2 = true;
                            break;
                        }
                        if (proxFail || proxFail2) continue;
                        float blockLight = cache.getLightBrightness(xx, yy, zz);
                        if (!this.pfToPlayer && blockLight != 0.0f) continue;
                        int downScan = 0;
                        for (downScan = 0; downScan < 30 && CoroUtilBlock.isAir((Block)(testID = this.getBlock(xx, yy - downScan, zz))); ++downScan) {
                        }
                        if (downScan >= 30 || downScan == 0) continue;
                        PathEntityEx pe = null;
                        ChunkCoordinates coordsDest = null;
                        ChunkCoordinates coordsSource = null;
                        coordsDest = new ChunkCoordinates((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                        coordsSource = new ChunkCoordinates(xx, yy - downScan + 1, zz);
                        System.out.println("starting pathfind: " + coordsSource.field_71574_a + ", " + coordsSource.field_71572_b + ", " + coordsSource.field_71573_c + " to " + coordsDest.field_71574_a + ", " + coordsDest.field_71572_b + ", " + coordsDest.field_71573_c);
                        PFJobData job = null;
                        try {
                            job = new PFJobData(new ChunkCoordinatesSize(coordsSource.field_71574_a, coordsSource.field_71572_b, coordsSource.field_71573_c, this.world.field_73011_w.field_76574_g, 1.0f, 2.0f), coordsDest.field_71574_a, coordsDest.field_71572_b, coordsDest.field_71573_c, 256.0f);
                            pe = pathfinder.createPathTo(job);
                        }
                        catch (Exception ex) {
                            HostileWorlds.dbg("Area scanner pathfind attempt caused an error, skipping this attempt and continuing");
                            ex.printStackTrace();
                        }
                        if (pe != null) {
                            double dist = this.distanceTo(pe.points[pe.pathLength - 1].xCoord, pe.points[pe.pathLength - 1].yCoord, pe.points[pe.pathLength - 1].zCoord, coordsDest.field_71574_a, coordsDest.field_71572_b, coordsDest.field_71573_c);
                            if (dist < 5.0) {
                                if (proxFail2) continue;
                                this.tempSurfaceCaves.add(new ChunkCoordinates(xx, yy - downScan, zz));
                                continue;
                            }
                            if (proxFail) continue;
                            this.tempCaves.add(new ChunkCoordinates(xx, yy - downScan, zz));
                            continue;
                        }
                        if (job != null && job.foundEnd) {
                            HWEventHandler.listConnectablePointsVisualDebug.addAll(job.listConnectablePoints);
                        }
                        if (proxFail) continue;
                        this.tempCaves.add(new ChunkCoordinates(xx, yy - downScan, zz));
                    }
                }
            }
        }
    }
}

