/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai.jobs;

import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumJobState;
import hostileworlds.entity.MovingBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import particleman.entities.EntityParticleControllable;

public class JobBossWielder
extends JobBase {
    public long huntRange = 256L;
    public boolean xRay = true;
    public int blockCount;
    public List<MovingBlock> blocks = new ArrayList<MovingBlock>();
    public List<EntityParticleControllable> particles = new ArrayList<EntityParticleControllable>();
    public int ticksBetweenGathers;
    public int ticksBeforeNextGather = this.ticksBetweenGathers = 100;
    public int ticksBeforeThrow = 60;
    public long overrideRange = 4L;
    public boolean gathering = false;
    public boolean throwing = false;
    public double targPrevPosX;
    public double targPrevPosY;
    public double targPrevPosZ;

    public JobBossWielder(JobManager jm) {
        super(jm);
    }

    public void tick() {
        super.tick();
        this.manageBlocks();
        if (this.ai.entityToAttack != null && (this.ai.entityToAttack.field_70128_L || this.ai.entityToAttack.func_70032_d((Entity)this.ent) > (float)this.huntRange)) {
            this.ai.entityToAttack = null;
        }
        if (this.ai.entityToAttack == null) {
            this.setJobState(EnumJobState.IDLE);
        }
        if (this.state == EnumJobState.IDLE) {
            if (this.ai.entityToAttack == null || this.ai.rand.nextInt(20) == 0) {
                Entity clEnt = null;
                float closest = 9999.0f;
                List list = this.ent.field_70170_p.func_72839_b((Entity)this.ent, this.ent.field_70121_D.func_72314_b((double)this.huntRange, (double)(this.huntRange / 2L), (double)this.huntRange));
                for (int j = 0; j < list.size(); ++j) {
                    float dist;
                    Entity entity1 = (Entity)list.get(j);
                    if (!this.isEnemy(entity1) || !this.xRay && !((EntityLivingBase)entity1).func_70685_l((Entity)this.ent) || !((dist = this.ent.func_70032_d(entity1)) < closest)) continue;
                    closest = dist;
                    clEnt = entity1;
                }
                if (clEnt != null) {
                    this.ai.entityToAttack = clEnt;
                }
            } else if (this.ai.entityToAttack != null) {
                this.setJobState(EnumJobState.W1);
            }
        } else if (this.state == EnumJobState.W1) {
            double dist = this.ai.entityToAttack.func_70032_d((Entity)this.ent);
            if (dist > (double)this.overrideRange && this.ticksBeforeNextGather > 0) {
                --this.ticksBeforeNextGather;
            }
            if (this.ticksBeforeNextGather == 0) {
                this.blockCount = 10;
                if (!this.throwing) {
                    if (this.blocks.size() < this.blockCount) {
                        this.gathering = true;
                        this.spawnBlock();
                    } else {
                        this.gathering = false;
                    }
                }
                if (this.ticksBeforeThrow > 0) {
                    --this.ticksBeforeThrow;
                }
                if (this.ticksBeforeThrow == 0) {
                    this.throwing = true;
                    if (this.ent.field_70170_p.func_72820_D() % 5L == 0L) {
                        this.throwBlock();
                    }
                }
                if (this.throwing && this.blocks.size() == 0) {
                    this.throwing = false;
                    this.ticksBeforeNextGather = this.ticksBetweenGathers = (int)dist;
                    this.ticksBeforeThrow = (int)dist * 2;
                }
            }
        }
        if (this.ai.entityToAttack != null) {
            this.targPrevPosX = this.ai.entityToAttack.field_70165_t;
            this.targPrevPosY = this.ai.entityToAttack.field_70163_u;
            this.targPrevPosZ = this.ai.entityToAttack.field_70161_v;
        }
    }

    public void manageBlocks() {
        MovingBlock mb;
        int i;
        for (i = 0; i < this.blocks.size(); ++i) {
            mb = this.blocks.get(i);
            float speed = 15.0f;
            float dist = (float)(3.0 + Math.sin((float)(this.ent.field_70170_p.func_72820_D() % 360L) * 0.1f) * 2.0);
            float diff = 36.0f / speed;
            mb.field_70165_t = this.ent.field_70165_t + Math.sin(((float)(this.ent.field_70170_p.func_72820_D() % 360L) + (float)i * diff) * speed * 0.01745329f) * (double)dist;
            mb.field_70163_u = this.ent.field_70163_u + 7.0;
            mb.field_70161_v = this.ent.field_70161_v + Math.cos(((float)(this.ent.field_70170_p.func_72820_D() % 360L) + (float)i * diff) * speed * 0.01745329f) * (double)dist;
            mb.field_70179_y = 0.0;
            mb.field_70181_x = 0.0;
            mb.field_70159_w = 0.0;
        }
        for (i = 0; i < this.particles.size(); ++i) {
            mb = this.particles.get(i);
            if (((EntityParticleControllable)mb).field_70128_L) {
                this.particles.remove((Object)mb);
                continue;
            }
            mb.influenceParticle(0.0f, 0.0f, 0.0f);
        }
        if (this.particles.size() < 30 && this.ent.field_70170_p.field_73012_v.nextInt(10) == 0) {
            EntityParticleControllable particle = new EntityParticleControllable(this.ent.field_70170_p, "", this.ent.field_70170_p.field_73012_v.nextInt(3));
            particle.func_70107_b(this.ent.field_70165_t, this.ent.field_70163_u + 2.0, this.ent.field_70161_v);
            particle.ownerEntityID = this.ent.func_145782_y();
            particle.index = this.particles.size();
            this.particles.add(particle);
            this.ent.field_70170_p.func_72838_d((Entity)particle);
        }
    }

    public void throwBlock() {
        MovingBlock mb = this.blocks.get(0);
        this.blocks.remove(0);
        mb.triggerOwnerDied();
        mb.target = (EntityLivingBase)this.ai.entityToAttack;
        mb.targetTillDist = 2.0f;
        float dist = this.ent.func_70032_d(this.ai.entityToAttack);
        this.moveTowards(mb, this.ai.entityToAttack, dist * (float)((double)0.025f + Math.random() * (double)0.005f), (int)(dist * 1.1f));
        mb.field_70181_x += (double)(0.2f + 0.03f * this.ai.entityToAttack.func_70032_d((Entity)this.ent));
    }

    public void spawnBlock() {
        MovingBlock mb = new MovingBlock(this.ent.field_70170_p, Blocks.field_150341_Y, 0);
        mb.func_70107_b(this.ent.field_70165_t, this.ent.field_70163_u + 3.0, this.ent.field_70161_v);
        mb.createParticles = true;
        mb.blockNum = this.blocks.size();
        float speed = 0.5f;
        this.ent.field_70170_p.func_72838_d((Entity)mb);
        this.blocks.add(mb);
    }

    public void moveTowards(Entity ent, Entity targ, float speed, int leadTicks) {
        double vecX = targ.field_70165_t + (targ.field_70165_t - this.targPrevPosX) * (double)leadTicks - ent.field_70165_t;
        double vecY = targ.field_70163_u - ent.field_70163_u;
        double vecZ = targ.field_70161_v + (targ.field_70161_v - this.targPrevPosZ) * (double)leadTicks - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public boolean shouldExecute() {
        return true;
    }

    public boolean shouldContinue() {
        return true;
    }
}

