/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity.bt;

import CoroUtil.IChunkLoader;
import CoroUtil.ability.abilities.AbilityAttackMelee;
import CoroUtil.ability.abilities.AbilityShootArrow;
import CoroUtil.bt.Behavior;
import CoroUtil.bt.IBTAgent;
import CoroUtil.inventory.AIInventory;
import hostileworlds.HostileWorlds;
import hostileworlds.entity.abilities.AbilityLeapAttack;
import hostileworlds.entity.abilities.AbilityLungeAttack;
import hostileworlds.entity.bt.EnemyBase;
import hostileworlds.entity.bt.ai.SeekPlayerBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class OrcSeeker
extends EnemyBase
implements IChunkLoader {
    public ForgeChunkManager.Ticket ticket = null;

    public OrcSeeker(World par1World) {
        super(par1World);
    }

    @Override
    public void initExtraAI() {
        super.initExtraAI();
        this.agent.btAI.add((Behavior)new SeekPlayerBase((Behavior)this.agent.btAI, (IBTAgent)this, 16.0f));
    }

    @Override
    public void initRPGStats() {
        super.initRPGStats();
        AIInventory cfr_ignored_0 = this.agent.entInv;
        this.agent.entInv.setSlotContents(AIInventory.slot_Melee, new ItemStack(Items.field_151040_l));
        AIInventory cfr_ignored_1 = this.agent.entInv;
        this.agent.entInv.setSlotContents(AIInventory.slot_Ranged, new ItemStack((Item)Items.field_151031_f));
        this.func_96120_a(0, 0.0f);
        this.getAIBTAgent().profile.addAbilityMelee(new AbilityAttackMelee().init((EntityLivingBase)this));
        this.getAIBTAgent().profile.addAbilityMelee(new AbilityLeapAttack().init((EntityLivingBase)this));
        this.getAIBTAgent().profile.addAbilityMelee(new AbilityLungeAttack().init((EntityLivingBase)this));
        this.getAIBTAgent().profile.addAbilityRanged(new AbilityShootArrow().init((EntityLivingBase)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.agent.setSpeedNormalBase(0.55f);
        this.agent.applyEntityAttributes();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public String func_70005_c_() {
        return "OrcSeeker";
    }

    @Override
    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.ticket == null) {
            this.initChunkLoad();
        }
    }

    public void initChunkLoad() {
        System.out.println("OrcSeeker init request ticket");
        this.requestTicket();
        this.forceChunkLoading(this.field_70176_ah, this.field_70164_aj);
    }

    public void setChunkTicket(ForgeChunkManager.Ticket parTicket) {
        if (this.ticket != null && parTicket != this.ticket) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = parTicket;
    }

    public void forceChunkLoading(int chunkX, int chunkZ) {
        if (this.ticket == null) {
            return;
        }
        Set chunks = this.getChunksAround(chunkX, chunkZ, 3);
        for (ChunkCoordIntPair chunk : chunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
        }
        ChunkCoordIntPair myChunk = new ChunkCoordIntPair(chunkX, chunkZ);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
    }

    public Set getChunksAround(int xChunk, int zChunk, int radius) {
        HashSet<ChunkCoordIntPair> chunkList = new HashSet<ChunkCoordIntPair>();
        for (int xx = xChunk - radius; xx <= xChunk + radius; ++xx) {
            for (int zz = zChunk - radius; zz <= zChunk + radius; ++zz) {
                chunkList.add(new ChunkCoordIntPair(xx, zz));
            }
        }
        return chunkList;
    }

    public void requestTicket() {
        ForgeChunkManager.Ticket chunkTicket = ForgeChunkManager.requestTicket((Object)HostileWorlds.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (chunkTicket != null) {
            chunkTicket.getModData();
            chunkTicket.setChunkListDepth(12);
            chunkTicket.bindEntity((Entity)this);
            this.setChunkTicket(chunkTicket);
        }
    }
}

