/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.world.location;

import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.location.ManagedLocation;
import CoroUtil.world.location.town.TownObject;
import build.BuildServerTicks;
import build.ICustomGen;
import build.world.Build;
import build.world.BuildJob;
import hostileworlds.HostileWorlds;
import hostileworlds.entity.bt.EnemyBase;
import hostileworlds.entity.bt.OrcArcher;
import hostileworlds.entity.bt.OrcBoss;
import hostileworlds.entity.bt.OrcGuard;
import hostileworlds.entity.bt.OrcSeeker;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Stronghold
extends TownObject
implements ICustomGen {
    public int areaRadius = 10;
    public int areaHeight = 10;
    public int wallHeight = 5;
    public int playerScanRange = 64;
    public boolean cachePlayerInside;
    public OrcSeeker entitySeeker = null;

    public void tickUpdate() {
        super.tickUpdate();
        if (this.getWorld().func_82737_E() % 20L == 0L) {
            System.out.println("stronghold tick - " + this.spawn);
            if (this.shouldRemoveStronghold()) {
                this.removeStronghold();
            }
        }
        this.tickManageSeeker();
        if (this.getWorld().func_82737_E() % 40L == 0L) {
            this.updatePlayerInfoCache();
        }
    }

    public void initFirstTime() {
        super.initFirstTime();
        System.out.println("first time gen stronghold");
        this.genStructure();
    }

    public void genStructure() {
        this.areaRadius = 15;
        this.areaHeight = 30;
        this.clearGenArea();
        if (this.getWorld().func_147439_a(this.spawn.field_71574_a, this.spawn.field_71572_b, this.spawn.field_71573_c) != HostileWorlds.blockSourceStructure) {
            this.getWorld().func_147449_b(this.spawn.field_71574_a, this.spawn.field_71572_b, this.spawn.field_71573_c, HostileWorlds.blockSourceStructure);
        }
        this.genSchematic();
    }

    public void genSchematic() {
        int yOffset = 0;
        Build mainStructureData = new Build(this.spawn.field_71574_a, this.spawn.field_71572_b + yOffset, this.spawn.field_71573_c, CoroUtilFile.getSaveFolderPath() + "HWSchematics" + File.separator + "stronghold");
        BuildJob bj = new BuildJob(-99, this.spawn.field_71574_a, this.spawn.field_71572_b + yOffset, this.spawn.field_71573_c, mainStructureData);
        bj.build.dim = this.getWorld().field_73011_w.field_76574_g;
        bj.useFirstPass = false;
        bj.useRotationBuild = false;
        bj.build_rate = 1600;
        bj.setDirection(0);
        bj.customGenCallback = this;
        bj.blockIDsNoBuildOver.add(HostileWorlds.blockSourceStructure);
        this.areaHeight = mainStructureData.map_sizeY;
        BuildServerTicks.buildMan.addBuild(bj);
    }

    public ChunkCoordinates getBuildingCornerCoord() {
        return new ChunkCoordinates(MathHelper.func_76128_c((double)((double)this.spawn.field_71574_a - (double)this.areaRadius)), this.spawn.field_71572_b, MathHelper.func_76128_c((double)((double)this.spawn.field_71573_c - (double)this.areaRadius)));
    }

    public void clearGenArea() {
        for (int y = 0; y < this.areaHeight; ++y) {
            for (int x = -this.areaRadius; x <= this.areaRadius; ++x) {
                for (int z = -this.areaRadius; z <= this.areaRadius; ++z) {
                    this.setBlockRel(x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    public void setBlockRel(int x, int y, int z, Block parBlock) {
        this.setBlockRel(x, y, z, parBlock, 0);
    }

    public void setBlockRel(int x, int y, int z, Block parBlock, int parMeta) {
        if (this.getWorld().func_147439_a(this.spawn.field_71574_a + x, this.spawn.field_71572_b + y, this.spawn.field_71573_c + z) != HostileWorlds.blockSourceStructure) {
            this.getWorld().func_147465_d(this.spawn.field_71574_a + x, this.spawn.field_71572_b + y, this.spawn.field_71573_c + z, parBlock, parMeta, 3);
        }
    }

    public boolean shouldRemoveStronghold() {
        return this.getWorld().func_147439_a(this.spawn.field_71574_a, this.spawn.field_71572_b, this.spawn.field_71573_c) != HostileWorlds.blockSourceStructure;
    }

    public void removeStronghold() {
        System.out.println("removing HW stronghold");
        WorldDirector wd = WorldDirectorManager.instance().getCoroUtilWorldDirector(this.getWorld());
        wd.removeTickingLocation((ManagedLocation)this);
    }

    public void spawnEntities() {
        int spawnRadius = this.areaRadius - 1;
        int fix = 0;
        this.spawnEntityRel("archer", Vec3.func_72443_a((double)spawnRadius, (double)(this.wallHeight + 1), (double)(spawnRadius - fix)));
        this.spawnEntityRel("archer", Vec3.func_72443_a((double)spawnRadius, (double)(this.wallHeight + 1), (double)(-spawnRadius)));
        this.spawnEntityRel("archer", Vec3.func_72443_a((double)(-spawnRadius), (double)(this.wallHeight + 1), (double)(spawnRadius - fix)));
        this.spawnEntityRel("archer", Vec3.func_72443_a((double)(-spawnRadius), (double)(this.wallHeight + 1), (double)(-spawnRadius)));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)-13.0, (double)1.0, (double)-2.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)-13.0, (double)1.0, (double)2.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)13.0, (double)1.0, (double)-2.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)13.0, (double)1.0, (double)2.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)-2.0, (double)1.0, (double)-13.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)2.0, (double)1.0, (double)-13.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)-2.0, (double)1.0, (double)(13 - fix)));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)2.0, (double)1.0, (double)(13 - fix)));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)-5.0, (double)5.0, (double)0.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)5.0, (double)5.0, (double)0.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)5.0, (double)5.0, (double)-5.0));
        this.spawnEntityRel("guard", Vec3.func_72443_a((double)-5.0, (double)5.0, (double)5.0));
        this.spawnEntityRel("boss", Vec3.func_72443_a((double)0.0, (double)9.0, (double)-8.0));
    }

    public void spawnEntityRel(String parType, Vec3 parCoords) {
        parCoords.field_72450_a += (double)this.spawn.field_71574_a;
        parCoords.field_72449_c += (double)this.spawn.field_71573_c;
        parCoords.field_72448_b += (double)this.spawn.field_71572_b;
        EnemyBase ent = null;
        if (parType.equals("archer")) {
            ent = new OrcArcher(this.getWorld());
        } else if (parType.equals("guard")) {
            ent = new OrcGuard(this.getWorld());
        } else if (parType.equals("boss")) {
            ent = new OrcBoss(this.getWorld());
        }
        if (ent != null) {
            ent.getAIBTAgent().setManagedLocation((ManagedLocation)this);
            ent.func_70107_b(parCoords.field_72450_a + 0.5, parCoords.field_72448_b, parCoords.field_72449_c + 0.5);
            this.getWorld().func_72838_d((Entity)ent);
            ent.func_110161_a(null);
        }
    }

    public void genPassPre(World world, BuildJob parBuildJob, int parPass) {
        if (parPass == -1) {
            this.spawnEntities();
        }
    }

    public NBTTagCompound getInitNBTTileEntity() {
        return null;
    }

    public boolean isEntityInsideStructure(Entity ent) {
        return ent.field_70165_t > (double)(this.spawn.field_71574_a - this.areaRadius) && ent.field_70165_t <= (double)(this.spawn.field_71574_a + this.areaRadius) && ent.field_70161_v > (double)(this.spawn.field_71573_c - this.areaRadius) && ent.field_70161_v <= (double)(this.spawn.field_71573_c + this.areaRadius) && ent.field_70163_u >= (double)this.spawn.field_71572_b;
    }

    public void updatePlayerInfoCache() {
        this.cachePlayerInside = false;
        EntityPlayer entP = this.getWorld().func_72977_a((double)this.spawn.field_71574_a, (double)this.spawn.field_71572_b, (double)this.spawn.field_71573_c, (double)this.playerScanRange);
        if (entP != null) {
            this.cachePlayerInside = this.isEntityInsideStructure((Entity)entP);
        }
    }

    public boolean isPlayerInside() {
        return this.cachePlayerInside;
    }

    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.areaHeight = var1.func_74762_e("areaHeight");
    }

    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.func_74768_a("areaHeight", this.areaHeight);
    }

    public void tickManageSeeker() {
        if (this.getWorld().func_82737_E() % 80L == 0L && (this.entitySeeker == null || this.entitySeeker.field_70128_L || this.entitySeeker.func_110143_aJ() == 0.0f || !this.getWorld().field_72996_f.contains((Object)this.entitySeeker))) {
            System.out.println("SPAWN NEW ORC SEEKER");
            this.entitySeeker = new OrcSeeker(this.getWorld());
            this.entitySeeker.getAIBTAgent().setManagedLocation((ManagedLocation)this);
            this.entitySeeker.func_70107_b(this.spawn.field_71574_a, this.spawn.field_71572_b + 2, this.spawn.field_71573_c);
            this.entitySeeker.initChunkLoad();
            this.getWorld().func_72838_d((Entity)this.entitySeeker);
            this.entitySeeker.func_110161_a(null);
        }
    }
}

