/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers;

import com.gmail.samsun469.supercraftbrothers.Lang;
import com.gmail.samsun469.supercraftbrothers.SCBGame;
import com.gmail.samsun469.supercraftbrothers.SuperCraftBrothers;
import com.gmail.samsun469.supercraftbrothers.managers.ArenaManager;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import com.gmail.samsun469.supercraftbrothers.managers.PlayerManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class Schedulers {
    private static BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    public Schedulers(SuperCraftBrothers plugin) {
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                Schedulers.update();
                Schedulers.checkPlayers();
            }
        }, 0L, 10L);
    }

    public static void update() {
        for (SCBGame game : ArenaManager.getAllGames()) {
            if (game.getMap().getLocation("sign") == null) continue;
            if (!(game.getMap().getLocation("sign").getBlock().getState() instanceof Sign) && ConfigManager.autoFixSigns) {
                Block b = game.getMap().getLocation("sign").getBlock();
                b.setType(Material.WALL_SIGN);
                Sign s = (Sign)b.getState();
                org.bukkit.material.Sign matSign = new org.bukkit.material.Sign(Material.WALL_SIGN);
                BlockFace[] blockFaceArray = faces;
                int n = faces.length;
                int n2 = 0;
                while (n2 < n) {
                    BlockFace face = blockFaceArray[n2];
                    if (game.getMap().getLocation("sign").getBlock().getRelative(face).getType() != Material.AIR && game.getMap().getLocation("sign").getBlock().getRelative(face).getType() != Material.WALL_SIGN) {
                        matSign.setFacingDirection(face.getOppositeFace());
                        break;
                    }
                    ++n2;
                }
                s.setData((MaterialData)matSign);
                s.update();
            }
            if (!(game.getMap().getLocation("sign").getBlock().getState() instanceof Sign)) continue;
            Sign s = (Sign)game.getMap().getLocation("sign").getBlock().getState();
            if (game.isInGame()) {
                if (game.getAlive() == 0) {
                    game.stopGame();
                }
                s.setLine(0, Lang.SIGN_INGAME_1.getString(false));
                s.setLine(1, Lang.SIGN_INGAME_2.getString(false).replace("%n", game.getName()));
                s.setLine(2, Lang.SIGN_INGAME_3.getString(false));
                s.setLine(3, Lang.SIGN_INGAME_4.getString(false).replace("%a", Integer.toString(game.getAlive())).replace("%d", Integer.toString(game.getDead())));
            }
            if (game.isInLobby()) {
                s.setLine(0, Lang.SIGN_INLOBBY_1.getString(false));
                s.setLine(1, Lang.SIGN_INLOBBY_2.getString(false).replace("%n", game.getName()));
                s.setLine(2, Lang.SIGN_INLOBBY_3.getString(false).replace("%p", Integer.toString(game.getAllPlayers())));
                s.setLine(3, Lang.SIGN_INLOBBY_4.getString(false).replace("%i", Integer.toString(game.getI())));
            }
            s.update();
        }
    }

    public static void checkPlayers() {
        for (SCBGame game : ArenaManager.getAllGames()) {
            for (String a : game.getHashMap(0).keySet()) {
                if (game.getHashMap(0).get(a) != null) continue;
                game.getHashMap(0).remove(a);
                PlayerManager.removeCraftBrother(a);
            }
            for (String a : game.getHashMap(1).keySet()) {
                if (game.getHashMap(1).get(a) != null) continue;
                game.getHashMap(1).remove(a);
                PlayerManager.removeCraftBrother(a);
            }
        }
    }
}

