/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers;

import com.gmail.samsun469.supercraftbrothers.Lang;
import com.gmail.samsun469.supercraftbrothers.Schedulers;
import com.gmail.samsun469.supercraftbrothers.managers.ArenaManager;
import com.gmail.samsun469.supercraftbrothers.managers.ColorManager;
import com.gmail.samsun469.supercraftbrothers.managers.CommandManager;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import com.gmail.samsun469.supercraftbrothers.managers.InventoryManager;
import com.gmail.samsun469.supercraftbrothers.managers.ItemManager;
import com.gmail.samsun469.supercraftbrothers.managers.ListenerManager;
import com.gmail.samsun469.supercraftbrothers.managers.PlayerManager;
import com.gmail.samsun469.supercraftbrothers.managers.RankManager;
import com.gmail.samsun469.supercraftbrothers.managers.StatsManager;
import com.gmail.samsun469.supercraftbrothers.menus.ClassMenu;
import com.gmail.samsun469.supercraftbrothers.utilities.Updater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class SuperCraftBrothers
extends JavaPlugin {
    private static SuperCraftBrothers instance;
    public boolean vault = false;
    public String name;
    public static YamlConfiguration LANG;
    public static File LANG_FILE;
    public static Economy econ;

    static {
        econ = null;
    }

    public static SuperCraftBrothers getInstance() {
        return instance;
    }

    public static Economy getEcon() {
        return econ;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        instance = this;
        if (!this.getConfig().isBoolean("first-run")) {
            this.saveResource("ranks\\DEFAULT.yml", false);
            this.saveResource("ranks\\VIP.yml", false);
            this.saveResource("ranks\\PRO.yml", false);
            this.saveResource("colors.yml", false);
            this.getConfig().set("first-run", (Object)false);
            this.getConfig().set("enabled-ranks", Arrays.asList("DEFAULT", "VIP", "PRO"));
            this.saveConfig();
        }
        new ListenerManager(this);
        new CommandManager(this);
        new ArenaManager(this);
        new Schedulers(this);
        new PlayerManager(this);
        new InventoryManager(this);
        new ClassMenu(this);
        new ConfigManager(this);
        new RankManager(this);
        new ItemManager(this);
        new ColorManager(this);
        this.loadLang();
        if (!this.setupEcon()) {
            if (ConfigManager.vault) {
                this.getLogger().severe("Vault not enabled because it could not be found!");
                ConfigManager.vault = false;
                this.vault = false;
            }
        } else {
            this.vault = true;
        }
    }

    public void onDisable() {
        instance = null;
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void reloadCfg() {
        ArenaManager.reloadCfg();
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
        Bukkit.getPluginManager().enablePlugin((Plugin)this);
    }

    public void update() {
        new Updater((Plugin)this, "scb", this.getFile(), Updater.UpdateType.NO_VERSION_CHECK, true);
    }

    public FileConfiguration getPlayerConfig(String p) {
        File file = new File(this.getDataFolder() + File.separator + "users" + File.separator + p + ".yml");
        if (!file.exists()) {
            StatsManager.createPlayerFile(p);
        }
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)file);
        return c;
    }

    public String getPlayerFile(String p) {
        return this.getDataFolder() + File.separator + "users" + File.separator + p + ".yml";
    }

    public boolean setupEcon() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    public void loadLang() {
        File lang = new File(this.getDataFolder(), "lang.yml");
        if (!lang.exists()) {
            try {
                lang.createNewFile();
                InputStream defConfigStream = this.getResource("lang.yml");
                if (defConfigStream != null) {
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
                    defConfig.save(lang);
                    Lang.setFile(defConfig);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.getLogger().severe("Failed to save lang.yml.");
                this.setEnabled(false);
            }
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)lang);
        Lang[] langArray = Lang.values();
        int n = langArray.length;
        int n2 = 0;
        while (n2 < n) {
            Lang item = langArray[n2];
            if (conf.getString(item.getPath()) == null) {
                conf.set(item.getPath(), (Object)item.getDefault());
            }
            ++n2;
        }
        Lang.setFile(conf);
        LANG = conf;
        LANG_FILE = lang;
        try {
            conf.save(lang);
        }
        catch (IOException e) {
            this.getLogger().warning("Failed to save lang.yml.");
            e.printStackTrace();
        }
    }

    public File getLangFile() {
        return LANG_FILE;
    }

    public FileConfiguration getLangConfig() {
        return LANG;
    }
}

