/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.listeners;

import com.gmail.samsun469.supercraftbrothers.SuperCraftBrothers;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import com.gmail.samsun469.supercraftbrothers.managers.PlayerManager;
import com.gmail.samsun469.supercraftbrothers.managers.RankManager;
import com.gmail.samsun469.supercraftbrothers.utilities.WorldChecker;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerToggleFlight
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onFly(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE && event.isFlying() && ConfigManager.doubleJump && WorldChecker.mainLobbyGame(player)) {
            if (PlayerManager.getCraftBrother(player) != null && PlayerManager.getCraftBrother(player).isSpectating()) {
                return;
            }
            if (WorldChecker.game(player)) {
                event.setCancelled(true);
                player.setAllowFlight(false);
                this.doubleJump(player);
            } else if (WorldChecker.mainLobby(player)) {
                if (RankManager.getPlayerRank(player.getName()).getCanDoubleJump() && ConfigManager.doubleJumpLobby) {
                    event.setCancelled(true);
                    player.setAllowFlight(false);
                    this.doubleJump(player);
                } else {
                    player.setAllowFlight(false);
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    public void doubleJump(final Player player) {
        player.setFlying(false);
        player.setVelocity(player.getLocation().getDirection().multiply(0.1).setY(0.82));
        BukkitRunnable br = new BukkitRunnable(){

            public void run() {
                if (!player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.AIR)) {
                    player.setAllowFlight(true);
                    this.cancel();
                }
            }
        };
        br.runTaskTimer((Plugin)SuperCraftBrothers.getInstance(), 0L, 1L);
    }
}

