/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.managers;

import com.gmail.samsun469.supercraftbrothers.SCBGame;
import com.gmail.samsun469.supercraftbrothers.SuperCraftBrothers;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import com.gmail.samsun469.supercraftbrothers.utilities.LocationUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;

public class ArenaManager {
    private static HashMap<String, SCBGame> games = new HashMap();
    private static SuperCraftBrothers scb;
    private static Location mainLobby;

    public ArenaManager(SuperCraftBrothers plugin) {
        scb = plugin;
        ArenaManager.load();
    }

    public static void reloadCfg() {
        for (SCBGame game : games.values()) {
            if (!game.isInGame()) continue;
            game.stopGame();
        }
    }

    public static void load() {
        games.clear();
        File arenas = new File(scb.getDataFolder() + File.separator + "arenas" + File.separator);
        List al = scb.getConfig().getStringList("enabled-arenas");
        if (!arenas.exists()) {
            arenas.mkdir();
        }
        if (arenas.listFiles() != null) {
            File[] fileArray = arenas.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String fname = f.getName().replace(".yml", "");
                if (al.contains(fname)) {
                    games.put(fname, new SCBGame(scb, fname, f));
                    if (ConfigManager.debug) {
                        scb.getLogger().info("Map " + fname + " was successfully loaded!");
                    }
                } else if (ConfigManager.debug) {
                    scb.getLogger().info("Map " + fname + " NOT loaded because it was not in the enabled arenas list");
                }
                ++n2;
            }
        }
        if (scb.getConfig().isString("main-lobby")) {
            mainLobby = LocationUtils.stringToLocation(scb.getConfig().getString("main-lobby"));
        }
    }

    public static SCBGame createGame(String name) {
        if (ArenaManager.getGame(name) == null) {
            File file = new File(scb.getDataFolder() + File.separator + "arenas" + File.separator + name + ".yml");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SCBGame game = games.put(name, new SCBGame(scb, name, file));
            List names = scb.getConfig().getStringList("enabled-arenas");
            names.add(name);
            scb.getConfig().set("enabled-arenas", (Object)names);
            scb.saveConfig();
            return game;
        }
        return null;
    }

    public static boolean deleteGame(String name) {
        if (ArenaManager.getGame(name) != null) {
            ArenaManager.getGame(name).stopGame();
            games.remove(name);
            List names = scb.getConfig().getStringList("enabled-arenas");
            names.remove(name);
            Location loc = LocationUtils.stringToLocation(scb.getConfig().getString("map." + name + ".lobby-sign"));
            if (loc != null) {
                loc.getBlock().setType(Material.AIR);
            }
            scb.getConfig().set("enabled-arenas", (Object)names);
            scb.saveConfig();
            return true;
        }
        return false;
    }

    public static SCBGame getGame(String game) {
        if (games.containsKey(game)) {
            return games.get(game);
        }
        return null;
    }

    public static void addGame(SCBGame game) {
        if (game == null) {
            return;
        }
        if (!games.containsKey(game.getName())) {
            games.put(game.getName(), game);
        }
    }

    public static void removeGame(SCBGame game) {
        if (game == null) {
            return;
        }
        ArenaManager.removeGame(game.getName());
    }

    public static void removeGame(String game) {
        if (game == null) {
            return;
        }
        if (games.containsKey(game)) {
            games.remove(game);
        }
    }

    public static Collection<SCBGame> getAllGames() {
        return games.values();
    }

    public static Location getMainLobby() {
        return mainLobby;
    }

    public static void setMainLobby(Location ml) {
        scb.getConfig().set("main-lobby", (Object)LocationUtils.locationToString(ml));
        scb.saveConfig();
        mainLobby = ml;
    }
}

