/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.managers;

import com.gmail.samsun469.supercraftbrothers.SCBClass;
import com.gmail.samsun469.supercraftbrothers.SuperCraftBrothers;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClassManager {
    private static SuperCraftBrothers scb;
    private static File CLASS_DIR;
    private static HashMap<String, SCBClass> classes;
    private static List<String> enabledclasses;

    static {
        CLASS_DIR = new File(scb.getDataFolder() + File.separator + "classes");
        classes = new HashMap();
        enabledclasses = new ArrayList<String>();
    }

    public ClassManager(SuperCraftBrothers plugin) {
        scb = plugin;
        ClassManager.load();
    }

    private static void load() {
        enabledclasses = scb.getConfig().getStringList("enabled-classes");
        if (!CLASS_DIR.exists()) {
            CLASS_DIR.mkdir();
        }
        if (CLASS_DIR.listFiles() != null) {
            File[] fileArray = CLASS_DIR.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File CLASS_FILE = fileArray[n2];
                String name = CLASS_FILE.getName().replace(".yml", "");
                if (enabledclasses.contains(name)) {
                    classes.put(name, new SCBClass(name, scb));
                    if (ConfigManager.debug) {
                        scb.getLogger().info("Successfully registered the class " + name);
                    }
                } else if (ConfigManager.debug) {
                    scb.getLogger().info("The class " + name + " was NOT loaded");
                }
                ++n2;
            }
        }
    }

    public static SCBClass getClass(String name) {
        return classes.get(name);
    }
}

