/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.managers;

import com.gmail.samsun469.supercraftbrothers.SCBRank;
import com.gmail.samsun469.supercraftbrothers.SuperCraftBrothers;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import com.gmail.samsun469.supercraftbrothers.managers.ScoreboardManager;
import com.gmail.samsun469.supercraftbrothers.utilities.LocationUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class RankManager {
    private static HashMap<String, SCBRank> ranks = new HashMap();
    private static SuperCraftBrothers scb;

    public RankManager(SuperCraftBrothers plugin) {
        scb = plugin;
        RankManager.load();
    }

    public static void load() {
        ranks.clear();
        File rankfolder = new File(scb.getDataFolder() + File.separator + "ranks");
        List r = scb.getConfig().getStringList("enabled-ranks");
        if (!rankfolder.exists()) {
            rankfolder.mkdir();
        }
        if (rankfolder.listFiles() != null) {
            File[] fileArray = rankfolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String fname = f.getName().replace(".yml", "");
                if (!r.isEmpty() && r.contains(fname)) {
                    ranks.put(fname, new SCBRank(scb, fname, f));
                    if (ConfigManager.debug) {
                        scb.getLogger().info("Rank " + fname + " was successfully loaded!");
                    }
                } else if (ConfigManager.debug) {
                    scb.getLogger().info("Rank " + fname + " NOT loaded because it was not in the enabled ranks list");
                }
                ++n2;
            }
        }
    }

    public static void createRank(String name) {
        if (RankManager.getRank(name) == null) {
            File file = new File(scb.getDataFolder() + File.separator + "ranks" + File.separator + name + ".yml");
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ranks.put(name, new SCBRank(scb, name, file));
            List names = scb.getConfig().getStringList("enabled-ranks");
            names.add(name);
            scb.getConfig().set("enabled-ranks", (Object)names);
            scb.saveConfig();
        }
    }

    public static boolean deleteRank(String name) {
        if (RankManager.getRank(name) != null) {
            ranks.remove(name);
            List names = scb.getConfig().getStringList("enabled-ranks");
            names.remove(name);
            Location loc = LocationUtils.stringToLocation(scb.getConfig().getString("map." + name + ".lobby-sign"));
            if (loc != null) {
                loc.getBlock().setType(Material.AIR);
            }
            scb.getConfig().set("enabled-ranks", (Object)names);
            scb.saveConfig();
            return true;
        }
        return false;
    }

    public static SCBRank getRank(String rank) {
        return ranks.get(rank);
    }

    public static void addRank(SCBRank rank) {
        if (rank == null) {
            return;
        }
        if (!ranks.containsKey(rank.getName())) {
            ranks.put(rank.getName(), rank);
        }
    }

    public static void removeRank(SCBRank rank) {
        if (rank == null) {
            return;
        }
        RankManager.removeRank(rank.getName());
    }

    public static void removeRank(String rank) {
        if (rank == null) {
            return;
        }
        if (ranks.containsKey(rank)) {
            ranks.remove(rank);
        }
    }

    public static Collection<SCBRank> getAllrank() {
        return ranks.values();
    }

    public static SCBRank getPlayerRank(String p) {
        return RankManager.getRank(SuperCraftBrothers.getInstance().getPlayerConfig(p).getString("rank"));
    }

    public static void setPlayerRank(String p, String argRank) {
        FileConfiguration c = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        c.set("rank", (Object)argRank);
        try {
            c.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
            ScoreboardManager.addPlayer(Bukkit.getPlayer((String)p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

