/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.managers;

import com.gmail.samsun469.supercraftbrothers.SuperCraftBrothers;
import com.gmail.samsun469.supercraftbrothers.managers.ConfigManager;
import com.gmail.samsun469.supercraftbrothers.managers.ScoreboardManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatsManager {
    public static int getPlayerGems(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getInt("gems");
    }

    public static int getPlayerWins(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getInt("wins");
    }

    public static int getPlayerKills(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getInt("kills");
    }

    public static int getPlayerDeaths(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getInt("deaths");
    }

    public static List<String> getAllClasses(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getStringList("unlocked_characters");
    }

    public static List<String> getAllHats(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getStringList("unlocked_hats");
    }

    public static boolean getPlayerClass(String p, String c) {
        for (String s : StatsManager.getAllClasses(p)) {
            if (!StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)c)) continue;
            return true;
        }
        return false;
    }

    public static boolean getPlayerHat(String p, String h) {
        for (String s : StatsManager.getAllHats(p)) {
            if (!StringUtils.containsIgnoreCase((CharSequence)s, (CharSequence)h)) continue;
            return true;
        }
        return false;
    }

    public static boolean getPlayerSpawning(String p) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getBoolean("quitingame");
    }

    public static void setPlayerGems(String p, int g, int r, int bonus) {
        FileConfiguration c = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        c.set("gems", (Object)(c.getInt("gems") + g * r + bonus));
        try {
            c.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
            ScoreboardManager.addPlayer(Bukkit.getPlayer((String)p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setPlayerWins(String p, int w) {
        FileConfiguration c = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        c.set("wins", (Object)(c.getInt("wins") + w));
        try {
            c.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setPlayerKills(String p, int k) {
        FileConfiguration c = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        c.set("kills", (Object)(c.getInt("kills") + k));
        try {
            c.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setPlayerDeaths(String p, int d) {
        FileConfiguration c = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        c.set("deaths", (Object)(c.getInt("deaths") + d));
        try {
            c.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addPlayerClass(String p, String c) {
        List<String> ca = StatsManager.getAllClasses(p);
        ca.add(c);
        FileConfiguration co = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        co.set("unlocked_characters", ca);
        try {
            co.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addPlayerHat(String p, String h) {
        List<String> ca = StatsManager.getAllClasses(p);
        ca.add(h);
        FileConfiguration co = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        co.set("unlocked_hats", ca);
        try {
            co.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setPlayerSpawning(String p, boolean b) {
        FileConfiguration c = SuperCraftBrothers.getInstance().getPlayerConfig(p);
        c.set("quitingame", (Object)b);
        try {
            c.save(SuperCraftBrothers.getInstance().getPlayerFile(p));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean getPlayerMap(String p, String m) {
        return SuperCraftBrothers.getInstance().getPlayerConfig(p).getBoolean("map." + m);
    }

    public static boolean createPlayerFile(String p) {
        File f = new File(SuperCraftBrothers.getInstance().getPlayerFile(p));
        if (f.exists()) {
            return true;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
            config.set("rank", (Object)ConfigManager.defaultRank);
            config.set("unlocked_characters", ConfigManager.defaultClasses);
            config.set("unlocked_hats", ConfigManager.defaultHats);
            config.set("gems", (Object)ConfigManager.defaultGems);
            config.set("kills", (Object)ConfigManager.defaultKills);
            config.set("deaths", (Object)ConfigManager.defaultDeaths);
            config.set("wins", (Object)ConfigManager.defaultWins);
            config.set("quitingame", (Object)false);
            config.save(f);
            Bukkit.getLogger().info("[SCB] Created new player file for " + p);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

