/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.menus;

import com.gmail.samsun469.supercraftbrothers.menus.ClassMenu;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ClassMenuIM
implements Listener {
    private String name;
    private int size;
    private Plugin plugin;
    private String[] optionNames;
    private ItemStack[] optionIcons;
    private static Inventory inventory;

    public ClassMenuIM(String name, int size, Plugin plugin) {
        this.name = name;
        this.size = size;
        this.plugin = plugin;
        this.optionNames = new String[size];
        this.optionIcons = new ItemStack[size];
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public ClassMenuIM setOption(int position, ItemStack icon, String name, String ... info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public void open(Player player) {
        if (inventory != null) {
            Inventory i = inventory;
            player.openInventory(i);
            return;
        }
        Inventory i = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        int y = 0;
        while (y < this.optionIcons.length) {
            if (this.optionIcons[y] != null) {
                i.setItem(y, this.optionIcons[y]);
            }
            ++y;
        }
        player.openInventory(i);
        inventory = i;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getTitle().equals(this.name)) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            if (slot >= 0 && slot < this.size && this.optionNames[slot] != null) {
                ClassMenu.onOptionClick((Player)event.getWhoClicked(), slot, event.getInventory().getItem(slot).getItemMeta().getDisplayName());
                final Player p = (Player)event.getWhoClicked();
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        p.closeInventory();
                    }
                }, 1L);
            }
        }
    }

    private ItemStack setItemNameAndLore(ItemStack item, String name, String[] lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(Arrays.asList(lore));
        item.setItemMeta(im);
        return item;
    }
}

