/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.menus;

import com.gmail.samsun469.supercraftbrothers.listeners.PlayerInteract;
import com.gmail.samsun469.supercraftbrothers.menus.VIPClassMenu;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class VIPClassMenuIM
implements Listener {
    private String name;
    private int size;
    private Plugin plugin;
    private String[] optionNames;
    private ItemStack[] optionIcons;
    private static HashMap<String, Inventory> inventories = new HashMap();

    public VIPClassMenuIM(String name, int size, Plugin plugin) {
        this.name = name;
        this.size = size;
        this.plugin = plugin;
        this.optionNames = new String[size];
        this.optionIcons = new ItemStack[size];
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    public VIPClassMenuIM setOption(int position, ItemStack icon, String name, String ... info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public void open(Player player) {
        if (inventories.values().contains(player.getName())) {
            Inventory inventory = inventories.get(player.getName());
            int y = 0;
            while (y < this.optionIcons.length) {
                if (this.optionIcons[y] != null) {
                    inventory.setItem(y, this.optionIcons[y]);
                }
                ++y;
            }
            player.openInventory(inventory);
            inventories.put(player.getName(), inventory);
        } else {
            Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
            int y = 0;
            while (y < this.optionIcons.length) {
                if (this.optionIcons[y] != null) {
                    inventory.setItem(y, this.optionIcons[y]);
                }
                ++y;
            }
            player.openInventory(inventory);
            inventories.put(player.getName(), inventory);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onInventoryClick(InventoryClickEvent event) {
        if (inventories.get(event.getWhoClicked().getName()) != null) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            if (slot >= 0 && slot < this.size && this.optionNames[slot] != null) {
                VIPClassMenu gm = PlayerInteract.vipmenus.get(event.getWhoClicked().getName());
                gm.onOptionClick(event.getInventory().getItem(slot).getItemMeta().getDisplayName());
                inventories.remove(event.getWhoClicked().getName());
                final Player p = (Player)event.getWhoClicked();
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        p.closeInventory();
                    }
                }, 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onInventoryClose(InventoryCloseEvent event) {
        if (inventories.get(event.getPlayer().getName()) != null) {
            inventories.remove(event.getPlayer().getName());
        }
    }

    static void removeFromList(Player p) {
        if (inventories.get(p.getName()) != null) {
            inventories.remove(p.getName());
        }
    }

    private ItemStack setItemNameAndLore(ItemStack item, String name, String[] lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(Arrays.asList(lore));
        item.setItemMeta(im);
        return item;
    }
}

