/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.samsun469.supercraftbrothers.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Updater {
    private Plugin plugin;
    private UpdateType type;
    private String versionTitle;
    private String versionLink;
    private long totalSize;
    private int sizeLine;
    private int multiplier;
    private boolean announce;
    private URL url;
    private File file;
    private Thread thread;
    private static final String DBOUrl = "http://dev.bukkit.org/server-mods/";
    private String[] noUpdateTag = new String[]{"-PRE", "-SNAPSHOT"};
    private static final int BYTE_SIZE = 1024;
    private String updateFolder = YamlConfiguration.loadConfiguration((File)new File("bukkit.yml")).getString("settings.update-folder");
    private UpdateResult result = UpdateResult.SUCCESS;
    private static final String TITLE = "title";
    private static final String LINK = "link";
    private static final String ITEM = "item";

    public Updater(Plugin plugin, String slug, File file, UpdateType type, boolean announce) {
        this.plugin = plugin;
        this.type = type;
        this.announce = announce;
        this.file = file;
        try {
            this.url = new URL(DBOUrl + slug + "/files.rss");
        }
        catch (MalformedURLException ex) {
            plugin.getLogger().warning("The author of this plugin (" + (String)plugin.getDescription().getAuthors().get(0) + ") has misconfigured their Auto Update system");
            plugin.getLogger().warning("The project slug given ('" + slug + "') is invalid. Please nag the author about this.");
            this.result = UpdateResult.FAIL_BADSLUG;
        }
        this.thread = new Thread(new UpdateRunnable());
        this.thread.start();
    }

    public UpdateResult getResult() {
        this.waitForThread();
        return this.result;
    }

    public long getFileSize() {
        this.waitForThread();
        return this.totalSize;
    }

    public String getLatestVersionString() {
        this.waitForThread();
        return this.versionTitle;
    }

    public void waitForThread() {
        if (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveFile(File folder, String file, String u) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            try {
                int count;
                URL url = new URL(u);
                int fileLength = url.openConnection().getContentLength();
                in = new BufferedInputStream(url.openStream());
                fout = new FileOutputStream(String.valueOf(folder.getAbsolutePath()) + "/" + file);
                byte[] data = new byte[1024];
                if (this.announce) {
                    this.plugin.getLogger().info("About to download a new update: " + this.versionTitle);
                }
                long downloaded = 0L;
                while ((count = in.read(data, 0, 1024)) != -1) {
                    fout.write(data, 0, count);
                    int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                    if (!(this.announce & percent % 10 == 0)) continue;
                    this.plugin.getLogger().info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
                }
                File[] fileArray = new File("plugins/" + this.updateFolder).listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File xFile = fileArray[n2];
                    if (xFile.getName().endsWith(".zip")) {
                        xFile.delete();
                    }
                    ++n2;
                }
                File dFile = new File(String.valueOf(folder.getAbsolutePath()) + "/" + file);
                if (dFile.getName().endsWith(".zip")) {
                    this.unzip(dFile.getCanonicalPath());
                }
                if (this.announce) {
                    this.plugin.getLogger().info("Finished updating.");
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("The auto-updater tried to download a new update, but was unsuccessful.");
                this.result = UpdateResult.FAIL_DOWNLOAD;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void unzip(String file) {
        try {
            File fSourceZip = new File(file);
            String zipPath = file.substring(0, file.length() - 4);
            ZipFile zipFile = new ZipFile(fSourceZip);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                int b;
                ZipEntry entry = e.nextElement();
                File destinationFilePath = new File(zipPath, entry.getName());
                destinationFilePath.getParentFile().mkdirs();
                if (entry.isDirectory()) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] buffer = new byte[1024];
                FileOutputStream fos = new FileOutputStream(destinationFilePath);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
                while ((b = bis.read(buffer, 0, 1024)) != -1) {
                    bos.write(buffer, 0, b);
                }
                bos.flush();
                bos.close();
                bis.close();
                String name = destinationFilePath.getName();
                if (name.endsWith(".jar") && this.pluginFile(name)) {
                    destinationFilePath.renameTo(new File("plugins/" + this.updateFolder + "/" + name));
                }
                entry = null;
                destinationFilePath = null;
            }
            e = null;
            zipFile.close();
            zipFile = null;
            File[] fileArray = new File(zipPath).listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dFile = fileArray[n2];
                if (dFile.isDirectory() && this.pluginFile(dFile.getName())) {
                    File oFile = new File("plugins/" + dFile.getName());
                    File[] contents = oFile.listFiles();
                    File[] fileArray2 = dFile.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File cFile = fileArray2[n4];
                        boolean found = false;
                        File[] fileArray3 = contents;
                        int n5 = contents.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            File xFile = fileArray3[n6];
                            if (xFile.getName().equals(cFile.getName())) {
                                found = true;
                                break;
                            }
                            ++n6;
                        }
                        if (!found) {
                            cFile.renameTo(new File(oFile.getCanonicalFile() + "/" + cFile.getName()));
                        } else {
                            cFile.delete();
                        }
                        ++n4;
                    }
                }
                dFile.delete();
                ++n2;
            }
            new File(zipPath).delete();
            fSourceZip.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater tried to unzip a new update file, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DOWNLOAD;
        }
        new File(file).delete();
    }

    public boolean pluginFile(String name) {
        File[] fileArray = new File("plugins").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getFile(String link) {
        String download = null;
        try {
            String line;
            URL url = new URL(link);
            URLConnection urlConn = url.openConnection();
            InputStreamReader inStream = new InputStreamReader(urlConn.getInputStream());
            BufferedReader buff = new BufferedReader(inStream);
            int counter = 0;
            while ((line = buff.readLine()) != null) {
                ++counter;
                if (line.contains("<li class=\"user-action user-action-download\">")) {
                    download = line.split("<a href=\"")[1].split("\">Download</a>")[0];
                    continue;
                }
                if (line.contains("<dt>Size</dt>")) {
                    this.sizeLine = counter + 1;
                    continue;
                }
                if (counter != this.sizeLine) continue;
                String size = line.replaceAll("<dd>", "").replaceAll("</dd>", "");
                this.multiplier = size.contains("MiB") ? 0x100000 : 1024;
                size = size.replace(" KiB", "").replace(" MiB", "");
                this.totalSize = (long)(Double.parseDouble(size) * (double)this.multiplier);
            }
            urlConn = null;
            inStream = null;
            buff.close();
            buff = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.plugin.getLogger().warning("The auto-updater tried to contact dev.bukkit.org, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DBO;
            return null;
        }
        return download;
    }

    private boolean versionCheck(String title) {
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String version = this.plugin.getDescription().getVersion();
            if (title.split(" v").length == 2) {
                String remoteVersion = title.split(" v")[1].split(" ")[0];
                int remVer = -1;
                int curVer = 0;
                try {
                    remVer = this.calVer(remoteVersion);
                    curVer = this.calVer(version);
                }
                catch (NumberFormatException nfe) {
                    remVer = -1;
                }
                if (this.hasTag(version) || version.equalsIgnoreCase(remoteVersion) || curVer >= remVer) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                this.plugin.getLogger().warning("The author of this plugin (" + (String)this.plugin.getDescription().getAuthors().get(0) + ") has misconfigured their Auto Update system");
                this.plugin.getLogger().warning("Files uploaded to BukkitDev should contain the version number, seperated from the name by a 'v', such as PluginName v1.0");
                this.plugin.getLogger().warning("Please notify the author of this error.");
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    private Integer calVer(String s) throws NumberFormatException {
        if (s.contains(".")) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                Character c = Character.valueOf(s.charAt(i));
                if (Character.isLetterOrDigit(c.charValue())) {
                    sb.append(c);
                }
                ++i;
            }
            return Integer.parseInt(sb.toString());
        }
        return Integer.parseInt(s);
    }

    private boolean hasTag(String version) {
        String[] stringArray = this.noUpdateTag;
        int n = this.noUpdateTag.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (version.contains(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean readFeed() {
        try {
            String title = "";
            String link = "";
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            InputStream in = this.read();
            if (in != null) {
                XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (event.isStartElement()) {
                        if (event.asStartElement().getName().getLocalPart().equals(TITLE)) {
                            event = eventReader.nextEvent();
                            title = event.asCharacters().getData();
                            continue;
                        }
                        if (!event.asStartElement().getName().getLocalPart().equals(LINK)) continue;
                        event = eventReader.nextEvent();
                        link = event.asCharacters().getData();
                        continue;
                    }
                    if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(ITEM)) continue;
                    this.versionTitle = title;
                    this.versionLink = link;
                    break;
                }
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            this.plugin.getLogger().warning("Could not reach dev.bukkit.org for update checking. Is it offline?");
            return false;
        }
    }

    private InputStream read() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not reach BukkitDev file stream for update checking. Is dev.bukkit.org offline?");
            return null;
        }
    }

    public static enum UpdateResult {
        SUCCESS,
        NO_UPDATE,
        FAIL_DOWNLOAD,
        FAIL_DBO,
        FAIL_NOVERSION,
        FAIL_BADSLUG,
        UPDATE_AVAILABLE;

    }

    private class UpdateRunnable
    implements Runnable {
        private UpdateRunnable() {
        }

        @Override
        public void run() {
            if (Updater.this.url != null && Updater.this.readFeed() && Updater.this.versionCheck(Updater.this.versionTitle)) {
                String fileLink = Updater.this.getFile(Updater.this.versionLink);
                if (fileLink != null && Updater.this.type != UpdateType.NO_DOWNLOAD) {
                    String name = Updater.this.file.getName();
                    if (fileLink.endsWith(".zip")) {
                        String[] split = fileLink.split("/");
                        name = split[split.length - 1];
                    }
                    Updater.this.saveFile(new File("plugins/" + Updater.this.updateFolder), name, fileLink);
                } else {
                    Updater.this.result = UpdateResult.UPDATE_AVAILABLE;
                }
            }
        }
    }

    public static enum UpdateType {
        DEFAULT,
        NO_VERSION_CHECK,
        NO_DOWNLOAD;

    }
}

