/*
 * Decompiled with CFR 0.152.
 */
package me.unrealpowerz.commandhandler;

import java.util.HashMap;
import me.unrealpowerz.commandhandler.IUnrealExecutor;
import me.unrealpowerz.commandhandler.UnrealCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnrealCommandHandler
implements CommandExecutor {
    private HashMap<String, UnrealCommand> registeredCommands = new HashMap();
    private final String INVALID_MESSAGE = ChatColor.RED + "Invalid arguments!";
    private final String PLAYER_ONLY_MESSAGE = ChatColor.RED + "This command can only be executed by a player!";
    private final String NO_PERMISSION_MESSAGE = ChatColor.RED + "You don't have the right permissions to use this command.";
    private String prefix = "";
    private final IUnrealExecutor defaultExe;

    public UnrealCommandHandler(IUnrealExecutor defaultExe) {
        this.defaultExe = defaultExe;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void registerCommand(UnrealCommand ... command) {
        for (UnrealCommand i : command) {
            this.registeredCommands.put(i.getCmd(), i);
        }
    }

    public boolean onCommand(CommandSender sender, Command string, String label, String[] args) {
        if (args.length != 0) {
            if (this.registeredCommands.containsKey(args[0])) {
                UnrealCommand triggeredCommand = this.registeredCommands.get(args[0]);
                if (sender instanceof Player) {
                    if (triggeredCommand.getPerm() == null || sender.hasPermission(triggeredCommand.getPerm())) {
                        if (args.length >= triggeredCommand.getMinArgs() && args.length <= triggeredCommand.getMaxArgs()) {
                            triggeredCommand.getCommandExe().run(sender, string, label, args);
                            return true;
                        }
                        sender.sendMessage(this.prefix + this.INVALID_MESSAGE);
                        return true;
                    }
                    sender.sendMessage(this.prefix + this.NO_PERMISSION_MESSAGE);
                    return true;
                }
                if (triggeredCommand.getConsoleExeAble()) {
                    if (args.length >= triggeredCommand.getMinArgs() && args.length <= triggeredCommand.getMaxArgs()) {
                        triggeredCommand.getCommandExe().run(sender, string, label, args);
                        return true;
                    }
                    sender.sendMessage(this.prefix + this.INVALID_MESSAGE);
                    return true;
                }
                sender.sendMessage(this.prefix + this.PLAYER_ONLY_MESSAGE);
                return true;
            }
            sender.sendMessage(this.prefix + this.INVALID_MESSAGE);
            return true;
        }
        this.defaultExe.run(sender, string, label, args);
        return true;
    }
}

