/*
 * Decompiled with CFR 0.152.
 */
package me.unrealpowerz.fireworkarrows.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.unrealpowerz.fireworkarrows.ArrowType;
import me.unrealpowerz.fireworkarrows.FireworkArrows;
import me.unrealpowerz.fireworkarrows.arrowtypes.BasicArrow;
import me.unrealpowerz.fireworkarrows.arrowtypes.FireworkArrow;
import me.unrealpowerz.fireworkarrows.arrowtypes.RocketArrow;
import me.unrealpowerz.fireworkarrows.tasks.AutoExplodeTask;
import me.unrealpowerz.fireworkarrows.utils.FireworkEffectPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ArrowTypeHandler
implements Listener {
    @EventHandler
    public void onBowDraw(PlayerInteractEvent e) {
        ItemStack heldItem = e.getPlayer().getItemInHand();
        if (heldItem != null && heldItem.getType() == Material.BOW && (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) && FireworkArrows.plugin.getConfig().getBoolean("enabled")) {
            ArrowType arrowType;
            ItemStack arrow;
            boolean infinity = e.getPlayer().getItemInHand().containsEnchantment(Enchantment.ARROW_INFINITE) && e.getPlayer().getGameMode() != GameMode.CREATIVE;
            int slot = e.getPlayer().getInventory().first(Material.ARROW);
            ItemStack itemStack = arrow = slot != -1 ? e.getPlayer().getInventory().getItem(slot) : null;
            if (arrow != null && (arrowType = ArrowType.getTypeByItem(arrow)) != null) {
                if (arrowType == ArrowType.FIREWORKARROW) {
                    if (arrow.getItemMeta().getLore().size() != 1) {
                        this.submitArrow(this.parseFireworkArrow(arrow, e.getPlayer(), infinity));
                    }
                } else if (arrowType == ArrowType.ROCKET_ARROW) {
                    this.submitArrow(new RocketArrow(e.getPlayer().getName(), infinity));
                } else {
                    FireworkArrows.plugin.getLogger().warning("An unimplemented arrow-type has been used by " + e.getPlayer().getName() + ". This may cause issues!");
                }
            }
        }
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Player shooter;
        if (event.getEntity().getShooter() instanceof Player && event.getEntity() instanceof Arrow && FireworkArrows.plugin.getConfig().getBoolean("enabled") && BasicArrow.arrowsToBeShot.containsKey((shooter = (Player)event.getEntity().getShooter()).getName())) {
            BasicArrow basicArrow = BasicArrow.arrowsToBeShot.get(shooter.getName());
            if (basicArrow instanceof FireworkArrow && FireworkArrows.plugin.getConfig().getBoolean("fireworkarrow.explode-after-20-ticks")) {
                ((FireworkArrow)basicArrow).setTaskId(new AutoExplodeTask((Arrow)event.getEntity()).runTaskLater(FireworkArrows.plugin, 20L).getTaskId());
            }
            if (basicArrow.isInfinity()) {
                int index = shooter.getInventory().first(Material.ARROW);
                int newAmount = shooter.getInventory().getItem(index).getAmount() - 1;
                if (newAmount > 0) {
                    shooter.getInventory().getItem(index).setAmount(newAmount);
                } else {
                    Bukkit.getPlayer((String)basicArrow.getShooter()).getInventory().removeItem(new ItemStack[]{shooter.getInventory().getItem(index)});
                }
            }
            BasicArrow.shotArrows.put(event.getEntity().getUniqueId(), basicArrow);
            BasicArrow.arrowsToBeShot.remove(shooter.getName());
        }
    }

    @EventHandler
    public void onProjectileHitEvent(ProjectileHitEvent event) {
        Arrow arrow;
        if (FireworkArrows.plugin.getConfig().getBoolean("enabled") && event.getEntity() instanceof Arrow && BasicArrow.shotArrows.containsKey((arrow = (Arrow)event.getEntity()).getUniqueId()) && BasicArrow.shotArrows.get(arrow.getUniqueId()) instanceof FireworkArrow) {
            FireworkArrow fireworkArrow = (FireworkArrow)BasicArrow.shotArrows.get(arrow.getUniqueId());
            try {
                FireworkEffectPlayer.playFirework(arrow.getWorld(), arrow.getLocation(), fireworkArrow.getEffect());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fireworkArrow.getTaskId() != -1) {
                FireworkArrows.plugin.getServer().getScheduler().cancelTask(fireworkArrow.getTaskId());
            }
            if (FireworkArrows.plugin.getConfig().getBoolean("fireworkarrow.remove-arrow-on-explosion.on-ground")) {
                arrow.remove();
            }
        }
    }

    List<Color> stringToColors(String[] string) {
        if (string != null) {
            ArrayList<Color> colors = new ArrayList<Color>();
            for (String currentString : string) {
                Color customColor;
                if (currentString == null) continue;
                if (currentString.equals("White")) {
                    colors.add(Color.fromRGB((int)0xF0F0F0));
                    continue;
                }
                if (currentString.equals("Cyan")) {
                    colors.add(Color.fromRGB((int)2651799));
                    continue;
                }
                if (currentString.equals("Purple")) {
                    colors.add(Color.fromRGB((int)8073150));
                    continue;
                }
                if (currentString.equals("Blue")) {
                    colors.add(Color.fromRGB((int)2437522));
                    continue;
                }
                if (currentString.equals("Red")) {
                    colors.add(Color.fromRGB((int)11743532));
                    continue;
                }
                if (currentString.equals("Light Blue")) {
                    colors.add(Color.fromRGB((int)6719955));
                    continue;
                }
                if (currentString.equals("Yellow")) {
                    colors.add(Color.fromRGB((int)14602026));
                    continue;
                }
                if (currentString.equals("Green")) {
                    colors.add(Color.fromRGB((int)3887386));
                    continue;
                }
                if (currentString.equals("Pink")) {
                    colors.add(Color.fromRGB((int)14188952));
                    continue;
                }
                if (currentString.equals("Gray")) {
                    colors.add(Color.fromRGB((int)0x434343));
                    continue;
                }
                if (currentString.equals("Lime")) {
                    colors.add(Color.fromRGB((int)4312372));
                    continue;
                }
                if (currentString.equals("Magenta")) {
                    colors.add(Color.fromRGB((int)12801229));
                    continue;
                }
                if (currentString.equals("Orange")) {
                    colors.add(Color.fromRGB((int)15435844));
                    continue;
                }
                if (currentString.equals("Black")) {
                    colors.add(Color.fromRGB((int)0x1E1B1B));
                    continue;
                }
                if (currentString.equals("Light Gray")) {
                    colors.add(Color.fromRGB((int)0xABABAB));
                    continue;
                }
                try {
                    customColor = Color.fromRGB((int)Integer.parseInt(currentString));
                }
                catch (Exception e) {
                    continue;
                }
                colors.add(customColor);
            }
            return colors;
        }
        return null;
    }

    private FireworkArrow parseFireworkArrow(ItemStack item, Player player, boolean infinity) {
        boolean fireworkFlicker = false;
        boolean fireworkTrail = false;
        FireworkEffect.Type fireworkShape = ((String)item.getItemMeta().getLore().get(1)).equals("\u00a7r\u00a77Small Ball") ? FireworkEffect.Type.BALL : (((String)item.getItemMeta().getLore().get(1)).equals("\u00a7r\u00a77Large Ball") ? FireworkEffect.Type.BALL_LARGE : (((String)item.getItemMeta().getLore().get(1)).equals("\u00a7r\u00a77Star-shaped") ? FireworkEffect.Type.STAR : (((String)item.getItemMeta().getLore().get(1)).equals("\u00a7r\u00a77Creeper-shaped") ? FireworkEffect.Type.CREEPER : (((String)item.getItemMeta().getLore().get(1)).equals("\u00a7r\u00a77Burst") ? FireworkEffect.Type.BURST : FireworkEffect.Type.BALL))));
        String[] itemColors = ((String)item.getItemMeta().getLore().get(2)).split(", ");
        itemColors[0] = itemColors[0].substring(4);
        List<Color> itemColorList = this.stringToColors(itemColors);
        List<Color> itemFadeColorList = null;
        if (!FireworkArrows.plugin.getConfig().getBoolean("fireworkarrow.simplify-fireworks") && item.getItemMeta().getLore().size() >= 4) {
            if (((String)item.getItemMeta().getLore().get(3)).startsWith("\u00a7r\u00a77Fade to ")) {
                String[] itemFadeColors = ((String)item.getItemMeta().getLore().get(3)).split(", ");
                itemFadeColors[0] = itemFadeColors[0].substring(12);
                itemFadeColorList = this.stringToColors(itemFadeColors);
            } else if (((String)item.getItemMeta().getLore().get(3)).equals("\u00a7r\u00a77Trail")) {
                fireworkTrail = true;
            } else if (((String)item.getItemMeta().getLore().get(3)).equals("\u00a7r\u00a77Twinkle")) {
                fireworkFlicker = true;
            }
            if (item.getItemMeta().getLore().size() >= 5) {
                if (((String)item.getItemMeta().getLore().get(4)).equals("\u00a7r\u00a77Trail")) {
                    fireworkTrail = true;
                } else if (((String)item.getItemMeta().getLore().get(4)).equals("\u00a7r\u00a77Twinkle")) {
                    fireworkFlicker = true;
                }
                if (item.getItemMeta().getLore().size() >= 6 && ((String)item.getItemMeta().getLore().get(3)).equals("\u00a7r\u00a77Twinkle")) {
                    fireworkTrail = true;
                }
            }
        }
        return new FireworkArrow(player.getName(), infinity, fireworkShape, itemColorList == null || itemColorList.size() == 0 ? Arrays.asList(Color.RED) : itemColorList, itemFadeColorList == null ? new ArrayList<Color>() : itemFadeColorList, fireworkFlicker, fireworkTrail);
    }

    private void submitArrow(BasicArrow arrow) {
        String shooter = arrow.getShooter();
        if (BasicArrow.arrowsToBeShot.containsKey(shooter)) {
            BasicArrow.arrowsToBeShot.remove(shooter);
        }
        BasicArrow.arrowsToBeShot.put(shooter, arrow);
    }
}

