/*
 * Decompiled with CFR 0.152.
 */
package me.unrealpowerz.fireworkarrows.tasks;

import java.util.Arrays;
import me.unrealpowerz.fireworkarrows.arrowtypes.RocketArrow;
import me.unrealpowerz.fireworkarrows.utils.FireworkEffectPlayer;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class RocketArrowTask
extends BukkitRunnable {
    private final LivingEntity target;
    private final boolean killTarget;
    private int cycleCount = 5;

    public RocketArrowTask(LivingEntity target, boolean killTarget) {
        this.target = target;
        this.killTarget = killTarget;
    }

    public void run() {
        if (this.cycleCount == 5) {
            this.target.setVelocity(new Vector(0, 1, 0).multiply(7));
            --this.cycleCount;
        } else if (this.cycleCount > 0) {
            this.target.getWorld().playEffect(this.target.getLocation(), Effect.SMOKE, 0);
            --this.cycleCount;
        } else {
            try {
                FireworkEffectPlayer.playFirework(this.target.getWorld(), this.target.getLocation(), FireworkEffect.builder().with(FireworkEffect.Type.BALL).withColor(Arrays.asList(Color.fromRGB((int)11743532))).withFade(Arrays.asList(Color.fromRGB((int)15435844))).withFlicker().withTrail().build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.killTarget) {
                this.target.setHealth(0.0);
            }
            RocketArrow.rocketTarget.remove(this.target.getUniqueId());
            this.cancel();
        }
    }
}

