/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.ichanels.ETypeChanel;
import ru.dark32.chat.ichanels.IChanel;
import ru.dark32.chat.ichanels.IItemChanel;

public class ChanelRegister {
    private static int index = 0;
    public static List<IChanel> listChat;
    private static int defaultChanel;
    public static boolean switchByPrefix;

    public static void init() {
        listChat = new ArrayList<IChanel>();
        ConfigurationSection chtatList = Main.chatConfig.getConfigurationSection("Chat");
        if (chtatList == null) {
            Bukkit.getConsoleSender().sendMessage("Error. Chanel not found");
            return;
        }
        Set list = chtatList.getKeys(false);
        for (String name : list) {
            String _type = "Chat." + name + ".type";
            String _enable = "Chat." + name + ".enable";
            String chanelType = Main.chatConfig.getString(_type, _type);
            boolean chanelEnable = Main.chatConfig.getBoolean(_enable, false);
            if (!chanelEnable || chanelType.equals("none")) continue;
            listChat.add(ChanelRegister.registrChanel(ETypeChanel.get(chanelType), name));
        }
        switchByPrefix = Main.config.getBoolean("switchByPrefix", false);
    }

    public static int getDefaultChanel(Player player) {
        for (IChanel chat : listChat) {
            if (!chat.isDefaultForGrop(Main.getPermissionsHandler().getGroup(player))) continue;
            return chat.getIndex();
        }
        return defaultChanel;
    }

    private static IChanel registrChanel(ETypeChanel type, String name) {
        IChanel chanel = type.setChanel(name);
        chanel.setType(type);
        if (Main.chatConfig.getBoolean("Chat." + name + ".default", false)) {
            defaultChanel = chanel.getIndex();
        }
        return chanel;
    }

    public static int getNextIndex() {
        return index++;
    }

    public static int getCurrectIndex() {
        return index;
    }

    public static IChanel getByIndex(int id) {
        if (id > listChat.size()) {
            id = defaultChanel;
        }
        return listChat.get(id);
    }

    public static int getIndexBySign(char sign) {
        for (IChanel chanel : listChat) {
            if (chanel.getSign() != sign) continue;
            return chanel.getIndex();
        }
        return -1;
    }

    public static int getIndexByInnerName(String sign) {
        for (IChanel chanel : listChat) {
            if (!chanel.getInnerName().equalsIgnoreCase(sign)) continue;
            return chanel.getIndex();
        }
        return -1;
    }

    public static int getIndexBySignOrByInnerName(CommandSender sender, String par2) {
        return par2.length() > 0 ? (par2.length() == 1 ? ChanelRegister.getIndexBySign(par2.charAt(0)) : ChanelRegister.getIndexByInnerName(par2)) : -1;
    }

    public static int getIndexByItem(ItemStack item) {
        for (IChanel chanel : listChat) {
            if (chanel.getType() != ETypeChanel.ITEM && chanel.getType() != ETypeChanel.RANGE_ITEM && chanel.getType() != ETypeChanel.REQUISITE || !((IItemChanel)chanel).equalItem(item) || ((IItemChanel)chanel).isRequestPprefix()) continue;
            return chanel.getIndex();
        }
        return -1;
    }

    public static int getIndexByPrefix(Player sender, char preffix) {
        for (IChanel chanel : listChat) {
            if (chanel.getPrefix() == '\u0000' || chanel.getPrefix() != preffix || chanel.isNeedPerm() && !Main.getPermissionsHandler().hasPermission((CommandSender)sender, "mcnw.spy") && !Main.getPermissionsHandler().hasPermission((CommandSender)sender, "mcnw." + chanel.getInnerName() + ".say")) continue;
            return chanel.getIndex();
        }
        return -1;
    }

    public static String colorUTF8(String string, int flag) {
        if ((flag & 1) == 1) {
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        }
        if ((flag & 2) == 2) {
            string = Util.parseUTF8(string);
        }
        return string;
    }

    public static int getChanels() {
        return listChat.size();
    }
}

