/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.Main;
import ru.dark32.chat.Mute;
import ru.dark32.chat.Util;
import ru.dark32.chat.ValueStorage;
import ru.dark32.chat.ichanels.IChanel;

public class ChatListener
implements Listener {
    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        String message = event.getMessage();
        String format = "";
        char prefix = message.charAt(0);
        int prefixChanel = ChanelRegister.getIndexByPrefix(sender, prefix);
        int itemChanel = ChanelRegister.getIndexByItem(sender.getItemInHand());
        int indexChanel = Util.getModeIndex(sender.getName());
        if (itemChanel != -1) {
            indexChanel = itemChanel;
        }
        if (message.length() > 1) {
            if (prefixChanel != -1) {
                indexChanel = prefixChanel;
                message = message.substring(1).trim();
            }
        } else if (ChanelRegister.switchByPrefix && prefixChanel != -1 && Util.setChatMode(sender.getName(), prefixChanel)) {
            event.setCancelled(true);
            return;
        }
        IChanel chanel = ChanelRegister.getByIndex(indexChanel);
        if (this.hasMute(sender, indexChanel).booleanValue()) {
            event.setCancelled(true);
            return;
        }
        if (chanel.isNeedPerm() && !Main.getPermissionsHandler().hasPermission((CommandSender)sender, "mcnw." + chanel.getInnerName() + ".say")) {
            sender.sendMessage(ValueStorage.noPerm.replace("$1", chanel.getName()));
            event.setCancelled(true);
            return;
        }
        if (!chanel.canSend(sender, message)) {
            event.setCancelled(true);
            return;
        }
        message = chanel.preformatMessage(sender, message);
        event.getRecipients().clear();
        Set<Player> recipient = chanel.getRecipients(sender);
        chanel.preSend(sender, message, recipient);
        recipient.addAll(chanel.getSpyRecipients(sender));
        event.getRecipients().addAll(recipient);
        format = chanel.format(sender, chanel.getFormat());
        event.setFormat(format);
        event.setMessage(message);
    }

    private Boolean hasMute(Player player, int indexChanel) {
        if (Main.getBanStorage().isMuted(player.getName(), indexChanel)) {
            String msg = ValueStorage.muteMessage;
            long time = Main.getBanStorage().getTimeMute(player.getName(), indexChanel);
            msg = Mute.unParseTime(msg, time);
            msg = Util.suffixLatter(msg);
            player.sendMessage(msg);
            return true;
        }
        return false;
    }
}

