/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.IDeaf;
import ru.dark32.chat.Main;
import ru.dark32.chat.ValueStorage;

public class Deaf
implements IDeaf {
    private final transient int chaneles = ChanelRegister.getChanels();
    private final String canTHelp = this.getLoc("deaf.canTHelp");
    private final String canTSeeSelf = this.getLoc("deaf.canTSeeSelf");
    private final String udeafSelf = this.getLoc("deaf.udeafSelf");
    private final String canTSeeAllDeaf = this.getLoc("deaf.canTSeeAllDeaf");
    private final String canTSeeTargetDeaf = this.getLoc("deaf.canTSeeTargetDeaf");
    private final String signMoreOne = this.getLoc("deaf.signMoreOne");
    private final String canTUndeafSelf = this.getLoc("deaf.canTUndeafSelf");
    private final String canTUndeafTarget = this.getLoc("deaf.canTUndeafTarget");
    private final String canTDeafSelf = this.getLoc("deaf.canTDeafSelf");
    private final String canTDeafTarget = this.getLoc("deaf.canTDeafTarget");
    private final String deafMessage = this.getLoc("deaf.deafMessage");
    private final String noReason = this.getLoc("deaf.noReason");
    private final String undeafMessage = this.getLoc("deaf.undeafMessage");
    private final String deafMessage2 = this.getLoc("deaf.deafMessage2");

    private String getLoc(String key) {
        return ChanelRegister.colorUTF8(Main.localeConfig.getString(key, key), 3);
    }

    private String getPlayerDeafString(String playerName, int chanel) {
        return playerName.toLowerCase(Locale.US) + ".deaf." + ChanelRegister.getByIndex(chanel).getInnerName();
    }

    @Override
    public void deaf(String[] args, CommandSender sender) {
        boolean hasHelp = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.help");
        boolean hasSee = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.see");
        boolean hasAll = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.all");
        boolean hasSeeSelf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.see.self") || hasSee;
        boolean hasDeaf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.deaf");
        boolean hasDeafSelf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.deaf.self") || hasDeaf;
        boolean hasUnDeaf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.undeaf");
        boolean hasUnDeafSelf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.deaf.undeaf.self") || hasUnDeaf;
        String target = args.length > 0 ? args[0] : sender.getName();
        boolean isSelf = sender.getName().equalsIgnoreCase(target);
        if (args.length == 0) {
            if (!hasHelp) {
                sender.sendMessage(this.canTHelp);
                return;
            }
            this.deafHelp(sender);
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("see")) {
                if (!hasSeeSelf) {
                    sender.sendMessage(this.canTSeeSelf);
                    return;
                }
                sender.sendMessage(this.udeafSelf);
                this.seeSelf(sender);
            } else if (args[0].equalsIgnoreCase("all")) {
                if (!hasAll) {
                    sender.sendMessage(this.canTSeeAllDeaf);
                    return;
                }
                this.seeAll(sender);
            } else {
                if (!hasSee) {
                    sender.sendMessage(this.canTSeeTargetDeaf);
                    return;
                }
                sender.sendMessage(ChatColor.GRAY + "$" + target + " :");
                this.seeTarget(sender, target);
            }
        } else if (args.length > 1) {
            String reason;
            int chanel = ChanelRegister.getIndexBySignOrByInnerName(sender, args[1]);
            if (args.length > 2 && args[2].equals("undeaf")) {
                if (isSelf) {
                    if (!hasUnDeafSelf) {
                        sender.sendMessage(this.canTUndeafSelf);
                        return;
                    }
                    this.caseUnDeaf(sender, target, chanel);
                    return;
                }
                if (!hasUnDeaf) {
                    sender.sendMessage(this.canTUndeafTarget);
                    return;
                }
                this.caseUnDeaf(sender, target, chanel);
                return;
            }
            String string = reason = args.length >= 3 ? StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length) : this.noReason;
            if (isSelf) {
                if (!hasDeafSelf) {
                    sender.sendMessage(this.canTDeafSelf);
                    return;
                }
                this.caseDeaf(sender, target, chanel, reason);
                return;
            }
            if (!hasDeaf) {
                sender.sendMessage(this.canTDeafTarget);
                return;
            }
            this.caseDeaf(sender, target, chanel, reason);
            return;
        }
    }

    @Override
    public void seeAll(CommandSender sender) {
        Configuration cs = Main.storage.getRoot();
        sender.sendMessage(ChatColor.GRAY + "$===============all================");
        if (cs == null) {
            return;
        }
        Set list = cs.getKeys(false);
        for (String name : list) {
            this.seeTarget(sender, name);
        }
    }

    @Override
    public void seeSelf(CommandSender sender) {
        this.seeTarget(sender, sender.getName());
    }

    @Override
    public void seeTarget(CommandSender sender, String name) {
        for (int i = 0; i < this.chaneles; ++i) {
            String reason = Main.storage.getString(this.getPlayerDeafString(name, i) + "-reason", "");
            if (!this.isDeaf(name, i)) continue;
            sender.sendMessage(this.deafMessage.replace("$name", name).replace("$channel", ChanelRegister.getByIndex(i).getName()).replace("$reason", reason));
        }
    }

    private void deafHelp(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.addAll(ValueStorage.deafHelp);
        for (String string : msg) {
            sender.sendMessage(ChanelRegister.colorUTF8(string, 3));
        }
    }

    @Override
    public void caseDeaf(CommandSender sender, String name, int chanel, String reason) {
        for (int i = 0; i < this.chaneles; ++i) {
            if (chanel != i && chanel != -1) continue;
            Main.storage.set(this.getPlayerDeafString(name, i), (Object)true);
            Main.storage.set(this.getPlayerDeafString(name, i) + "-reason", (Object)reason);
        }
        sender.sendMessage(this.deafMessage2.replace("$name", name).replace("$channel", chanel >= 0 && chanel < this.chaneles ? ChanelRegister.getByIndex(chanel).getName() : "all").replace("$reason", reason));
        this.save();
    }

    @Override
    public void caseUnDeaf(CommandSender sender, String name, int chanel) {
        for (int i = 0; i < this.chaneles; ++i) {
            if (chanel != i && chanel != -1) continue;
            Main.storage.set(this.getPlayerDeafString(name, i), (Object)false);
            Main.storage.set(this.getPlayerDeafString(name, i) + "-reason", null);
        }
        sender.sendMessage(this.undeafMessage.replace("$name", name).replace("$channel", chanel >= 0 && chanel < this.chaneles ? ChanelRegister.getByIndex(chanel).getName() : "all"));
    }

    @Override
    public boolean isDeaf(String name, int chanel) {
        return Main.storage.getBoolean(this.getPlayerDeafString(name, chanel));
    }

    @Override
    public void save() {
        try {
            Main.storage.save(Main.storageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

