/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.IIgnore;
import ru.dark32.chat.Main;
import ru.dark32.chat.ValueStorage;

public class Ignore
implements IIgnore {
    private final int chaneles = ChanelRegister.getChanels();
    private String message2;
    private String cantIgnorable;
    private String message;
    private String unIgnore;
    private String canTHelp = this.getLoc("ignore.canTHelp");
    private String canTSeeSelf;
    private String canTSeeAll;
    private String canTSeeTarget;
    private String canTUnIgnoreTarget;
    private String canTIgnore;
    private String noReason;

    public Ignore() {
        this.message2 = this.getLoc("ignore.Message2");
        this.message = this.getLoc("ignore.Message");
        this.cantIgnorable = this.getLoc("ignore.cantIgnorable");
        this.unIgnore = this.getLoc("ignore.unIgnore");
        this.canTSeeAll = this.getLoc("ignore.canTSeeAll");
        this.canTSeeSelf = this.getLoc("ignore.canTSeeSelf");
        this.canTIgnore = this.getLoc("ignore.canTIgnore");
        this.canTSeeTarget = this.getLoc("ignore.canTSeeTarget");
        this.canTUnIgnoreTarget = this.getLoc("ignore.canTUnIgnoreTarget");
        this.noReason = this.getLoc("ignore.noReason");
    }

    private String getLoc(String key) {
        return ChanelRegister.colorUTF8(Main.localeConfig.getString(key, key), 3);
    }

    private String getPlayerDeafString(String playerName, String targetName, int chanel) {
        return playerName.toLowerCase(Locale.US) + ".ignore." + targetName + "." + ChanelRegister.getByIndex(chanel).getInnerName();
    }

    @Override
    public boolean hasIgnore(String sender, String target, int chanel) {
        return !this.hasntIgnorable(target) && Main.storage.getBoolean(this.getPlayerDeafString(sender, target, chanel));
    }

    @Override
    public void caseIgnore(CommandSender sender, String target, int chanel, String reason) {
        if (this.hasntIgnorable(target)) {
            sender.sendMessage(this.cantIgnorable.replace("$name", sender.getName()).replace("$ignore", target));
            return;
        }
        for (int i = 0; i < this.chaneles; ++i) {
            if (chanel != i && chanel != -1) continue;
            Main.storage.set(this.getPlayerDeafString(sender.getName(), target, i), (Object)true);
            Main.storage.set(this.getPlayerDeafString(sender.getName(), target, i) + "-reason", (Object)reason);
        }
        String chanelName = chanel >= 0 && chanel < this.chaneles ? ChanelRegister.getByIndex(chanel).getName() : "a";
        sender.sendMessage(this.message2.replace("$name", sender.getName()).replace("$channel", chanelName).replace("$reason", reason).replace("$ignore", target));
    }

    private void help(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.addAll(ValueStorage.ignoreHelp);
        for (String string : msg) {
            sender.sendMessage(ChanelRegister.colorUTF8(string, 3));
        }
    }

    @Override
    public void ignore(String[] args, CommandSender sender) {
        boolean hasHelp = Main.getPermissionsHandler().hasPermission(sender, "mcnw.ignore.help");
        boolean hasSee = Main.getPermissionsHandler().hasPermission(sender, "mcnw.ignore.see");
        boolean hasAll = Main.getPermissionsHandler().hasPermission(sender, "mcnw.ignore.all");
        boolean hasSeeSelf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.ignore.see.self") || hasSee;
        boolean hasIgnore = Main.getPermissionsHandler().hasPermission(sender, "mcnw.ignore.ignore");
        boolean hasUnIgnore = Main.getPermissionsHandler().hasPermission(sender, "mcnw.ignore.unignore");
        if (args.length == 0) {
            if (!hasHelp) {
                sender.sendMessage(this.canTHelp);
                return;
            }
            this.help(sender);
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("see")) {
                if (!hasSeeSelf) {
                    sender.sendMessage(this.canTSeeSelf);
                    return;
                }
                this.seeSelf(sender);
            } else if (args[0].equalsIgnoreCase("all")) {
                if (!hasAll) {
                    sender.sendMessage(this.canTSeeAll);
                    return;
                }
                this.seeAll(sender);
            } else {
                if (!hasSee) {
                    sender.sendMessage(this.canTSeeTarget);
                    return;
                }
                String target = args[0];
                sender.sendMessage(ChatColor.GRAY + "$" + target + " :");
                this.seeTarget(sender, target);
            }
        } else if (args.length > 1) {
            String reason;
            int chanel = ChanelRegister.getIndexBySignOrByInnerName(sender, args[1]);
            if (args.length > 2 && args[2].equals("unignore")) {
                if (!hasUnIgnore) {
                    sender.sendMessage(this.canTUnIgnoreTarget);
                    return;
                }
                String target = args[0];
                this.caseUnIgnore(sender, target, chanel);
                return;
            }
            String string = reason = args.length >= 3 ? StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length) : this.noReason;
            if (!hasIgnore) {
                sender.sendMessage(this.canTIgnore);
                return;
            }
            String target = args[0];
            this.caseIgnore(sender, target, chanel, reason);
            return;
        }
    }

    @Override
    public void seeTarget(CommandSender sender, String target) {
        ConfigurationSection cs = Main.storage.getConfigurationSection(target + ".ignore");
        if (cs == null) {
            return;
        }
        Bukkit.getConsoleSender().sendMessage(target);
        Set list = cs.getKeys(false);
        for (String ignoreName : list) {
            Bukkit.getConsoleSender().sendMessage(ignoreName);
            for (int i = 0; i < this.chaneles; ++i) {
                String reason = Main.storage.getString(this.getPlayerDeafString(target, ignoreName, i) + "-reason", "");
                if (!this.hasIgnore(target, ignoreName, i)) continue;
                sender.sendMessage(this.message.replace("$name", target).replace("$ignore", ignoreName).replace("$channel", ChanelRegister.getByIndex(i).getName()).replace("$reason", reason));
            }
        }
    }

    @Override
    public void seeSelf(CommandSender self) {
        this.seeTarget(self, self.getName());
    }

    @Override
    public void seeAll(CommandSender sender) {
        Configuration cs = Main.storage.getRoot();
        sender.sendMessage(ChatColor.GRAY + "$===============all================");
        if (cs == null) {
            return;
        }
        Set list = cs.getKeys(false);
        for (String name : list) {
            this.seeTarget(sender, name);
        }
    }

    @Override
    public void caseUnIgnore(CommandSender sender, String target, int chanel) {
        for (int i = 0; i < this.chaneles; ++i) {
            if (chanel != i && chanel != -1) continue;
            Main.storage.set(this.getPlayerDeafString(sender.getName(), target, i), (Object)false);
            Main.storage.set(this.getPlayerDeafString(sender.getName(), target, i) + "-reason", (Object)"");
        }
        String chanelName = chanel >= 0 && chanel < this.chaneles ? ChanelRegister.getByIndex(chanel).getName() : "a";
        sender.sendMessage(this.unIgnore.replace("$name", sender.getName()).replace("$channel", chanelName).replace("$ignore", target));
    }

    @Override
    public boolean hasntIgnorable(String target) {
        return Main.getPermissionsHandler().hasPermission(target, "mcnw.ignore.non");
    }
}

