/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.io.File;
import java.util.logging.Logger;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.economy.Economy;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import net.sacredlabyrinth.phaed.simpleclans.managers.ClanManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.ChatListener;
import ru.dark32.chat.Deaf;
import ru.dark32.chat.IDeaf;
import ru.dark32.chat.IIgnore;
import ru.dark32.chat.IMute;
import ru.dark32.chat.Ignore;
import ru.dark32.chat.JoinListener;
import ru.dark32.chat.Mute;
import ru.dark32.chat.QuitListener;
import ru.dark32.chat.RPChatCommandExecutor;
import ru.dark32.chat.TabListener;
import ru.dark32.chat.Util;
import ru.dark32.chat.ValueStorage;
import ru.dark32.perm.PermissionsHandler;

public class Main
extends JavaPlugin {
    public static final Logger LOG = Logger.getLogger("Minecraft");
    public PluginManager pluginManager;
    public static boolean economyHook;
    private static IMute muteStorage;
    private static IDeaf deafStorage;
    private static IIgnore ignorStorage;
    public static final String VERSION = "RPchat v 2.2.1h (545f67a079)";
    public static final String VERSION_NAME = "Green as the pink rhino";
    public static FileConfiguration config;
    public static File storageFile;
    public static YamlConfiguration storage;
    public static File chatConfigFile;
    public static YamlConfiguration chatConfig;
    public static File localeConfigFile;
    public static YamlConfiguration localeConfig;
    private static PermissionsHandler permissionsHandler;
    public static final boolean DEBUG_MODE = false;
    public static final String BASE_PERM = "mcnw";
    public static boolean SCenable;
    public static Economy economy;

    public void onEnable() {
        this.pluginManager = Bukkit.getPluginManager();
        config = this.getConfig();
        storageFile = new File(this.getDataFolder(), "storage.yml");
        storage = storageFile.exists() ? YamlConfiguration.loadConfiguration((File)storageFile) : new YamlConfiguration();
        String chat = config.getString("chat", "chat");
        chatConfigFile = new File(this.getDataFolder(), chat + ".yml");
        if (chatConfigFile.exists()) {
            chatConfig = YamlConfiguration.loadConfiguration((File)chatConfigFile);
        } else {
            this.getLogger().warning("[RPChat] " + chat + ".yml not found");
        }
        String locale = config.getString("locale", "locale");
        localeConfigFile = new File(this.getDataFolder(), locale + ".yml");
        if (localeConfigFile.exists()) {
            localeConfig = YamlConfiguration.loadConfiguration((File)localeConfigFile);
        } else {
            this.getLogger().warning("[RPChat] " + locale + ".yml not found");
        }
        if (this.hookSimpleClans()) {
            Bukkit.getConsoleSender().sendMessage("[RPChat] Simple clans was hooked");
            SCenable = true;
        }
        if (this.setupEconomy()) {
            Bukkit.getConsoleSender().sendMessage("[RPChat] Vault Economy was hooked");
            economyHook = true;
        }
        Util.init(this);
        ValueStorage.init();
        ChanelRegister.init();
        permissionsHandler = new PermissionsHandler((Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TabListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuitListener(), (Plugin)this);
        muteStorage = new Mute();
        deafStorage = new Deaf();
        ignorStorage = new Ignore();
        RPChatCommandExecutor executer = new RPChatCommandExecutor();
        this.getCommand("rpchat").setExecutor((CommandExecutor)executer);
        this.getCommand("mute").setExecutor((CommandExecutor)executer);
        this.getCommand("unmute").setExecutor((CommandExecutor)executer);
        this.getCommand("deaf").setExecutor((CommandExecutor)executer);
        this.getCommand("undeaf").setExecutor((CommandExecutor)executer);
        this.getCommand("sw").setExecutor((CommandExecutor)executer);
        this.getCommand("ignore").setExecutor((CommandExecutor)executer);
        this.getCommand("unignore").setExecutor((CommandExecutor)executer);
        this.getCommand("chatinfo").setExecutor((CommandExecutor)executer);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
    }

    public void onDisable() {
        muteStorage.save();
    }

    public static IMute getBanStorage() {
        return muteStorage;
    }

    public static IDeaf getDeafStorage() {
        return deafStorage;
    }

    public static IIgnore getIgnoreStorage() {
        return ignorStorage;
    }

    private boolean hookSimpleClans() {
        try {
            for (Plugin plugin : this.getServer().getPluginManager().getPlugins()) {
                if (!(plugin instanceof SimpleClans)) continue;
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return false;
    }

    public static ClanManager getClanManager() {
        return SimpleClans.getInstance().getClanManager();
    }

    public static PermissionsHandler getPermissionsHandler() {
        return permissionsHandler;
    }

    private boolean setupEconomy() {
        try {
            for (Plugin plugin : this.getServer().getPluginManager().getPlugins()) {
                if (!(plugin instanceof Vault)) continue;
                RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
                if (economyProvider != null) {
                    economy = (Economy)economyProvider.getProvider();
                }
                return economy != null;
            }
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return false;
    }

    static {
        SCenable = false;
        economy = null;
    }
}

