/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.IMute;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.ValueStorage;

public class Mute
implements IMute {
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final int chaneles = ChanelRegister.getChanels();
    private final String needName = this.getLoc("mute.needName");
    private final String muteMessage = this.getLoc("mute.muteMessage");
    private final String unmuteMessage = this.getLoc("mute.unmuteMessage");
    private final String canTHelp = this.getLoc("mute.canTHelp");
    private final String canTSeeSelf = this.getLoc("mute.canTSeeSelf");
    private final String canTSeeAllMute = this.getLoc("mute.canTSeeAllMute");
    private final String canTSeeTargetMute = this.getLoc("mute.canTSeeTargetMute");
    private final String signMoreOne = this.getLoc("mute.signMoreOne");
    private final String canTUnmute = this.getLoc("mute.canTUnmute");
    private final String canTMute = this.getLoc("mute.canTMute");
    private final String noReason = this.getLoc("mute.noReason");
    private final String timeNotNum = this.getLoc("mute.timeNotNum");
    private final String subCMDErr = this.getLoc("mute.subCMDErr");
    private final String dataError = this.getLoc("mute.dataError");
    private final String muteSee = this.getLoc("mute.muteSee");
    private final boolean showMuteForAll = Main.config.getBoolean("showMuteForAll", false);
    private static final int secunde = 1;
    private static final int minute = 60;
    private static final int hour = 3600;
    private static final int day = 86400;
    private static final int time_inf = 86400000;
    private static final Pattern timeParser = Pattern.compile("(\\d+?[dhms]|inf)");

    private String getLoc(String key) {
        return ChanelRegister.colorUTF8(Main.localeConfig.getString(key, key), 3);
    }

    private String getPlayerMuteString(String playerName, int chanel) {
        return playerName.toLowerCase(Locale.US) + ".mute." + ChanelRegister.getByIndex(chanel).getInnerName();
    }

    @Override
    public boolean isMuted(String playerName, int chanel) {
        if (this.getTimeMute(playerName, chanel) > 0L) {
            return true;
        }
        this.unmute(playerName, chanel);
        return false;
    }

    @Override
    public void caseMute(CommandSender sender, String name, int chanel, int time, String reason) {
        String _chanelName;
        if ("empty".equals(name)) {
            sender.sendMessage(this.needName);
            return;
        }
        for (int i = 0; i < this.chaneles; ++i) {
            if (chanel != i && chanel != -1) continue;
            Calendar cal = Calendar.getInstance();
            cal.add(13, time);
            Main.storage.set(this.getPlayerMuteString(name, i), (Object)this.SDF.format(cal.getTime()));
            Main.storage.set(this.getPlayerMuteString(name, i) + "-reason", (Object)reason);
        }
        String string = _chanelName = chanel >= 0 && chanel < this.chaneles ? ChanelRegister.getByIndex(chanel).getName() : "a";
        if (time > 5) {
            String msg = this.muteSee;
            if (msg.contains("$name")) {
                msg = msg.replace("$name", name);
            }
            if (msg.contains("$channel")) {
                msg = msg.replace("$channel", chanel == -1 ? "all" : ChanelRegister.getByIndex(chanel).getName());
            }
            if (msg.contains("$reason")) {
                msg = msg.replace("$reason", reason);
            }
            msg = Mute.unParseTime(msg, time);
            msg = Util.suffixLatter(msg);
            if (this.showMuteForAll) {
                Bukkit.getServer().broadcastMessage(msg);
            } else {
                sender.sendMessage(msg);
            }
        } else {
            sender.sendMessage(this.unmuteMessage.replace("$name", name).replace("$channel", _chanelName));
        }
        this.save();
    }

    @Override
    public void mute(String[] args, CommandSender sender) {
        boolean hasHelp = Main.getPermissionsHandler().hasPermission(sender, "mcnw.mute.help");
        boolean hasSee = Main.getPermissionsHandler().hasPermission(sender, "mcnw.mute.see");
        boolean hasAll = Main.getPermissionsHandler().hasPermission(sender, "mcnw.mute.all");
        boolean hasSeeSelf = Main.getPermissionsHandler().hasPermission(sender, "mcnw.mute.see.self") || hasSee;
        boolean hasMute = Main.getPermissionsHandler().hasPermission(sender, "mcnw.mute.mute");
        boolean hasUnMute = Main.getPermissionsHandler().hasPermission(sender, "mcnw.mute.unmute");
        if (args.length == 0) {
            if (!hasHelp) {
                sender.sendMessage(this.canTHelp);
                return;
            }
            this.muteHelp(sender);
        } else if (args.length == 1) {
            String par = args[0];
            if ("see".equals(par)) {
                if (!hasSeeSelf) {
                    sender.sendMessage(this.canTSeeSelf);
                    return;
                }
                this.seeSelf(sender);
            } else if ("all".equals(par)) {
                if (!hasAll) {
                    sender.sendMessage(this.canTSeeAllMute);
                    return;
                }
                this.seeAll(sender);
            } else {
                if (!hasSee) {
                    sender.sendMessage(this.canTSeeTargetMute);
                    return;
                }
                sender.sendMessage(ChatColor.GRAY + "$" + par + " :");
                this.seeTarget(sender, par);
            }
        } else if (args.length == 2) {
            String nick = args[0];
            if (args[1].equals("see")) {
                if (nick.equals(sender.getName())) {
                    if (!hasSeeSelf) {
                        sender.sendMessage(this.canTSeeSelf);
                        return;
                    }
                    this.seeSelf(sender);
                } else {
                    if (!hasSee) {
                        sender.sendMessage(this.canTSeeTargetMute);
                        return;
                    }
                    this.seeTarget(sender, nick);
                }
            } else {
                sender.sendMessage(this.subCMDErr);
            }
        } else if (args.length >= 3) {
            if (!hasMute) {
                sender.sendMessage(this.canTMute);
                return;
            }
            int chanel = ChanelRegister.getIndexBySignOrByInnerName(sender, args[1]);
            int time = 0;
            time = Mute.timeParse(args[2]);
            if (time == 0) {
                sender.sendMessage(this.timeNotNum + args[2]);
            }
            if (time < 5 && !hasUnMute) {
                sender.sendMessage(this.canTUnmute);
                return;
            }
            String reason = args.length >= 3 ? StringUtils.join((Object[])args, (String)" ", (int)3, (int)args.length) : this.noReason;
            String nick = args[0];
            this.caseMute(sender, nick, chanel, time, reason);
        }
    }

    @Override
    public void save() {
        Configuration cs = Main.storage.getRoot();
        if (cs != null) {
            Set list = cs.getKeys(false);
            for (String name : list) {
                for (int i = 0; i < this.chaneles; ++i) {
                    this.isMuted(name, i);
                }
            }
        }
        try {
            Main.storage.save(Main.storageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unmute(String playerName, int chanel) {
        for (int i = 0; i < this.chaneles; ++i) {
            if (chanel != i && chanel != -1) continue;
            Main.storage.set(this.getPlayerMuteString(playerName, i), null);
            Main.storage.set(this.getPlayerMuteString(playerName, i) + "-reason", null);
        }
    }

    @Override
    public long getTimeMute(String playerName, int chanel) {
        String dateStr = Main.storage.getString(this.getPlayerMuteString(playerName, chanel));
        if (dateStr != null) {
            try {
                Date date = this.SDF.parse(dateStr);
                return (date.getTime() - System.currentTimeMillis()) / 1000L;
            }
            catch (ParseException e) {
                Bukkit.getConsoleSender().sendMessage(this.getPlayerMuteString(playerName, chanel));
                Bukkit.getConsoleSender().sendMessage(this.dataError + dateStr);
            }
        }
        return -1L;
    }

    private void muteHelp(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.addAll(ValueStorage.muteHelp);
        for (String s : msg) {
            sender.sendMessage(ChanelRegister.colorUTF8(s, 3));
        }
    }

    @Override
    public void seeAll(CommandSender sender) {
        Configuration cs = Main.storage.getRoot();
        sender.sendMessage(ChatColor.GRAY + "$===============all================");
        if (cs == null) {
            return;
        }
        Set list = cs.getKeys(false);
        for (String name : list) {
            this.seeTarget(sender, name);
        }
    }

    @Override
    public void seeSelf(CommandSender sender) {
        this.seeTarget(sender, sender.getName());
    }

    @Override
    public void seeTarget(CommandSender sender, String name) {
        for (int i = 0; i < this.chaneles; ++i) {
            long time = this.getTimeMute(name, i);
            String reason = Main.storage.getString(this.getPlayerMuteString(name, i) + "-reason");
            if (time <= -1L) continue;
            String msg = this.muteSee;
            if (msg.contains("$name")) {
                msg = msg.replace("$name", name);
            }
            if (msg.contains("$channel")) {
                msg = msg.replace("$channel", ChanelRegister.getByIndex(i).getName());
            }
            if (msg.contains("$reason")) {
                msg = msg.replace("$reason", reason);
            }
            msg = Mute.unParseTime(msg, time);
            msg = Util.suffixLatter(msg);
            sender.sendMessage(msg);
        }
    }

    public static int timeParse(String string) {
        int time = 0;
        Matcher matches = timeParser.matcher(string);
        while (matches.find()) {
            String rawTime = matches.group(0).toLowerCase(Locale.US);
            if (!rawTime.equalsIgnoreCase("inf")) {
                char timeMultiple = rawTime.charAt(rawTime.length() - 1);
                String _time = rawTime.substring(0, rawTime.length() - 1);
                int tmp_time = _time.length() > 5 ? 99999 : Integer.parseInt(_time);
                switch (timeMultiple) {
                    case 's': {
                        tmp_time *= 1;
                        break;
                    }
                    case 'm': {
                        tmp_time *= 60;
                        break;
                    }
                    case 'h': {
                        tmp_time *= 3600;
                        break;
                    }
                    case 'd': {
                        tmp_time *= 86400;
                        break;
                    }
                    default: {
                        tmp_time = 0;
                        System.err.println("[rpChat2][ERROR] undef time sign " + timeMultiple);
                    }
                }
                time += tmp_time;
                continue;
            }
            time = 86400000;
        }
        return time;
    }

    public static String unParseTime(String msg, long time) {
        if (msg.contains("$time")) {
            msg = msg.replace("$time", String.valueOf(time));
        }
        if (msg.contains("$data.day")) {
            long _day = time / 86400L;
            msg = msg.replace("$data.day", Long.toString(_day));
        }
        if (msg.contains("$data.hour")) {
            long _hour = time % 86400L / 3600L;
            msg = msg.replace("$data.hour", Long.toString(_hour));
        }
        if (msg.contains("$data.minute")) {
            long _minute = time % 3600L / 60L;
            msg = msg.replace("$data.minute", Long.toString(_minute));
        }
        if (msg.contains("$data.second")) {
            long _second = time % 60L / 1L;
            msg = msg.replace("$data.second", Long.toString(_second));
        }
        return msg;
    }
}

