/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.ValueStorage;
import ru.dark32.chat.ichanels.IChanel;

public class RPChatCommandExecutor
implements CommandExecutor {
    private String chanelswitch = ChanelRegister.colorUTF8(Main.localeConfig.getString("help.changechanel", "help.changechanel"), 3);
    private String chanenotfound = ChanelRegister.colorUTF8(Main.localeConfig.getString("help.chanenotfound", "help.chanenotfound"), 3);
    private String chanesignmore1 = ChanelRegister.colorUTF8(Main.localeConfig.getString("help.chanesignmore1", "help.chanesignmore1"), 3);

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("rpchat")) {
            if (args.length == 0 || args.length > 1) {
                RPChatCommandExecutor.getBase(sender);
                return true;
            }
            if (args[0].equalsIgnoreCase("help")) {
                this.getHelp(sender);
            }
            if (args[0].equalsIgnoreCase("channel")) {
                this.getChannel(sender);
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("mute")) {
            Main.getBanStorage().mute(args, sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("unmute")) {
            String[] _args = new String[]{args.length > 0 ? args[0] : "empty", args.length > 1 ? args[1] : "a", "1s"};
            Main.getBanStorage().mute(_args, sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("deaf")) {
            Main.getDeafStorage().deaf(args, sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("undeaf")) {
            if (args.length != 2) {
                return false;
            }
            String[] _args = new String[]{args[0], args[1], "undeaf"};
            Main.getDeafStorage().deaf(_args, sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("sw")) {
            if (args.length == 1) {
                int chanel = ChanelRegister.getIndexBySignOrByInnerName(sender, args[0]);
                if (chanel != -1 && Util.setChatMode(sender.getName(), chanel)) {
                    sender.sendMessage(this.chanelswitch.replace("$1", ChanelRegister.getByIndex(chanel).getName()));
                } else {
                    sender.sendMessage(this.chanenotfound);
                }
            } else {
                this.getChannel(sender);
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("ignore")) {
            Main.getIgnoreStorage().ignore(args, sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("unignore")) {
            if (args.length != 2) {
                return false;
            }
            String[] _args = new String[]{args[0], args[1], "unignore"};
            Main.getIgnoreStorage().ignore(_args, sender);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("chatinfo")) {
            if (args.length != 1 || Main.getPermissionsHandler().hasPermission(sender, "mcnwchatinfo")) {
                return false;
            }
            this.chatInfo(sender, args[0]);
            return true;
        }
        return false;
    }

    private void getChannel(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("&b=============================================");
        msg.addAll(ValueStorage.helpChannel);
        msg.add("&b=============================================");
        for (String s : msg) {
            sender.sendMessage(ChanelRegister.colorUTF8(s, 3));
        }
    }

    private void getHelp(CommandSender sender) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("&b=============================================");
        msg.addAll(ValueStorage.helpHelp);
        msg.add("&b=============================================");
        for (String s : msg) {
            sender.sendMessage(ChanelRegister.colorUTF8(s, 3));
        }
    }

    public static void getBase(CommandSender player) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("&b=============================================");
        msg.add("&6RPchat v 2.2.1h (545f67a079)");
        msg.add("&6Green as the pink rhino");
        msg.add("&6Autors: ufatos, dark32");
        msg.add("&6License: CC-BY-NC-ND");
        msg.addAll(ValueStorage.helpBase);
        msg.add("&b=============================================");
        for (String s : msg) {
            player.sendMessage(ChanelRegister.colorUTF8(s, 3));
        }
    }

    public void chatInfo(CommandSender sender, String name) {
        IChanel chanel = ChanelRegister.getByIndex(Util.getModeIndex(name));
        Player player = Bukkit.getPlayer((String)name);
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("&b=============================================");
        msg.add("&bINFO: " + name);
        msg.add("Channel: " + chanel.getName() + " origin: " + chanel.getInnerName() + " prefix: " + chanel.getPrefix());
        if (player != null) {
            msg.add("Name " + player.getName());
            msg.add("Display Name " + player.getDisplayName());
            msg.add("Entity Id " + player.getEntityId());
            msg.add("Ticks Lived " + player.getTicksLived());
            msg.add("Anonym ID " + Integer.toHexString(player.getTicksLived() + player.getEntityId()));
        }
        msg.add("&b=============================================");
        for (String s : msg) {
            sender.sendMessage(ChanelRegister.colorUTF8(s, 3));
        }
    }
}

