/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.Main;
import ru.dark32.chat.ichanels.IChanel;

public class Util {
    public static Map<String, Integer> modes;
    private static String luck;
    private static String unluck;
    private static int chance;
    private static final String suffixParsePatern = "\\$\\((.+?)\\|(.+?)\\|(.+?)\\|(\\d+?)\\)";
    private static final Pattern suffixParser;

    public static int getModeIndex(String name) {
        if (!modes.containsKey(name)) {
            return ChanelRegister.getDefaultChanel(Bukkit.getPlayer((String)name));
        }
        return modes.get(name);
    }

    public static Player getPlayerSoft(String name) {
        if (name.isEmpty()) {
            return null;
        }
        Player[] players = Bukkit.getServer().getOnlinePlayers();
        Player found = null;
        String lowerName = name.toLowerCase(Locale.US);
        int delta = Integer.MAX_VALUE;
        for (Player player : players) {
            if (player.getName().toLowerCase().indexOf(lowerName) == -1) continue;
            int curDelta = player.getName().length() - lowerName.length();
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta == 0) break;
        }
        return found;
    }

    public static void init(Main main) {
        modes = new HashMap<String, Integer>();
        luck = ChanelRegister.colorUTF8(Main.localeConfig.getString("String.chance.luck", "(luck)"), 3);
        unluck = ChanelRegister.colorUTF8(Main.localeConfig.getString("String.chance.unluck", "(unluck)"), 3);
        chance = Main.config.getInt("chance", 50);
    }

    public static boolean isInteger(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        int i = 0;
        int len = string.length();
        if (string.charAt(0) == '-') {
            if (len == 1) {
                return false;
            }
            i = 1;
        }
        while (i < len) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean setChatMode(String player, int cm) {
        boolean hasPermission;
        IChanel chanel = ChanelRegister.getByIndex(cm);
        boolean bl = hasPermission = Main.getPermissionsHandler().hasPermission(player, "mcnw.spy") || Main.getPermissionsHandler().hasPermission(player, "mcnw." + chanel.getInnerName() + ".say");
        if (!chanel.isNeedPerm() || hasPermission) {
            if (modes.containsKey(player)) {
                modes.remove(player);
            }
            modes.put(player, cm);
            return true;
        }
        return false;
    }

    public static String parseUTF8(String instr) {
        char[] convtBuf;
        char[] in = instr.toCharArray();
        int len = in.length;
        int off = 0;
        char[] out = convtBuf = new char[len];
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                Bukkit.getConsoleSender().sendMessage("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String suffixLatter(String message) {
        Matcher matches = suffixParser.matcher(message);
        while (matches.find()) {
            int num = Integer.valueOf(matches.group(4));
            String suf = "";
            int val = num % 100;
            suf = val > 10 && val < 20 ? matches.group(3) : ((val = num % 10) == 1 ? matches.group(1) : (val > 1 && val < 5 ? matches.group(2) : matches.group(3)));
            message = message.replaceFirst(suffixParsePatern, suf);
        }
        return message;
    }

    public static final void DEBUG(Object message, CommandSender sender) {
    }

    public static final void DEBUG(Object message) {
        Util.DEBUG(message, (CommandSender)Bukkit.getConsoleSender());
    }

    static {
        suffixParser = Pattern.compile(suffixParsePatern);
    }
}

