/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat.chanels;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.Main;
import ru.dark32.chat.SimpleClanHook;
import ru.dark32.chat.Util;
import ru.dark32.chat.VaultEconomyHook;
import ru.dark32.chat.ichanels.ETypeChanel;
import ru.dark32.chat.ichanels.IChanel;

public class BaseChanel
implements IChanel {
    private final boolean allyOnly;
    private final double baseCost;
    private final boolean clanOnly;
    private final String cmdSend;
    private final String cmdSwitch;
    private final String colorize;
    private final HashMap<String, Long> cooldown = new HashMap();
    private final String cooldownText;
    private final double costPerSymbol;
    protected final int COUNT_EXCLUDE = 1;
    protected final int COUNT_INCLUDE = -1;
    protected final int COUNT_OFF = 0;
    private final int defaultCoolDown;
    private final boolean enable;
    private final String formatString;
    private final int index;
    private final String innerName;
    private final boolean isWorld;
    private final String listenerMessage;
    private final int listenerMessageEnable;
    private final String name;
    private final String needmoremoney;
    private final boolean needPerm;
    private final String noListenerMessage;
    private final boolean overAll;
    private final boolean pimkEnable;
    private final Instrument pimkInstrument;
    private final Note pimkNote;
    private final char prefix;
    private final char sign;
    private final boolean tabes;
    private ETypeChanel type;

    public BaseChanel(String par_name) {
        String path_enable = "Chat." + par_name + ".enable";
        String path_name = "Chat." + par_name + ".name";
        String path_world = "Chat." + par_name + ".world";
        String path_prefix = "Chat." + par_name + ".prefix";
        String path_sign = "Chat." + par_name + ".sign";
        String path_format = "Chat." + par_name + ".format";
        String path_tab = "Chat." + par_name + ".tab";
        String path_listenerMessage = "Chat." + par_name + ".listenerMessage";
        String path_noListenerMessage = "Chat." + par_name + ".noListenerMessage";
        String path_isListenerMessage = "Chat." + par_name + ".isListenerMessage";
        String path_needPerm = "Chat." + par_name + ".needPerm";
        String path_pimk_note = "Chat." + par_name + ".pimk.note";
        String path_pimk_enable = "Chat." + par_name + ".pimk.enable";
        String path_pimk_instrument = "Chat." + par_name + ".pimk.instrument";
        String path_pimk_colorize = "Chat." + par_name + ".pimk.colorize";
        String path_overAll = "Chat." + par_name + ".overAll";
        String path_clan = "Chat." + par_name + ".clan";
        String path_cooldown = "Chat." + par_name + ".cooldown";
        String path_cooldown_text = "cooldown.text";
        String path_base_cost = "Chat." + par_name + ".cost.base";
        String path_cost_per_symbol = "Chat." + par_name + ".cost.per";
        String path_needmoremoney = "Chat." + par_name + ".cost.needmoremoney";
        String path_switch_cmd = "Chat." + par_name + ".switchcmd";
        String path_send_cmd = "Chat." + par_name + ".sendcmd";
        this.index = ChanelRegister.getNextIndex();
        this.innerName = par_name;
        this.enable = Main.chatConfig.getBoolean(path_enable, false);
        this.name = Main.chatConfig.getString(path_name, path_name);
        this.isWorld = Main.chatConfig.getBoolean(path_world, false);
        this.prefix = Main.chatConfig.getString(path_prefix, "\u0000").charAt(0);
        this.sign = Main.chatConfig.getString(path_sign, path_sign).charAt(0);
        this.formatString = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_format, path_format), 3);
        this.tabes = Main.chatConfig.getBoolean(path_tab, true);
        this.listenerMessage = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_listenerMessage, ""), 3);
        this.noListenerMessage = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_noListenerMessage, ""), 3);
        this.listenerMessageEnable = Main.chatConfig.getInt(path_isListenerMessage, 0);
        this.needPerm = Main.chatConfig.getBoolean(path_needPerm, false);
        this.defaultCoolDown = Main.chatConfig.getInt(path_cooldown, 0);
        this.cooldownText = ChanelRegister.colorUTF8(Main.localeConfig.getString("cooldown.text", "cooldown.text"), 3);
        String note = Main.chatConfig.getString(path_pimk_note, "1F#");
        int octava = note.length() > 0 ? note.charAt(0) : 1;
        Note.Tone tone = Note.Tone.F;
        boolean sharped = false;
        if (note.length() >= 2 && note.length() <= 3) {
            char char0 = note.charAt(0);
            char char1 = note.charAt(1);
            octava = char0 == '2' ? 2 : (char0 == '0' ? 0 : (char0 == '1' ? 1 : 1));
            tone = 'A' <= char1 && 'F' >= char1 ? Note.Tone.valueOf((String)String.valueOf(char1)) : Note.Tone.F;
            sharped = note.length() == 3 && note.charAt(1) == '#';
        }
        this.pimkEnable = Main.chatConfig.getBoolean(path_pimk_enable, false);
        this.pimkInstrument = Instrument.valueOf((String)Main.chatConfig.getString(path_pimk_instrument, "PIANO"));
        this.pimkNote = new Note(octava, tone, sharped);
        this.colorize = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_pimk_colorize, "@"), 3);
        this.overAll = Main.chatConfig.getBoolean(path_overAll, true);
        String clanly = Main.chatConfig.getString(path_clan, "none");
        this.clanOnly = clanly.equalsIgnoreCase("clan");
        this.allyOnly = clanly.equalsIgnoreCase("ally");
        this.baseCost = Main.chatConfig.getDouble(path_base_cost, 0.0);
        this.costPerSymbol = Main.chatConfig.getDouble(path_cost_per_symbol, 0.0);
        this.needmoremoney = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_needmoremoney, path_needmoremoney), 3);
        this.cmdSwitch = Main.chatConfig.getString(path_switch_cmd, "");
        this.cmdSend = Main.chatConfig.getString(path_send_cmd, "");
    }

    @Override
    public boolean canSend(Player sender, String message) {
        return this.testCoolDown(sender, message) && this.testCost(sender, message);
    }

    private final String colorChatMessage(Player sender, String message) {
        if (message.contains("&")) {
            for (ChatColor value : ChatColor.values()) {
                char color = value.getChar();
                if (!Main.getPermissionsHandler().hasPermission((CommandSender)sender, "mcnw.color." + color) && !Main.getPermissionsHandler().hasPermission((CommandSender)sender, "mcnw." + this.getInnerName() + ".color." + color)) continue;
                message = message.replaceAll("&" + value.getChar(), "\u00a7" + value.getChar());
                break;
            }
        }
        return message;
    }

    private String findMatch(String name, String[] message) {
        for (String s : message) {
            if (!name.startsWith(s)) continue;
            return s;
        }
        return null;
    }

    @Override
    public String format(Player player, String msg) {
        if (Main.SCenable) {
            msg = SimpleClanHook.formatComplete(msg, player);
        }
        if (msg.contains("$suffix")) {
            msg = msg.replace("$suffix", Main.getPermissionsHandler().getSuffix(player));
        }
        if (msg.contains("$prefix")) {
            msg = msg.replace("$prefix", Main.getPermissionsHandler().getPrefix(player));
        }
        if (msg.contains("$p")) {
            msg = msg.replace("$p", "%1$s");
        }
        if (msg.contains("$msg")) {
            msg = msg.replace("$msg", "%2$s");
        }
        if (msg.contains("$id")) {
            String iden = Integer.toHexString(player.getTicksLived() + player.getEntityId());
            msg = msg.replace("$id", iden);
        }
        return msg;
    }

    @Override
    public String getCmdSend() {
        return this.cmdSend;
    }

    @Override
    public String getCmdSwitch() {
        return this.cmdSwitch;
    }

    @Override
    public final String getColorize() {
        return this.colorize;
    }

    @Override
    public int getCoolDown(Player player) {
        String group = Main.getPermissionsHandler().getGroup(player);
        System.out.println("Chat." + this.innerName + ".groups." + group + ".cooldown");
        int time = Main.chatConfig.getInt("Chat." + this.innerName + ".groups." + group + ".cooldown", this.defaultCoolDown);
        System.out.println(time);
        return time;
    }

    private long getCoolDownForPlayer(Player player) {
        if (this.cooldown.containsKey(player.getName())) {
            return this.cooldown.get(player.getName()) - System.currentTimeMillis() / 1000L;
        }
        return -1L;
    }

    @Override
    public double getCostMessage(Player player, String msg) {
        int l = msg.length();
        boolean free = Main.getPermissionsHandler().hasPermission((CommandSender)player, "mcnw.economy.bypass") || Main.getPermissionsHandler().hasPermission((CommandSender)player, "mcnw." + this.getInnerName() + ".economy.bypass");
        return free ? 0.0 : this.baseCost + this.costPerSymbol * (double)l;
    }

    @Override
    public final String getFormat() {
        return this.formatString;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getInnerName() {
        return this.innerName.toLowerCase(Locale.US);
    }

    @Override
    public String getListenerMessage(int count) {
        if (count > 0) {
            if (this.listenerMessage.length() > 0 && this.listenerMessage.contains("$n")) {
                return Util.suffixLatter(this.listenerMessage.replace("$n", String.valueOf(count)));
            }
        } else if (this.noListenerMessage.length() > 0) {
            return this.noListenerMessage;
        }
        return "";
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Instrument getPimkInstrument() {
        return this.pimkInstrument;
    }

    @Override
    public final Note getPimkNote() {
        return this.pimkNote;
    }

    @Override
    public final char getPrefix() {
        return this.prefix;
    }

    @Override
    public Set<Player> getRecipients(Player sender) {
        HashSet<Player> recipients = new HashSet<Player>();
        for (Player recipient : Bukkit.getServer().getOnlinePlayers()) {
            if (this.isRecipient(sender, recipient)) {
                Util.DEBUG("debug: isn't Recipient - " + recipient.getName(), (CommandSender)sender);
                continue;
            }
            recipients.add(recipient);
        }
        return recipients;
    }

    @Override
    public final char getSign() {
        return this.sign;
    }

    @Override
    public Set<Player> getSpyRecipients(Player sender) {
        HashSet<Player> recipients = new HashSet<Player>();
        for (Player recipient : Bukkit.getServer().getOnlinePlayers()) {
            if (!Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw.spy") || sender == recipient) continue;
            Util.DEBUG("debug: spy - " + recipient.getName(), (CommandSender)sender);
            recipients.add(recipient);
        }
        return recipients;
    }

    @Override
    public final ETypeChanel getType() {
        return this.type;
    }

    @Override
    public final boolean isAlly() {
        return this.allyOnly && Main.SCenable;
    }

    @Override
    public final boolean isClan() {
        return this.clanOnly && Main.SCenable;
    }

    @Override
    public boolean isDefaultForGrop(String group) {
        return Main.chatConfig.getBoolean("Chat." + this.innerName + ".groups." + group + ".default", false);
    }

    @Override
    public final boolean isEnable() {
        return this.enable;
    }

    @Override
    public final int isListenerMessage() {
        return this.listenerMessageEnable;
    }

    @Override
    public final boolean isNeedPerm() {
        return this.needPerm;
    }

    @Override
    public final boolean isOverAll() {
        return this.overAll;
    }

    @Override
    public final boolean isPimk() {
        return this.pimkEnable;
    }

    protected final boolean isRecipient(Player sender, Player recipient) {
        boolean isDeaf = !Main.getDeafStorage().isDeaf(recipient.getName(), this.getIndex());
        boolean isHear = !this.isNeedPerm() || Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw." + this.getInnerName() + ".say") || Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw." + this.getInnerName() + ".hear");
        boolean isSelf = sender == recipient && this.isListenerMessage() == -1;
        boolean isInChanel = this.isOverAll() || Util.getModeIndex(recipient.getName()) == this.getIndex();
        boolean hasIgnore = Main.getIgnoreStorage().hasIgnore(recipient.getName(), sender.getName(), this.getIndex());
        boolean isClan = !this.isClan() || SimpleClanHook.equalClan(sender, recipient);
        boolean isAlly = !this.isAlly() || SimpleClanHook.equalAlly(sender, recipient);
        boolean allCond = isInChanel && !isSelf && isHear && isDeaf && !hasIgnore && isClan && isAlly;
        Util.DEBUG(recipient.getName());
        Util.DEBUG("isInChanel " + isInChanel + " isn'tSelf " + !isSelf + " isHear " + isHear);
        Util.DEBUG("hasDeaf " + isDeaf + " hasn'tIgnore " + !hasIgnore + " all " + allCond);
        Util.DEBUG("isClan" + isClan + " isAlly" + isAlly);
        return !allCond;
    }

    @Override
    public final boolean isTabes() {
        return this.tabes;
    }

    @Override
    public final boolean isWorldChat() {
        return this.isWorld;
    }

    @Override
    public String preformatMessage(Player sender, String message) {
        message = this.colorChatMessage(sender, message);
        message = Util.suffixLatter(message);
        return message;
    }

    @Override
    public void preSend(Player sender, String message, Set<Player> recipient) {
        if (this.isPimk()) {
            String[] messageArr = message.replace(",", "").replace(".", "").replace(":", "").replace(";", "").replace("?", "").replace("!", "").replace("@", "").split(" ");
            for (Player player : recipient) {
                String name = player.getName();
                String match = this.findMatch(name, messageArr);
                if (match == null) continue;
                player.playSound(player.getLocation(), Sound.valueOf((String)("NOTE_" + this.getPimkInstrument())), 3.0f, (float)this.getPimkNote().getId());
            }
        }
        if (this.isListenerMessage() == 1) {
            String str = this.getListenerMessage(recipient.size() - 1);
            if (str.length() > 0) {
                sender.sendMessage(str);
            }
        } else if (this.isListenerMessage() == -1) {
            sender.sendMessage(this.getListenerMessage(recipient.size()) + String.format(this.format(sender, this.getFormat()), sender.getName(), message));
        }
    }

    private void setCoolDownForPlayer(Player player) {
        this.cooldown.put(player.getName(), System.currentTimeMillis() / 1000L + (long)this.getCoolDown(player));
    }

    @Override
    public final void setType(ETypeChanel type) {
        this.type = type;
    }

    private final boolean testCoolDown(Player sender, String message) {
        if (this.getCoolDown(sender) > 0) {
            long timeLeft = this.getCoolDownForPlayer(sender);
            if (timeLeft > 0L) {
                sender.sendMessage(Util.suffixLatter(this.cooldownText.replace("$time", Long.toString(timeLeft))));
                return false;
            }
            this.setCoolDownForPlayer(sender);
            return true;
        }
        return true;
    }

    private final boolean testCost(Player sender, String message) {
        if (!Main.economyHook) {
            return true;
        }
        double cost = this.getCostMessage(sender, message);
        if (VaultEconomyHook.hasBalance(sender, cost)) {
            VaultEconomyHook.cost(sender, cost);
            return true;
        }
        sender.sendMessage(this.needmoremoney.replace("$total", Double.toString(cost)).replace("$base", Double.toString(this.baseCost)).replace("$per", Double.toString(this.costPerSymbol)));
        return false;
    }

    public String toString() {
        return super.toString() + ", index =>" + this.index + ", isWorld =>" + this.isWorld + ", name =>" + this.name + ", prefix =>" + this.prefix + ", sign =>" + this.sign + ", type =>" + (Object)((Object)this.type);
    }
}

