/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat.chanels;

import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.ValueStorage;
import ru.dark32.chat.chanels.BaseChanel;
import ru.dark32.chat.ichanels.IItemChanel;

public class ItemChanel
extends BaseChanel
implements IItemChanel {
    private final int itemAmount;
    private final int itemId;
    private final Material itemMaterial;
    private final int itemSubId;
    private final boolean requestPprefix;

    public ItemChanel(String name) {
        super(name);
        String path_item_id = "Chat." + name + ".item.id";
        String path_item_subId = "Chat." + name + ".item.subid";
        String path_item_amount = "Chat." + name + ".item.amount";
        String path_item_material = "Chat." + name + ".item.material";
        String path_requestPrefix = "Chat." + name + ".requestPrefix";
        this.itemId = Main.chatConfig.getInt(path_item_id, 0);
        this.itemSubId = Main.chatConfig.getInt(path_item_subId, 0);
        this.itemAmount = Main.chatConfig.getInt(path_item_amount, 1);
        Material ma = Material.getMaterial((String)Main.chatConfig.getString(path_item_material));
        this.itemMaterial = ma != null ? ma : Material.AIR;
        this.requestPprefix = Main.chatConfig.getBoolean(path_requestPrefix, true);
    }

    @Override
    public boolean canSend(Player sender, String message) {
        if (!super.canSend(sender, message)) {
            return false;
        }
        if (!Main.getPermissionsHandler().hasPermission((CommandSender)sender, "mcnw." + this.getInnerName() + ".no_item")) {
            if (this.equalItem(sender.getItemInHand())) {
                this.loseItem(sender);
            } else {
                sender.sendMessage(ValueStorage.nei);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equalItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        Util.DEBUG("debug inhand " + item.getTypeId() + ":" + item.getDurability() + " - " + item.getType());
        Util.DEBUG("debug need " + this.itemId + ":" + this.itemSubId + " - " + this.itemMaterial);
        boolean isItem = item.getDurability() == this.itemSubId && item.getAmount() >= this.itemAmount && (ValueStorage.experemental && item.getType() == this.itemMaterial || item.getTypeId() == this.itemId);
        return isItem;
    }

    @Override
    public final int getItemAmount() {
        return this.itemAmount;
    }

    @Override
    @Deprecated
    public final int getItemId() {
        return this.itemId;
    }

    @Override
    public final Material getItemMaterial() {
        return this.itemMaterial;
    }

    @Override
    public final int getItemSubId() {
        return this.itemSubId;
    }

    @Override
    public final boolean isRequestPprefix() {
        return this.requestPprefix;
    }

    @Override
    public final void loseItem(Player player) {
        ItemStack inHand = player.getItemInHand();
        if (this.itemAmount == 0) {
            return;
        }
        int amoutHand = inHand.getAmount() - this.itemAmount;
        ItemStack inHandrem = null;
        inHandrem = ValueStorage.experemental ? new ItemStack(inHand.getType(), amoutHand) : new ItemStack(inHand.getTypeId(), amoutHand);
        if (amoutHand <= 0) {
            inHandrem = null;
        }
        player.setItemInHand(inHandrem);
    }

    @Override
    public String toString() {
        return super.toString() + ", id =>" + this.itemId + ", subid=>" + this.itemSubId + ", material =>" + this.itemMaterial.name() + ", count =>" + this.getItemAmount();
    }
}

