/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat.chanels;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dark32.chat.ChanelRegister;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.chanels.BaseChanel;
import ru.dark32.chat.ichanels.IPersonalMessagesChanel;

public class PersonalMessageChanel
extends BaseChanel
implements IPersonalMessagesChanel {
    private final String formatToSting;
    private final String formatSpyString;
    private final String formatFromString;
    private final int pmSearchNickMode;

    public PersonalMessageChanel(String name) {
        super(name);
        String path_formatTo = "Chat." + name + ".formatTo";
        String path_fotmatFrom = "Chat." + name + ".formatFrom";
        String path_formatSpy = "Chat." + name + ".formatSpy";
        String path_PMSNM = "Chat." + name + ".PMSearchNickMode";
        this.formatToSting = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_formatTo, path_formatTo), 3);
        this.formatFromString = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_fotmatFrom, path_fotmatFrom), 3);
        this.formatSpyString = ChanelRegister.colorUTF8(Main.chatConfig.getString(path_formatSpy, path_formatSpy), 3);
        this.pmSearchNickMode = Main.chatConfig.getInt(path_PMSNM, 0);
    }

    @Override
    public final int getPmSearchNickMode() {
        return this.pmSearchNickMode;
    }

    @Override
    public final boolean hasNameTarget(String raw) {
        return raw.length() > 1;
    }

    @Override
    public final String getNameTarget(String raw) {
        int _ind = raw.indexOf(32);
        return raw.substring(1, _ind == -1 ? raw.length() : _ind);
    }

    @Override
    public final int hasMessage(String raw) {
        return raw.indexOf(32);
    }

    @Override
    public final String getMessage(String raw, int _ind) {
        return _ind != -1 ? raw.substring(_ind + 1, raw.length()) : "";
    }

    @Override
    public final Player getTargetByName(String name) {
        switch (this.pmSearchNickMode) {
            case -1: {
                return Bukkit.getServer().getPlayerExact(name);
            }
            case 0: {
                return Bukkit.getServer().getPlayer(name);
            }
            case 1: {
                return Util.getPlayerSoft(name);
            }
        }
        return Bukkit.getServer().getPlayer(name);
    }

    @Override
    public final boolean hasTarget(Player target) {
        return target != null;
    }

    @Override
    public void sendMessage(Player sender, String raw) {
        if (!this.hasNameTarget(raw)) {
            sender.sendMessage("\u0418\u043c\u044f \u0446\u0435\u043b\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e");
            return;
        }
        String nameTarget = this.getNameTarget(raw);
        Player target = this.getTargetByName(nameTarget);
        if (!this.hasTarget(target)) {
            sender.sendMessage("\u0426\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            return;
        }
        int _ind = this.hasMessage(raw);
        if (_ind < 0) {
            sender.sendMessage("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e");
            return;
        }
        String messge = this.getMessage(raw, _ind);
        target.sendMessage(this.formatTo(sender, target, messge));
        this.responseSendMessage(sender, this.formatFrom(sender, target, messge));
        this.sendSpyMessage(sender, target, this.formatSpy(sender, target, messge));
    }

    @Override
    public final void responseSendMessage(Player sender, String msg) {
        sender.sendMessage(msg);
    }

    @Override
    public final void sendSpyMessage(Player sender, Player target, String msg) {
        Bukkit.getConsoleSender().sendMessage(msg);
    }

    @Override
    public Set<Player> getRecipients(Player sender) {
        HashSet<Player> recipients = new HashSet<Player>();
        String noSpy = "mcnw." + this.getInnerName() + ".nospy";
        for (Player recipient : Bukkit.getServer().getOnlinePlayers()) {
            if (Main.getPermissionsHandler().hasPermission((CommandSender)recipient, noSpy) || Main.getPermissionsHandler().hasPermission((CommandSender)sender, noSpy) || !Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw." + this.getInnerName() + ".pmspy") || recipient.equals(sender)) continue;
            recipients.add(recipient);
            sender.sendMessage(recipient.getName());
        }
        return recipients;
    }

    @Override
    public final String formatTo(Player sender, Player target, String msg) {
        return this.format(sender, this.formatToSting).replace("%2$s", msg).replace("%1$s", sender.getName());
    }

    @Override
    public final String formatFrom(Player sender, Player target, String msg) {
        if (msg.contains("$rsuffix")) {
            msg = msg.replace("$rsuffix", Main.getPermissionsHandler().getSuffix(target));
        }
        if (msg.contains("$rprefix")) {
            msg = msg.replace("$rprefix", Main.getPermissionsHandler().getPrefix(target));
        }
        if (msg.contains("$r")) {
            msg = msg.replace("$r", target.getName());
        }
        return this.format(sender, this.formatFromString).replace("%2$s", msg).replace("%1$s", sender.getName());
    }

    @Override
    public final String formatSpy(Player sender, Player target, String msg) {
        if (msg.contains("$rsuffix")) {
            msg = msg.replace("$rsuffix", Main.getPermissionsHandler().getSuffix(target));
        }
        if (msg.contains("$rprefix")) {
            msg = msg.replace("$rprefix", Main.getPermissionsHandler().getPrefix(target));
        }
        if (msg.contains("$r")) {
            msg = msg.replace("$r", target.getName());
        }
        return this.format(sender, this.formatSpyString).replace("%1$s", sender.getName()).replace("%2$s", msg);
    }

    @Override
    public void preSend(Player sender, String message, Set<Player> recipient) {
        this.sendMessage(sender, message);
    }

    @Override
    public final Set<Player> getSpyRecipients(Player sender) {
        return new HashSet<Player>();
    }
}

