/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat.chanels;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.chanels.ItemChanel;
import ru.dark32.chat.ichanels.IRangeChanel;

public class RangeItemChanel
extends ItemChanel
implements IRangeChanel {
    private final int range;

    public RangeItemChanel(String name) {
        super(name);
        String path_range = "Chat." + name + ".range";
        this.range = Main.chatConfig.getInt(path_range);
    }

    protected final int getDist(Location sender, Location target) {
        int distX = (int)(sender.getX() - target.getX());
        distX *= distX;
        int distY = (int)(sender.getY() - target.getY());
        distY *= distY;
        int distZ = (int)(sender.getZ() - target.getZ());
        distZ *= distZ;
        return distX + distY + distZ;
    }

    @Override
    public final int getRange() {
        return this.range;
    }

    @Override
    public Set<Player> getRecipients(Player sender) {
        HashSet<Player> recipients = new HashSet<Player>();
        for (Player recipient : Bukkit.getServer().getOnlinePlayers()) {
            boolean isWorld = this.isWorldChat() && sender.getWorld() == recipient.getWorld();
            int dist = this.getDist(sender.getLocation(), recipient.getLocation());
            boolean isRange = this.getRange() < 0 || dist < this.getRange();
            Util.DEBUG("debug: " + recipient.getName() + " | " + dist + "/" + this.range * this.range + "|" + isWorld, (CommandSender)sender);
            if (this.isRecipient(sender, recipient)) {
                Util.DEBUG("debug: isn't Recipient - " + recipient.getName(), (CommandSender)sender);
                continue;
            }
            if (Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw.spy")) {
                Util.DEBUG("debug: spy - " + recipient.getName(), (CommandSender)sender);
                recipients.add(recipient);
                continue;
            }
            if (isRange) {
                if (isWorld) {
                    Util.DEBUG("debug: in world - " + recipient.getName(), (CommandSender)sender);
                    recipients.add(recipient);
                    continue;
                }
                Util.DEBUG("debug: out of world - " + recipient.getName(), (CommandSender)sender);
                continue;
            }
            Util.DEBUG("debug: out of range - " + recipient.getName(), (CommandSender)sender);
        }
        return recipients;
    }

    @Override
    public String toString() {
        return super.toString() + ", range =>" + this.range;
    }
}

