/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat.chanels;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import ru.dark32.chat.Main;
import ru.dark32.chat.Util;
import ru.dark32.chat.ValueStorage;
import ru.dark32.chat.chanels.RangeItemChanel;
import ru.dark32.chat.ichanels.IRangeRequisiteItemChanel;

public class RangeRequisiteItemChanel
extends RangeItemChanel
implements IRangeRequisiteItemChanel {
    private final int requisiteItemAmount;
    private final int requisiteItemId;
    private final Material requisiteItemMaterial;
    private final int requisiteItemSubId;

    public RangeRequisiteItemChanel(String name) {
        super(name);
        String path_reqId = "Chat." + name + ".requisete.id";
        String path_reqSubId = "Chat." + name + ".requisete.subid";
        String path_reqAmount = "Chat." + name + ".requisete.amount";
        String path_reqMaterial = "Chat." + name + ".requisete.material";
        this.requisiteItemId = Main.chatConfig.getInt(path_reqId, this.getItemId());
        this.requisiteItemSubId = Main.chatConfig.getInt(path_reqSubId, this.getItemSubId());
        this.requisiteItemAmount = Main.chatConfig.getInt(path_reqAmount, 0);
        this.requisiteItemMaterial = Material.getMaterial((String)Main.chatConfig.getString(path_reqMaterial, this.getItemMaterial().name()));
    }

    @Override
    public boolean equalRequiseteItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        Util.DEBUG("debug inhand " + item.getTypeId() + ":" + item.getDurability() + " - " + item.getType());
        Util.DEBUG("debug need " + this.requisiteItemId + ":" + this.requisiteItemSubId + " - " + this.requisiteItemMaterial);
        boolean isItem = item.getDurability() == this.requisiteItemSubId && item.getAmount() >= this.requisiteItemAmount && (ValueStorage.experemental && item.getType() == this.requisiteItemMaterial || item.getTypeId() == this.requisiteItemId);
        return isItem;
    }

    @Override
    public Set<Player> getRecipients(Player sender) {
        HashSet<Player> recipients = new HashSet<Player>();
        for (Player recipient : Bukkit.getServer().getOnlinePlayers()) {
            boolean isWorld = !this.isWorldChat() || sender.getWorld() == recipient.getWorld();
            int dist = this.getDist(sender.getLocation(), recipient.getLocation());
            boolean isRange = this.getRange() == 0 || dist < this.getRange();
            boolean isTransceiver = Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw." + this.getInnerName() + ".no_item") || recipient == sender || this.hasItemInInvetery(recipient);
            Util.DEBUG("debug: " + recipient.getName() + " | " + dist + "/" + this.getRange() * this.getRange() + "|" + isWorld, (CommandSender)sender);
            if (this.isRecipient(sender, recipient)) {
                Util.DEBUG("debug: isn't Recipient - " + recipient.getName(), (CommandSender)sender);
                continue;
            }
            if (Main.getPermissionsHandler().hasPermission((CommandSender)recipient, "mcnw.spy")) {
                Util.DEBUG("debug: spy - " + recipient.getName(), (CommandSender)sender);
                recipients.add(recipient);
                continue;
            }
            if (isRange && isTransceiver) {
                if (isWorld) {
                    Util.DEBUG("debug: in world - " + recipient.getName(), (CommandSender)sender);
                    recipients.add(recipient);
                    continue;
                }
                Util.DEBUG("debug: out of world - " + recipient.getName(), (CommandSender)sender);
                continue;
            }
            Util.DEBUG("debug: out of range - " + recipient.getName(), (CommandSender)sender);
        }
        return recipients;
    }

    @Override
    public final int getRequiseteItemAmount() {
        return this.requisiteItemAmount;
    }

    @Override
    @Deprecated
    public final int getRequiseteItemId() {
        return this.requisiteItemId;
    }

    @Override
    public final Material getRequiseteItemMaterial() {
        return this.requisiteItemMaterial;
    }

    @Override
    public final int getRequiseteItemSubId() {
        return this.requisiteItemSubId;
    }

    private boolean hasItemInInvetery(Player player) {
        PlayerInventory inventary = player.getInventory();
        boolean hasItem = false;
        for (ItemStack item : inventary) {
            hasItem = this.equalRequiseteItem(item);
            if (!hasItem) continue;
            this.loseRequiseteItem(player, item);
            return hasItem;
        }
        return hasItem;
    }

    @Override
    public void loseRequiseteItem(Player player, ItemStack item) {
        if (this.requisiteItemAmount == 0) {
            return;
        }
        ItemStack loseItem = null;
        loseItem = ValueStorage.experemental ? new ItemStack(item.getType(), this.requisiteItemAmount) : new ItemStack(item.getTypeId(), this.requisiteItemAmount);
        player.getInventory().removeItem(new ItemStack[]{loseItem});
    }
}

