/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.chat.logger;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogAgent {
    private Logger logger;
    private static final Formatter FORMATTER = new LogFormatter();

    public LogAgent(String logName, File logFile) {
        this.logger = Logger.getLogger(logName);
        this.logger.setUseParentHandlers(false);
        try {
            FileHandler fHandler = new FileHandler(logFile.getAbsolutePath(), true);
            fHandler.setFormatter(FORMATTER);
            this.logger.addHandler(fHandler);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Failed write log to " + logFile.getAbsolutePath(), e);
        }
    }

    public void post(String message) {
        this.logger.log(Level.FINE, message);
    }

    public void info(String message) {
        this.logger.log(Level.INFO, message);
    }

    public void warning(String message) {
        this.logger.log(Level.WARNING, message);
    }

    private static class LogFormatter
    extends Formatter {
        private final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");

        private LogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.SDF.format(record.getMillis())).append("[").append(record.getLevel().getName()).append("] ").append(record.getMessage()).append("\n");
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                thrown.printStackTrace(new PrintWriter(sw));
                sb.append(sw.toString());
            }
            return sb.toString();
        }
    }
}

