/*
 * Decompiled with CFR 0.152.
 */
package ru.dark32.perm;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import ru.dark32.perm.IPermission;
import ru.dark32.perm.NullPermissionsHandler;
import ru.dark32.perm.PermissionsExHandler;
import ru.dark32.perm.SuperpermsHandler;

public class PermissionsHandler
implements IPermission {
    private transient IPermission handler = new NullPermissionsHandler();
    private transient String defaultGroup = "default";
    private final transient Plugin plugin;
    private static final Logger LOGGER = Logger.getLogger("rpChat2");

    public PermissionsHandler(Plugin plugin) {
        this.plugin = plugin;
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        Plugin permExPlugin = pluginManager.getPlugin("PermissionsEx");
        if (permExPlugin != null && permExPlugin.isEnabled()) {
            if (!(this.handler instanceof PermissionsExHandler)) {
                LOGGER.log(Level.INFO, "rpChat2: Using PermissionsEx based permissions.");
                this.handler = new PermissionsExHandler();
            }
            return;
        }
        if (!(this.handler instanceof SuperpermsHandler)) {
            LOGGER.log(Level.INFO, "rpChat2: Using superperms based permissions.");
            this.handler = new SuperpermsHandler();
        }
    }

    @Override
    public String getGroup(Player base) {
        String group = this.handler.getGroup(base);
        if (group == null) {
            group = this.defaultGroup;
        }
        return group;
    }

    @Override
    public List<String> getGroups(Player base) {
        List<String> groups = this.handler.getGroups(base);
        if (groups == null || groups.isEmpty()) {
            groups = Collections.singletonList(this.defaultGroup);
        }
        return Collections.unmodifiableList(groups);
    }

    @Override
    public boolean inGroup(Player base, String group) {
        return this.handler.inGroup(base, group);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String node) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.handler.hasPermission(sender, node);
    }

    @Override
    public String getPrefix(Player base) {
        String prefix = this.handler.getPrefix(base);
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    @Override
    public String getSuffix(Player base) {
        String suffix = this.handler.getSuffix(base);
        if (suffix == null) {
            suffix = "";
        }
        return suffix;
    }

    public String getName() {
        return this.handler.getClass().getSimpleName().replace("Handler", "");
    }

    @Override
    public boolean hasPermission(String target, String node) {
        return this.handler.hasPermission(target, node);
    }
}

