/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.yegamolchattels.blocks.TileEntityMicroBlock;
import ivorius.yegamolchattels.blocks.YGCBlocks;
import ivorius.yegamolchattels.items.ItemBlockFragment;
import ivorius.yegamolchattels.items.ItemChisel;
import ivorius.yegamolchattels.items.ItemMicroBlock;
import ivorius.yegamolchattels.items.YGCItems;
import ivorius.yegamolchattels.materials.YGCMaterials;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMicroBlock
extends BlockContainer {
    public boolean[] renderSideCache = new boolean[6];
    public Block renderBlockCache;
    public int renderBlockMetaCache;

    public BlockMicroBlock() {
        super(YGCMaterials.mixed);
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return ((TileEntityMicroBlock)world.func_147438_o(x, y, z)).isSideOpaque(side);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityMicroBlock microBlock;
        if (!world.field_72995_K && (microBlock = (TileEntityMicroBlock)world.func_147438_o(x, y, z)).shouldDropAsItem()) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            ItemMicroBlock.setMicroBlock(stack, microBlock.getBlockCollection());
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149681_a(World world, int x, int y, int z, int side, EntityPlayer player) {
        TileEntity tileEntity;
        super.func_149681_a(world, x, y, z, side, player);
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == YGCItems.clubHammer && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityMicroBlock) {
            BlockMicroBlock.dropAllMicroblockFragments((TileEntityMicroBlock)tileEntity, 0.7f);
        }
    }

    public static void dropAllMicroblockFragments(TileEntityMicroBlock tileEntityMicroBlock, float dropChance) {
        World world = tileEntityMicroBlock.func_145831_w();
        int x = tileEntityMicroBlock.field_145851_c;
        int y = tileEntityMicroBlock.field_145848_d;
        int z = tileEntityMicroBlock.field_145849_e;
        IvBlockCollection collection = tileEntityMicroBlock.getBlockCollection();
        if (!world.field_72995_K) {
            for (BlockCoord coord : collection) {
                Block block = collection.getBlock(coord);
                if (block.func_149688_o() == Material.field_151579_a || !(world.field_73012_v.nextFloat() < dropChance)) continue;
                ItemStack drop = new ItemStack(YGCItems.blockFragment);
                ItemBlockFragment.setFragment(drop, new ItemChisel.BlockData(block, collection.getMetadata(coord)));
                EntityItem entityItem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, drop);
                world.func_72838_d((Entity)entityItem);
            }
        }
        tileEntityMicroBlock.setShouldDropAsItem(false);
        world.func_147468_f(x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack stack) {
        IvBlockCollection collection;
        super.func_149689_a(world, x, y, z, entityLivingBase, stack);
        if (!world.field_72995_K && (collection = ItemMicroBlock.containedMicroBlock(stack)) != null) {
            ((TileEntityMicroBlock)world.func_147438_o(x, y, z)).setBlockCollection(collection);
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        ItemChisel.MicroBlockFragment hitFragment = ItemChisel.getHoveredFragment(world, x, y, z, start, Vec3.func_72443_a((double)(end.field_72450_a - start.field_72450_a), (double)(end.field_72448_b - start.field_72448_b), (double)(end.field_72449_c - start.field_72449_c)));
        return hitFragment != null ? new MovingObjectPosition(x, y, z, hitFragment.getInternalSide().ordinal(), hitFragment.getHitPoint()) : null;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB box, List list, Entity entity) {
        AxisAlignedBB thisBox = this.func_149668_a(world, x, y, z);
        if (thisBox != null && box.func_72326_a(thisBox)) {
            TileEntityMicroBlock microBlock = (TileEntityMicroBlock)world.func_147438_o(x, y, z);
            IvBlockCollection collection = microBlock.getBlockCollection();
            double oneX = 1.0 / (double)collection.width;
            double oneY = 1.0 / (double)collection.height;
            double oneZ = 1.0 / (double)collection.length;
            for (BlockCoord coord : collection) {
                AxisAlignedBB bb;
                if (collection.getBlock(coord).func_149688_o() == Material.field_151579_a || !(bb = AxisAlignedBB.func_72330_a((double)((double)coord.x * oneX + (double)x), (double)((double)coord.y * oneY + (double)y), (double)((double)coord.z * oneZ + (double)z), (double)((double)(coord.x + 1) * oneX + (double)x), (double)((double)(coord.y + 1) * oneY + (double)y), (double)((double)(coord.z + 1) * oneZ + (double)z))).func_72326_a(box)) continue;
                list.add(bb);
            }
        }
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int func_149645_b() {
        return YGCBlocks.blockMicroBlockRenderType;
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.renderBlockCache != null ? this.renderBlockCache.func_149691_a(side, this.renderBlockMetaCache) : Blocks.field_150344_f.func_149691_a(0, 0);
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.renderSideCache[side];
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityMicroBlock();
    }
}

