/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Statue {
    private Entity entity;
    private BlockFragment material;
    private float yawHead;
    private float pitchHead;
    private float swing;
    private float stance;

    public Statue(Entity entity, BlockFragment material, float yawHead, float pitchHead, float swing, float stance) {
        this.entity = entity;
        this.material = material;
        this.yawHead = yawHead;
        this.pitchHead = pitchHead;
        this.swing = swing;
        this.stance = stance;
    }

    public Statue(NBTTagCompound compound, World worldObj) {
        this.entity = compound.func_74764_b("entity") ? EntityList.func_75615_a((NBTTagCompound)compound.func_74775_l("entity"), (World)worldObj) : new EntityPig(worldObj);
        this.yawHead = compound.func_74760_g("yawHead");
        this.pitchHead = compound.func_74760_g("pitchHead");
        this.swing = compound.func_74760_g("swing");
        this.stance = compound.func_74760_g("stance");
        this.material = compound.func_74764_b("block") ? Statue.getMaterial(compound) : new BlockFragment(Blocks.field_150348_b, 0);
    }

    public static void setRotations(EntityLivingBase entityLivingBase, float yawHead, float pitchHead, float swing, float stance) {
        entityLivingBase.field_70733_aJ = swing;
        entityLivingBase.field_70732_aI = swing;
        entityLivingBase.field_70754_ba = stance;
        entityLivingBase.field_70721_aZ = 0.0f;
        entityLivingBase.field_70722_aY = 1.0f;
        entityLivingBase.field_70759_as = yawHead;
        entityLivingBase.field_70758_at = yawHead;
        entityLivingBase.field_70125_A = pitchHead;
        entityLivingBase.field_70127_C = pitchHead;
    }

    public static String getEntityID(NBTTagCompound compound) {
        return compound.func_74775_l("entity").func_74779_i("id");
    }

    public static BlockFragment getMaterial(NBTTagCompound compound) {
        return new BlockFragment(Block.func_149684_b((String)compound.func_74779_i("block")), compound.func_74762_e("blockMetadata"));
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public BlockFragment getMaterial() {
        return this.material;
    }

    public void setMaterial(BlockFragment material) {
        this.material = material;
    }

    public float getYawHead() {
        return this.yawHead;
    }

    public void setYawHead(float yawHead) {
        this.yawHead = yawHead;
    }

    public float getPitchHead() {
        return this.pitchHead;
    }

    public void setPitchHead(float pitchHead) {
        this.pitchHead = pitchHead;
    }

    public float getSwing() {
        return this.swing;
    }

    public void setSwing(float swing) {
        this.swing = swing;
    }

    public float getStance() {
        return this.stance;
    }

    public void setStance(float stance) {
        this.stance = stance;
    }

    public void updateEntityRotations() {
        if (this.entity instanceof EntityLivingBase) {
            Statue.setRotations((EntityLivingBase)this.entity, this.yawHead, this.pitchHead, this.swing, this.stance);
        }
    }

    public NBTTagCompound createTagCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.entity != null) {
            NBTTagCompound statueCompound = new NBTTagCompound();
            this.entity.func_70039_c(statueCompound);
            compound.func_74782_a("entity", (NBTBase)statueCompound);
        }
        compound.func_74776_a("yawHead", this.yawHead);
        compound.func_74776_a("pitchHead", this.pitchHead);
        compound.func_74776_a("swing", this.swing);
        compound.func_74776_a("stance", this.stance);
        if (this.material != null) {
            compound.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.material.getBlock()));
            compound.func_74768_a("blockMetadata", this.material.getMetadata());
        }
        return compound;
    }

    public static class BlockFragment {
        private Block block;
        private int metadata;

        public BlockFragment(Block block, int metadata) {
            this.block = block;
            this.metadata = metadata;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockFragment that = (BlockFragment)o;
            if (this.metadata != that.metadata) {
                return false;
            }
            return this.block.equals(that.block);
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = 31 * result + this.metadata;
            return result;
        }
    }
}

