/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityHelper;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.items.YGCItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityGrindstone
extends TileEntity
implements PartialUpdateHandler {
    public static final int maxGrindstoneHealth = 30;
    public int grindstoneHealth;
    public int grindstoneRotationSpeed;
    public int crankRotationTime;
    public int timeSharpening;
    public int ticksTillSound;
    public int grindstoneRotationVisual;
    public float crankRotationVisual;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.grindstoneRotationSpeed > 0) {
            --this.grindstoneRotationSpeed;
        }
        if (this.grindstoneHealth == 0) {
            this.grindstoneRotationSpeed = 0;
        }
        this.grindstoneRotationVisual = (this.grindstoneRotationVisual + this.grindstoneRotationSpeed) % 40000;
        if (this.crankRotationTime > 0) {
            --this.crankRotationTime;
            this.crankRotationVisual += 0.4f;
        }
        if (!this.func_145831_w().field_72995_K && this.grindstoneRotationSpeed > 150 && this.ticksTillSound == 0) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "minecart.inside", 0.25f, 0.5f);
            this.ticksTillSound = 100;
        }
        if (this.ticksTillSound > 0) {
            --this.ticksTillSound;
        }
        if (this.timeSharpening > 0) {
            --this.timeSharpening;
            Random rand = this.func_145831_w().field_73012_v;
            if (!this.func_145831_w().field_72995_K && rand.nextFloat() < 0.01f) {
                ItemStack sandStack = new ItemStack((Block)Blocks.field_150354_m);
                EntityItem sandItem = new EntityItem(this.func_145831_w(), (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), sandStack);
                this.func_145831_w().func_72838_d((Entity)sandItem);
            }
            this.func_145831_w().func_72869_a("blockcrack_" + Block.func_149682_b((Block)Blocks.field_150354_m) + "_0", (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.7f), (double)((float)this.field_145849_e + 0.5f), (double)(rand.nextFloat() * 0.2f - 0.1f), (double)0.1f, (double)(rand.nextFloat() * 0.2f - 0.1f));
        }
    }

    public boolean tryApplyingItem(ItemStack stack, EntityLivingBase entity) {
        if (stack != null && stack.func_77973_b() == YGCItems.grindstoneStone && this.grindstoneHealth == 0) {
            if (!this.field_145850_b.field_72995_K) {
                this.grindstoneHealth = 30;
                --stack.field_77994_a;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"grindstoneData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean tryRepairingItem(ItemStack stack, EntityLivingBase entity) {
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (this.grindstoneRotationSpeed > 60 && this.timeSharpening == 0) {
                String toolMaterialName;
                boolean isRepairable = false;
                if (item instanceof ItemSword && ((toolMaterialName = ((ItemSword)item).func_150932_j()).equals("STONE") || toolMaterialName.equals("GOLD") || toolMaterialName.equals("IRON"))) {
                    isRepairable = true;
                }
                if (item instanceof ItemTool && ((toolMaterialName = ((ItemTool)item).func_77861_e()).equals("STONE") || toolMaterialName.equals("GOLD") || toolMaterialName.equals("IRON"))) {
                    isRepairable = true;
                }
                if (isRepairable) {
                    float itemSurvivalChance;
                    int currentItemRepairs = TileEntityGrindstone.getCurrentRepairs(stack);
                    float f = itemSurvivalChance = currentItemRepairs > 10 ? 1.0f / (1.0f + (float)currentItemRepairs * 0.02f) : 1.0f;
                    if (!this.func_145831_w().field_72995_K && this.func_145831_w().field_73012_v.nextFloat() > itemSurvivalChance) {
                        --stack.field_77994_a;
                        if (entity != null) {
                            entity.func_70669_a(stack);
                        }
                    } else {
                        TileEntityGrindstone.setCurrentRepairs(stack, ++currentItemRepairs);
                    }
                    stack.func_77964_b(Math.max(stack.func_77960_j() - 10, 0));
                    --this.grindstoneHealth;
                    float chanceToSurvive = (float)this.grindstoneHealth * 0.2f;
                    if (!this.func_145831_w().field_72995_K && this.func_145831_w().field_73012_v.nextFloat() > chanceToSurvive) {
                        for (int i = 0; i < 4; ++i) {
                            ItemStack sandStack = new ItemStack((Block)Blocks.field_150354_m);
                            EntityItem sandItem = new EntityItem(this.func_145831_w(), (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), sandStack);
                            this.func_145831_w().func_72838_d((Entity)sandItem);
                        }
                        this.grindstoneHealth = 0;
                    } else {
                        this.timeSharpening = 30;
                    }
                    IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"grindstoneData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                    this.func_70296_d();
                    return true;
                }
            }
        }
        return false;
    }

    public void increaseGrindstoneRotation() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.grindstoneHealth > 0) {
                this.grindstoneRotationSpeed += 100;
                if (this.grindstoneRotationSpeed > 1000) {
                    this.grindstoneRotationSpeed = 1000;
                }
            }
            this.crankRotationTime += 10;
            if (this.crankRotationTime > 30) {
                this.crankRotationTime = 30;
            }
            IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"grindstoneData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.grindstoneHealth = par1nbtTagCompound.func_74762_e("grindstoneHealth");
        this.grindstoneRotationSpeed = par1nbtTagCompound.func_74762_e("rotationSpeed");
        this.crankRotationTime = par1nbtTagCompound.func_74762_e("crankRotationTime");
        this.timeSharpening = par1nbtTagCompound.func_74762_e("timeSharpening");
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("grindstoneHealth", this.grindstoneHealth);
        par1nbtTagCompound.func_74768_a("rotationSpeed", this.grindstoneRotationSpeed);
        par1nbtTagCompound.func_74768_a("crankRotationTime", this.crankRotationTime);
        par1nbtTagCompound.func_74768_a("timeSharpening", this.timeSharpening);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        return IvTileEntityHelper.getStandardDescriptionPacket((TileEntity)this);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("grindstoneData".equals(context)) {
            buffer.writeInt(this.grindstoneHealth);
            buffer.writeInt(this.grindstoneRotationSpeed);
            buffer.writeInt(this.crankRotationTime);
            buffer.writeInt(this.timeSharpening);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("grindstoneData".equals(context)) {
            this.grindstoneHealth = buffer.readInt();
            this.grindstoneRotationSpeed = buffer.readInt();
            this.crankRotationTime = buffer.readInt();
            this.timeSharpening = buffer.readInt();
        }
    }

    public static int getCurrentRepairs(ItemStack stack) {
        NBTTagCompound itemTagCompound = stack.func_77978_p();
        if (itemTagCompound != null && itemTagCompound.func_74764_b("grindstoneRepairs")) {
            return itemTagCompound.func_74762_e("grindstoneRepairs");
        }
        return 0;
    }

    public static void setCurrentRepairs(ItemStack stack, int repairs) {
        stack.func_77983_a("grindstoneRepairs", (NBTBase)new NBTTagInt(repairs));
    }
}

