/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.entities.IvEntityHelper;
import ivorius.ivtoolkit.raytracing.IvRaytraceableObject;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import ivorius.ivtoolkit.raytracing.IvRaytracerMC;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class TileEntityItemShelf
extends IvTileEntityMultiBlock {
    public ItemStack[] storedItems = new ItemStack[50];
    public int ticksAlive = 0;
    public int randomSeed = 0;
    public boolean[] shelfTriggers = new boolean[10];
    public float[] shelfTriggerFractions = new float[10];

    public TileEntityItemShelf() {
    }

    public TileEntityItemShelf(World world) {
        this.randomSeed = world.field_73012_v.nextInt(Integer.MAX_VALUE);
    }

    public void updateEntityParent() {
        super.updateEntityParent();
        for (int i = 0; i < this.shelfTriggers.length; ++i) {
            this.shelfTriggerFractions[i] = this.shelfTriggers[i] ? Math.min(1.0f, this.shelfTriggerFractions[i] + 0.25f) : Math.max(0.0f, this.shelfTriggerFractions[i] - 0.25f);
        }
        ++this.ticksAlive;
    }

    public int getShelfType() {
        return this.func_145832_p();
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        NBTTagList items = par1nbtTagCompound.func_150295_c("Items", 10);
        this.storedItems = new ItemStack[this.storedItems.length];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound var4 = items.func_150305_b(i);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.storedItems.length) continue;
            this.storedItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        int triggers = this.shelfTriggers.length;
        this.shelfTriggers = new boolean[triggers];
        this.shelfTriggerFractions = new float[triggers];
        for (int i = 0; i < triggers; ++i) {
            this.shelfTriggerFractions[i] = par1nbtTagCompound.func_74760_g("shelfTriggerVal" + i);
            this.shelfTriggers[i] = par1nbtTagCompound.func_74767_n("shelfTrigger" + i);
        }
        this.ticksAlive = par1nbtTagCompound.func_74762_e("ticksAlive");
        this.randomSeed = par1nbtTagCompound.func_74762_e("randomSeed");
        if (this.randomSeed < 0) {
            this.randomSeed = this.field_145850_b.field_73012_v.nextInt(Integer.MAX_VALUE);
        }
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.storedItems.length; ++i) {
            if (this.storedItems[i] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            this.storedItems[i].func_77955_b(var4);
            items.func_74742_a((NBTBase)var4);
        }
        int triggers = this.shelfTriggers.length;
        for (int i = 0; i < triggers; ++i) {
            par1nbtTagCompound.func_74776_a("shelfTriggerVal" + i, this.shelfTriggerFractions[i]);
            par1nbtTagCompound.func_74757_a("shelfTrigger" + i, this.shelfTriggers[i]);
        }
        par1nbtTagCompound.func_74782_a("Items", (NBTBase)items);
        par1nbtTagCompound.func_74768_a("ticksAlive", this.ticksAlive);
        par1nbtTagCompound.func_74768_a("randomSeed", this.randomSeed);
    }

    public boolean onRightClick(EntityPlayer player, ItemStack stack, int side) {
        if (!this.isParent()) {
            TileEntityItemShelf parent = (TileEntityItemShelf)this.getParent();
            return parent != null && parent.onRightClick(player, stack, side);
        }
        List<IvRaytraceableObject> raytraceables = this.getRaytraceableObjects(0.0f);
        IvRaytracedIntersection intersection = IvRaytracerMC.getFirstIntersection(raytraceables, (Entity)player);
        if (intersection != null) {
            if (this.handleRightClickOnIntersection(player, stack, side, intersection)) {
                return true;
            }
            int slotNumber = this.getSlotNumber(intersection.getHitObject());
            int triggerNumber = this.getInfoNumber(intersection.getHitObject(), "Trigger-");
            if (slotNumber >= 0) {
                if (stack != null && this.tryStoringItemInSlot(slotNumber, stack)) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (this.tryEquippingItemOnPlayer(slotNumber, player)) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                return true;
            }
            if (triggerNumber >= 0 && triggerNumber < this.shelfTriggers.length) {
                if (!this.field_145850_b.field_72995_K) {
                    this.activateTrigger(triggerNumber);
                }
                return true;
            }
        }
        return false;
    }

    public abstract void activateTrigger(int var1);

    public abstract boolean handleRightClickOnIntersection(EntityPlayer var1, ItemStack var2, int var3, IvRaytracedIntersection var4);

    public void dropAllItems() {
        for (int i = 0; i < this.getItemSlots(); ++i) {
            this.tryDroppingItem(i);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public abstract int getItemSlots();

    public int getHoveredSlot(Entity entity) {
        String info;
        List<IvRaytraceableObject> raytraceables = this.getRaytraceableObjects(0.0f);
        IvRaytracedIntersection intersection = IvRaytracerMC.getFirstIntersection(raytraceables, (Entity)entity);
        if (intersection != null && (info = (String)intersection.getUserInfo()).startsWith("Slot")) {
            Integer number = Integer.valueOf(info.substring(4));
            return number;
        }
        return -1;
    }

    public abstract List<IvRaytraceableObject> getRaytraceableObjects(float var1);

    public abstract List<IvRaytraceableObject> getItemSlotBoxes(float var1);

    public boolean tryEquippingItemOnPlayer(int slot, EntityPlayer entityLiving) {
        if (this.storedItems[slot] != null && IvEntityHelper.addAsCurrentItem((EntityPlayer)entityLiving, (ItemStack)this.storedItems[slot])) {
            this.storedItems[slot] = null;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public abstract boolean tryStoringItemInSlot(int var1, ItemStack var2);

    public void storeItemInSlot(ItemStack stack, int slot) {
        this.storedItems[slot] = stack.func_77946_l();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getStoredItemInSlot(int slot) {
        return this.storedItems[slot];
    }

    public int getSlotNumber(IvRaytraceableObject object) {
        return this.getInfoNumber(object, "Slot");
    }

    public int getInfoNumber(IvRaytraceableObject object, String start) {
        String userString;
        if (object.userInfo instanceof String && (userString = (String)object.userInfo).startsWith(start)) {
            return Integer.valueOf(userString.substring(start.length()));
        }
        return -1;
    }

    public void tryDroppingItem(int slot) {
        if (this.storedItems[slot] != null) {
            float var7 = 0.7f;
            double var8 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
            double var10 = (double)this.field_145850_b.field_73012_v.nextFloat() * 0.2 + 1.1;
            double var12 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
            EntityItem var14 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var8, (double)this.field_145848_d + var10, (double)this.field_145849_e + var12, this.storedItems[slot]);
            var14.field_145804_b = 10;
            this.field_145850_b.func_72838_d((Entity)var14);
            this.storedItems[slot] = null;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public float getTriggerValue(int slot, float t) {
        if (this.shelfTriggers[slot]) {
            return Math.min(1.0f, this.shelfTriggerFractions[slot] + 0.25f * t);
        }
        return Math.max(0.0f, this.shelfTriggerFractions[slot] - 0.25f * t);
    }

    public float[] getTriggerValues(float t) {
        float[] values = new float[this.shelfTriggerFractions.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getTriggerValue(i, t);
        }
        return values;
    }

    public abstract AxisAlignedBB getSpecialSelectedBB();

    public abstract AxisAlignedBB getSpecialCollisionBB();

    public abstract AxisAlignedBB getSpecialBlockBB();
}

