/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.raytracing.IvRaytraceableObject;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import ivorius.yegamolchattels.blocks.TileEntityItemShelf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityItemShelfModel0
extends TileEntityItemShelf
implements PartialUpdateHandler {
    public static final int shelfJamien = 0;
    public static final int shelfWall = 1;
    public static final int shelfWardrobe = 2;
    public boolean narniaActivating;
    public float narniaProgress;

    public TileEntityItemShelfModel0() {
    }

    public TileEntityItemShelfModel0(World world) {
        this.randomSeed = world.field_73012_v.nextInt(Integer.MAX_VALUE);
    }

    @Override
    public void updateEntityParent() {
        super.updateEntityParent();
        this.narniaProgress = IvMathHelper.nearValue((float)this.narniaProgress, (float)(this.narniaActivating ? 1.0f : 0.0f), (float)0.0f, (float)0.01f);
        if (this.field_145850_b.field_72995_K && this.getTriggerValue(0, 0.0f) > 0.5f) {
            int portalParticles = IvMathHelper.randomLinearNumber((Random)this.field_145850_b.field_73012_v, (float)(this.narniaProgress * 1.5f));
            double[] center = this.getActiveCenterCoords();
            for (int i = 0; i < portalParticles; ++i) {
                Vector3f frontDir = this.getRotatedVector(new Vector3f(0.0f, 0.0f, 1.0f));
                Vector3f sideDir = this.getRotatedVector(new Vector3f(1.0f, 0.0f, 0.0f));
                double xP = center[0] - 0.45 + (double)sideDir.getX() * this.field_145850_b.field_73012_v.nextDouble() * 0.9;
                double yP = center[1] - 0.25 + this.field_145850_b.field_73012_v.nextDouble();
                double zP = center[2] - 0.45 + (double)sideDir.getZ() * this.field_145850_b.field_73012_v.nextDouble() * 0.9;
                this.field_145850_b.func_72869_a("portal", xP, yP, zP, (double)(-frontDir.getX()), (double)frontDir.getY(), (double)(-frontDir.getZ()));
            }
        }
    }

    @Override
    public int getItemSlots() {
        int shelfType = this.getShelfType();
        if (shelfType == 0) {
            return 10;
        }
        if (shelfType == 1) {
            return 4;
        }
        if (shelfType == 2) {
            return 12;
        }
        return 0;
    }

    @Override
    public List<IvRaytraceableObject> getRaytraceableObjects(float t) {
        ArrayList<IvRaytraceableObject> raytraceables = new ArrayList<IvRaytraceableObject>();
        raytraceables.addAll(this.getItemSlotBoxes(t));
        int shelfType = this.getShelfType();
        if (shelfType == 0) {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallBack", -1.0, -0.5, 0.4, 2.0, 1.0, 0.1));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallLeft", -0.85, -0.5, -0.3, 0.1, 1.0, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallRight", 0.75, -0.5, -0.3, 0.1, 1.0, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallTop", -1.0, 0.4, -0.3, 2.0, 0.1, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallBottom", -1.0, -0.25, -0.3, 2.0, 0.1, 0.6));
        } else if (shelfType == 1) {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallBottom", -0.5, -0.35, -0.1, 1.0, 0.1, 0.6));
        } else if (shelfType == 2) {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallBack", -0.5, -1.0, 0.4, 1.0, 2.0, 0.1));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallPortal", -0.5, -1.0, 0.39, 1.0, 2.0, 0.01));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallLeft", -0.5, -1.0, -0.1, 0.1, 2.0, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallRight", 0.4, -1.0, -0.1, 0.1, 2.0, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallTop", -0.5, 0.9, -0.1, 1.0, 0.1, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallBottom", -0.5, -0.875, -0.125, 1.0, 0.125, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("WallBottomDoors", -0.5, -0.375, -0.125, 1.0, 0.125, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("Trigger-0", -0.5, -0.25, -0.125, 0.5, 1.125, 0.1, -0.5, -0.25, -0.5, 0.2, 1.125, 0.4, this.getTriggerValue(0, t)));
            raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("Trigger-0", 0.0, -0.25, -0.125, 0.5, 1.125, 0.1, 0.3, -0.25, -0.5, 0.2, 1.125, 0.4, this.getTriggerValue(0, t)));
            for (int i = 0; i < 2; ++i) {
                float triggerVal = this.getTriggerValue(1 + i, t);
                double sHeight = i == 0 ? -0.5625 : -0.75;
                raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("Trigger-" + (i + 1), -0.375, sHeight, -0.125, 0.75, 0.1875, 0.01, -0.375, sHeight, -0.5, 0.75, 0.1875, 0.01, triggerVal));
                raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("DrawerBottom-" + (i + 1), -0.375, sHeight, -0.125, 0.75, 0.01, 0.5, -0.375, sHeight, -0.5, 0.75, 0.01, 0.5, triggerVal));
                raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("DrawerLeft-" + (i + 1), -0.375, sHeight, -0.125, 0.01, 0.1875, 0.5, -0.375, sHeight, -0.5, 0.01, 0.1875, 0.5, triggerVal));
                raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("DrawerRight-" + (i + 1), 0.374, sHeight, -0.125, 0.01, 0.1875, 0.5, 0.374, sHeight, -0.5, 0.01, 0.1875, 0.5, triggerVal));
            }
        }
        return raytraceables;
    }

    @Override
    public List<IvRaytraceableObject> getItemSlotBoxes(float t) {
        ArrayList<IvRaytraceableObject> raytraceables;
        block7: {
            int shelfType;
            block8: {
                block6: {
                    raytraceables = new ArrayList<IvRaytraceableObject>();
                    shelfType = this.getShelfType();
                    if (shelfType != 0) break block6;
                    int itemsPL = 5;
                    float width = 1.4f;
                    float paddingSides = 0.0f;
                    for (int l = 0; l < 2; ++l) {
                        for (int i = 0; i < itemsPL; ++i) {
                            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot" + (i + l * itemsPL), -width / 2.0f + width / (float)itemsPL * (float)i + paddingSides, l == 0 ? (double)-0.13f : (double)0.17f, -0.23f, width / (float)itemsPL - paddingSides * 2.0f, 0.18f, 0.25));
                        }
                    }
                    break block7;
                }
                if (shelfType != 1) break block8;
                int itemsPL = 4;
                float width = 0.9f;
                float paddingSides = 0.0f;
                for (int i = 0; i < itemsPL; ++i) {
                    raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot" + i, -width / 2.0f + width / (float)itemsPL * (float)i + paddingSides, -0.25, 0.0, width / (float)itemsPL - paddingSides * 2.0f, 0.2f, 0.2f));
                }
                break block7;
            }
            if (shelfType != 2) break block7;
            for (int h = 0; h < 2; ++h) {
                double shelfH = h == 0 ? -0.5625 : -0.75;
                float frac = this.getTriggerValue(h + 1, t);
                for (int i = 0; i < 2; ++i) {
                    for (int n = 0; n < 2; ++n) {
                        raytraceables.add((IvRaytraceableObject)this.getInterpolatedRotatedBox("Slot" + (h * 4 + i * 2 + n), -0.22 + (double)i * 0.24, shelfH, -0.115 + 0.2 * (double)n, 0.2, 0.18, 0.2, -0.22 + (double)i * 0.24, shelfH, -0.49 + 0.2 * (double)n, 0.2, 0.18, 0.2, frac));
                    }
                }
                raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot8", -0.36, 0.2, -0.1, 0.15, 0.6, 0.45));
                raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot9", -0.17, 0.2, -0.1, 0.15, 0.6, 0.45));
                raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot10", 0.02, 0.2, -0.1, 0.15, 0.6, 0.45));
                raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot11", 0.21, 0.2, -0.1, 0.15, 0.6, 0.45));
            }
        }
        return raytraceables;
    }

    @Override
    public boolean tryStoringItemInSlot(int slot, ItemStack stack) {
        if (stack != null && this.storedItems[slot] == null && slot < this.getItemSlots()) {
            boolean canStore = true;
            if (!(this.getShelfType() != 2 || slot != 8 && slot != 9 && slot != 10 && slot != 11 || stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a == 1)) {
                canStore = false;
            }
            if (canStore) {
                if (!this.field_145850_b.field_72995_K) {
                    this.storeItemInSlot(stack, slot);
                    double[] center = this.getActiveCenterCoords();
                    this.field_145850_b.func_72908_a(center[0], center[1], center[2], "dig.wood", 0.5f, 1.0f + this.field_145850_b.field_73012_v.nextFloat());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public AxisAlignedBB getSpecialSelectedBB() {
        if (this.getShelfType() == 1) {
            return this.getRotatedBB(-0.5, -0.375, -0.125, 1.0, 0.4, 0.625);
        }
        return null;
    }

    @Override
    public AxisAlignedBB getSpecialCollisionBB() {
        if (this.getShelfType() == 1) {
            return this.getRotatedBB(-0.5, -0.375, -0.125, 1.0, 0.125, 0.625);
        }
        return null;
    }

    @Override
    public AxisAlignedBB getSpecialBlockBB() {
        if (this.getShelfType() == 1) {
            return this.getRotatedBB(-0.5, -0.375, -0.125, 1.0, 0.4, 0.625);
        }
        return null;
    }

    public static List<int[]> getPositionsForType(int shelfType) {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        if (shelfType == 0) {
            positions.add(new int[]{0, 0, 0});
            positions.add(new int[]{1, 0, 0});
        } else if (shelfType == 1) {
            positions.add(new int[]{0, 0, 0});
        } else if (shelfType == 2) {
            positions.add(new int[]{0, 0, 0});
            positions.add(new int[]{0, 1, 0});
        } else {
            positions.add(new int[]{0, 0, 0});
        }
        return positions;
    }

    public static boolean tryAutocompletingBook(ItemStack stack, String[] book, boolean sign) {
        if (stack != null && stack.func_77973_b() == Items.field_151099_bA) {
            NBTTagCompound var4;
            NBTTagList pages;
            if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("pages")) {
                stack.func_77983_a("pages", (NBTBase)new NBTTagList());
            }
            if ((pages = (var4 = stack.func_77978_p()).func_150295_c("pages", 8)).func_74745_c() <= book.length - 2) {
                for (int n = 0; n < pages.func_74745_c(); ++n) {
                    String data = pages.func_150307_f(n);
                    if (book[n + 2].startsWith(data)) {
                        if (book[n + 2].length() <= data.length()) continue;
                        data = data + book[n + 2].charAt(data.length());
                        pages.func_74744_a(n);
                        pages.func_74742_a((NBTBase)new NBTTagString(data));
                        return true;
                    }
                    return false;
                }
                if (pages.func_74745_c() < book.length - 2) {
                    pages.func_74742_a((NBTBase)new NBTTagString("" + pages.func_74745_c() + 1));
                    return true;
                }
                if (sign) {
                    stack.func_77983_a("author", (NBTBase)new NBTTagString(book[1]));
                    stack.func_77983_a("title", (NBTBase)new NBTTagString(book[0]));
                    stack.func_150996_a(Items.field_151164_bB);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void activateTrigger(int trigger) {
        this.shelfTriggers[trigger] = !this.shelfTriggers[trigger];
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.shelfTriggers[trigger]) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.chestopen", 0.3f, 1.6f);
        } else {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), "random.chestclosed", 0.3f, 1.6f);
        }
    }

    @Override
    public boolean handleRightClickOnIntersection(EntityPlayer player, ItemStack stack, int side, IvRaytracedIntersection intersection) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.narniaActivating = par1nbtTagCompound.func_74767_n("narniaActivating");
        this.narniaProgress = par1nbtTagCompound.func_74760_g("narniaProgress");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a("narniaActivating", this.narniaActivating);
        par1nbtTagCompound.func_74776_a("narniaProgress", this.narniaProgress);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("narniaProgress".equals(context)) {
            buffer.writeBoolean(this.narniaActivating);
            buffer.writeFloat(this.narniaProgress);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("narniaProgress".equals(context)) {
            this.narniaActivating = buffer.readBoolean();
            this.narniaProgress = buffer.readFloat();
        }
    }
}

