/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.entities.IvEntityHelper;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.EnumPedestalEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityPedestal
extends IvTileEntityMultiBlock
implements PartialUpdateHandler {
    public int pedestalIdentifier;
    public int ticksAlive;
    public ItemStack storedItem;
    public int timeItemUp;
    public boolean itemShouldBeUp = false;

    public void updateEntityParent() {
        super.updateEntityParent();
        if (this.isParent()) {
            if (this.itemShouldBeUp && this.timeItemUp < this.getIntegrationTime()) {
                ++this.timeItemUp;
            } else if (!this.itemShouldBeUp && this.timeItemUp > 0) {
                --this.timeItemUp;
            } else if (!this.itemShouldBeUp && this.storedItem != null) {
                this.dropItem();
            }
            if (this.timeItemUp > 0) {
                int cloudN;
                float fractionUp = this.getFractionItemUp();
                float cloudC = 0.0f;
                if (this.pedestalIdentifier == 3) {
                    cloudC = fractionUp * 0.2f;
                }
                if (this.pedestalIdentifier == 4) {
                    cloudC = fractionUp * 0.6f;
                }
                for (cloudN = 0; this.field_145850_b.field_73012_v.nextFloat() < cloudC && cloudN < 10; ++cloudN) {
                }
                for (int i = 0; i < cloudN; ++i) {
                    float xPlus = this.field_145850_b.field_73012_v.nextFloat() * 1.6f - 0.3f;
                    float yPlus = this.field_145850_b.field_73012_v.nextFloat() * this.field_145850_b.field_73012_v.nextFloat() * 0.2f;
                    float zPlus = this.field_145850_b.field_73012_v.nextFloat() * 1.6f - 0.3f;
                    this.field_145850_b.func_72869_a("cloud", (double)((float)this.field_145851_c + xPlus), (double)((float)this.field_145848_d + yPlus), (double)((float)this.field_145849_e + zPlus), 0.0, (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.01f + 0.01f), 0.0);
                }
            }
            ++this.ticksAlive;
        }
    }

    public boolean tryStoringItem(ItemStack stack) {
        TileEntityPedestal parent = (TileEntityPedestal)this.getParent();
        if (parent != null) {
            return parent.tryStoringItem(stack);
        }
        if (this.isParent()) {
            if (this.storedItem != null || stack == null) {
                return false;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.storedItem = stack.func_77946_l();
                this.storedItem.field_77994_a = 1;
                this.itemShouldBeUp = true;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"pedestalData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean startDroppingItem(EntityPlayer player) {
        TileEntityPedestal parent = (TileEntityPedestal)this.getParent();
        if (parent != null) {
            return parent.startDroppingItem(player);
        }
        if (this.isParent()) {
            if (this.storedItem == null) {
                return false;
            }
            if (!this.field_145850_b.field_72995_K) {
                this.itemShouldBeUp = false;
                if (player != null && this.getIntegrationTime() == 0) {
                    IvEntityHelper.addAsCurrentItem((EntityPlayer)player, (ItemStack)this.storedItem);
                    this.storedItem = null;
                }
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"pedestalData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public void dropItem() {
        TileEntityPedestal parent = (TileEntityPedestal)this.getParent();
        if (parent != null) {
            parent.dropItem();
        } else if (this.isParent() && this.storedItem != null && !this.field_145850_b.field_72995_K) {
            EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.storedItem);
            this.field_145850_b.func_72838_d((Entity)itemEntity);
            this.storedItem = null;
            IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"pedestalData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
            this.func_70296_d();
        }
    }

    public EnumPedestalEntry getPedestalEntry() {
        return EnumPedestalEntry.getEntry(this.pedestalIdentifier);
    }

    public int getIntegrationTime() {
        EnumPedestalEntry entry = this.getPedestalEntry();
        return entry != null ? entry.integrationTime : 0;
    }

    public float getFractionItemUp() {
        float fractionDone = (float)this.getIntegrationTime() > 0.0f ? (float)this.timeItemUp / (float)this.getIntegrationTime() : 1.0f;
        return fractionDone;
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        this.writePedestalDataToNBT(par1nbtTagCompound);
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.readPedestalDataFromNBT(par1nbtTagCompound);
    }

    public void writePedestalDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("pedestalIdentifier", this.pedestalIdentifier);
        tagCompound.func_74768_a("timeItemUp", this.timeItemUp);
        tagCompound.func_74757_a("itemShouldBeUp", this.itemShouldBeUp);
        if (this.storedItem != null) {
            NBTTagCompound var4 = new NBTTagCompound();
            this.storedItem.func_77955_b(var4);
            tagCompound.func_74782_a("storedItem", (NBTBase)var4);
        }
    }

    public void readPedestalDataFromNBT(NBTTagCompound tagCompound) {
        this.pedestalIdentifier = tagCompound.func_74762_e("pedestalIdentifier");
        this.timeItemUp = tagCompound.func_74762_e("timeItemUp");
        this.itemShouldBeUp = tagCompound.func_74767_n("itemShouldBeUp");
        if (tagCompound.func_74764_b("storedItem")) {
            NBTTagCompound var4 = tagCompound.func_74775_l("storedItem");
            this.storedItem = ItemStack.func_77949_a((NBTTagCompound)var4);
        } else {
            this.storedItem = null;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        float[] extent = this.getPedestalEntry().visualExtent;
        if (extent != null) {
            double[] center = this.getActiveCenterCoords();
            return AxisAlignedBB.func_72330_a((double)(center[0] - (double)extent[0]), (double)(center[1] - (double)extent[1]), (double)(center[2] - (double)extent[2]), (double)(center[0] + (double)extent[0]), (double)(center[1] + (double)extent[1]), (double)(center[2] + (double)extent[2]));
        }
        return super.getRenderBoundingBox();
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("pedestalData".equals(context)) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writePedestalDataToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("pedestalData".equals(context)) {
            this.readPedestalDataFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }
}

