/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityMultiBlock;
import ivorius.ivtoolkit.entities.IvEntityHelper;
import ivorius.ivtoolkit.network.ClientEventHandler;
import ivorius.ivtoolkit.network.IvNetworkHelperClient;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.tools.IvSideClient;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.achievements.YGCAchievementList;
import ivorius.yegamolchattels.blocks.PlanksRefinementRegistry;
import ivorius.yegamolchattels.items.YGCItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public class TileEntityPlanksRefinement
extends IvTileEntityMultiBlock
implements PartialUpdateHandler,
ClientEventHandler {
    public static final int REFINEMENT_SLOTS_X = 16;
    public static final int REFINEMENT_SLOTS_Y = 7;
    public static int MIN_LOW_REFINEMENT_PER_SLOT = 3;
    public static int MIN_HIGH_REFINEMENT_PER_SLOT = 6;
    public static int MAX_REFINEMENT_PER_SLOT = 10;
    public static int MISSING_REFINEMENT_ALLOWED = 30;
    public ItemStack containedItem;
    public int[] ticksRefinedPerSlot = new int[112];

    public boolean tryStoringItem(ItemStack stack, Entity entity) {
        Item item;
        if (stack != null && this.containedItem == null && ((item = stack.func_77973_b()) == YGCItems.plank || item == YGCItems.smoothPlank || item == YGCItems.refinedPlank)) {
            if (!this.field_145850_b.field_72995_K) {
                this.containedItem = stack.func_77946_l();
                this.containedItem.field_77994_a = 1;
                --stack.field_77994_a;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public boolean tryEquippingItemOnPlayer(EntityPlayer player) {
        if (this.containedItem != null) {
            if (!this.field_145850_b.field_72995_K && IvEntityHelper.addAsCurrentItem((EntityPlayer)player, (ItemStack)this.containedItem)) {
                if (this.containedItem.func_77973_b() == YGCItems.refinedPlank) {
                    player.func_71029_a((StatBase)YGCAchievementList.refinedPlank);
                }
                this.containedItem = null;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public boolean tryUsingItem(ItemStack usedTool, EntityPlayer player) {
        if (this.containedItem == null) {
            return false;
        }
        if (this.isCorrectTool(usedTool)) {
            if (!this.field_145850_b.field_72995_K) {
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"refinementGui", (SimpleNetworkWrapper)YeGamolChattels.network, (EntityPlayer)player, (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean isCorrectTool(ItemStack tool) {
        return this.getCurrentResult(tool) != null;
    }

    public void refineWithItem(EntityPlayer entityPlayer, int usedItem, float x, float y, float speed) {
        int speedInfl = MathHelper.func_76141_d((float)(speed *= 0.3f)) + (this.field_145850_b.field_73012_v.nextFloat() < speed % 1.0f ? 1 : 0);
        int startSlotX = MathHelper.func_76141_d((float)(x - 1.5f + 0.5f));
        int endSlotX = MathHelper.func_76141_d((float)(x + 1.5f + 0.5f));
        int startSlotY = MathHelper.func_76141_d((float)(y - 1.5f + 0.5f));
        int endSlotY = MathHelper.func_76141_d((float)(y + 1.5f + 0.5f));
        for (int slotX = startSlotX; slotX < endSlotX; ++slotX) {
            for (int slotY = startSlotY; slotY < endSlotY; ++slotY) {
                int index;
                if (slotX < 0 || slotX >= 16 || slotY < 0 || slotY >= 7) continue;
                int n = index = slotY * 16 + slotX;
                this.ticksRefinedPerSlot[n] = this.ticksRefinedPerSlot[n] + speedInfl;
                if (this.ticksRefinedPerSlot[index] <= MAX_REFINEMENT_PER_SLOT) continue;
                this.ticksRefinedPerSlot[index] = MAX_REFINEMENT_PER_SLOT;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            IvNetworkHelperClient.sendTileEntityUpdatePacket((TileEntity)this, (String)"plankRefinement", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[]{entityPlayer.field_71071_by.field_70461_c, speedInfl});
        }
        if (this.isRefinementComplete()) {
            this.completeRefinement(entityPlayer.field_71071_by.func_70301_a(usedItem));
        }
    }

    public boolean isRefinementComplete() {
        int ticksMissing = 0;
        for (int ticksRefined : this.ticksRefinedPerSlot) {
            if (ticksRefined < MIN_LOW_REFINEMENT_PER_SLOT) {
                return false;
            }
            if (ticksRefined >= MIN_HIGH_REFINEMENT_PER_SLOT || (ticksMissing += ticksRefined - MIN_HIGH_REFINEMENT_PER_SLOT) <= MISSING_REFINEMENT_ALLOWED) continue;
            return false;
        }
        return true;
    }

    public void completeRefinement(ItemStack tool) {
        for (int i = 0; i < this.ticksRefinedPerSlot.length; ++i) {
            this.ticksRefinedPerSlot[i] = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            PlanksRefinementRegistry.Entry entry = this.getCurrentResult(tool);
            if (entry != null) {
                this.containedItem = entry.getResult(this.containedItem, tool);
            } else {
                YeGamolChattels.logger.error("Unknown refinement result for '" + this.containedItem + "'");
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public PlanksRefinementRegistry.Entry getCurrentResult(ItemStack tool) {
        return PlanksRefinementRegistry.entry(this.containedItem, tool);
    }

    public float getRefinement(int slotX, int slotY) {
        if (slotX >= 0 && slotX < 16 && slotY >= 0 && slotY < 7) {
            return (float)this.ticksRefinedPerSlot[slotY * 16 + slotX] / (float)MIN_HIGH_REFINEMENT_PER_SLOT;
        }
        return -1.0f;
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.containedItem = ItemStack.func_77949_a((NBTTagCompound)par1nbtTagCompound.func_74775_l("containedItem"));
        this.ticksRefinedPerSlot = par1nbtTagCompound.func_74759_k("ticksRefinedPerSlot");
        if (this.ticksRefinedPerSlot == null || this.ticksRefinedPerSlot.length != 112) {
            this.ticksRefinedPerSlot = new int[256];
        }
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        if (this.containedItem != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.containedItem.func_77955_b(itemNBT);
            par1nbtTagCompound.func_74782_a("containedItem", (NBTBase)itemNBT);
        }
        par1nbtTagCompound.func_74783_a("ticksRefinedPerSlot", this.ticksRefinedPerSlot);
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("refinementGui".equals(context)) {
            for (int tickRefinedPerSlot : this.ticksRefinedPerSlot) {
                buffer.writeInt(tickRefinedPerSlot);
            }
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("refinementGui".equals(context)) {
            for (int i = 0; i < this.ticksRefinedPerSlot.length; ++i) {
                this.ticksRefinedPerSlot[i] = buffer.readInt();
            }
            IvSideClient.getClientPlayer().openGui((Object)YeGamolChattels.instance, 1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void assembleClientEvent(ByteBuf buffer, String context, Object ... params) {
        if ("plankRefinement".equals(context)) {
            buffer.writeInt(((Integer)params[0]).intValue());
            buffer.writeInt(((Integer)params[1]).intValue());
            for (int tickRefinedPerSlot : this.ticksRefinedPerSlot) {
                buffer.writeInt(tickRefinedPerSlot);
            }
        }
    }

    public void onClientEvent(ByteBuf buffer, String context, EntityPlayerMP player) {
        if ("plankRefinement".equals(context)) {
            int usedItem = buffer.readInt();
            ItemStack usedStack = player.field_71071_by.func_70301_a(usedItem);
            int speedInfl = buffer.readInt();
            if (this.isCorrectTool(usedStack)) {
                for (int i = 0; i < this.ticksRefinedPerSlot.length; ++i) {
                    this.ticksRefinedPerSlot[i] = buffer.readInt();
                }
                usedStack.func_77972_a(1 + speedInfl, (EntityLivingBase)player);
                if (usedStack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(usedItem, null);
                    PlanksRefinementRegistry.Entry entry = this.getCurrentResult(usedStack);
                    entry.onToolBreak(usedStack, (EntityPlayer)player);
                }
                if (this.isRefinementComplete()) {
                    this.completeRefinement(usedStack);
                }
            }
        }
    }
}

