/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.blocks;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import io.netty.buffer.ByteBuf;
import ivorius.ivtoolkit.blocks.IvTileEntityRotatable;
import ivorius.ivtoolkit.entities.IvEntityHelper;
import ivorius.ivtoolkit.network.IvNetworkHelperServer;
import ivorius.ivtoolkit.network.PartialUpdateHandler;
import ivorius.ivtoolkit.raytracing.IvRaytraceableObject;
import ivorius.ivtoolkit.raytracing.IvRaytracedIntersection;
import ivorius.ivtoolkit.raytracing.IvRaytracerMC;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.achievements.YGCAchievementList;
import ivorius.yegamolchattels.items.YGCItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityWeaponRack
extends IvTileEntityRotatable
implements PartialUpdateHandler {
    public static final int weaponRackTypeFloor = 0;
    public static final int weaponRackTypeWall = 1;
    public ItemStack[] storedWeapons = new ItemStack[4];
    public float[] storedWeaponsSwinging = new float[4];
    public boolean[] effectsApplied = new boolean[6];

    public void func_145845_h() {
        super.func_145845_h();
        for (int i = 0; i < this.storedWeaponsSwinging.length; ++i) {
            if (!(this.storedWeaponsSwinging[i] < 1.0f)) continue;
            int n = i;
            this.storedWeaponsSwinging[n] = this.storedWeaponsSwinging[n] + 0.1f;
        }
    }

    public int getStoredWeaponSlots() {
        int type = this.func_145832_p() & 1;
        return type == 0 ? 4 : 2;
    }

    public int getWeaponRackType() {
        return this.func_145832_p() & 1;
    }

    public boolean tryStoringItem(ItemStack stack, Entity entity) {
        if (stack != null) {
            boolean canPlace;
            Item item = stack.func_77973_b();
            boolean bl = canPlace = item instanceof ItemTool || item instanceof ItemSword || this.getWeaponRackType() == 0 && item instanceof ItemBow || item == YGCItems.mallet;
            if (canPlace) {
                int slot = this.getHoveredSlot(entity);
                return slot >= 0 && this.tryAddingWeapon(stack, slot);
            }
        }
        return false;
    }

    public boolean tryApplyingEffect(ItemStack stack, Entity entity) {
        int slot;
        if (stack != null && (slot = this.getEffectToBeApplied(stack, entity)) >= 0 && !this.effectsApplied[slot]) {
            if (!this.field_145850_b.field_72995_K) {
                this.effectsApplied[slot] = true;
                --stack.field_77994_a;
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_71029_a((StatBase)YGCAchievementList.weaponRackVariant);
                }
            }
            return true;
        }
        return false;
    }

    public int getEffectToBeApplied(ItemStack stack, Entity entity) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            if (itemBlock.field_150939_a == Blocks.field_150338_P || itemBlock.field_150939_a == Blocks.field_150337_Q) {
                return 0;
            }
            if (itemBlock.field_150939_a == Blocks.field_150321_G) {
                return 3;
            }
        }
        if (item == Items.field_151100_aR && stack.func_77960_j() == 15) {
            return 1;
        }
        if (item == Items.field_151116_aA) {
            return 2;
        }
        if (item == Items.field_151145_ak) {
            return 4;
        }
        if (item == Items.field_151118_aC) {
            return 5;
        }
        return -1;
    }

    public boolean tryAddingWeapon(ItemStack stack, int slot) {
        if (this.storedWeapons[slot] == null && slot < this.getStoredWeaponSlots()) {
            if (!this.field_145850_b.field_72995_K) {
                this.storedWeapons[slot] = stack.func_77946_l();
                this.storedWeapons[slot].field_77994_a = 1;
                --stack.field_77994_a;
                this.storedWeaponsSwinging[slot] = 0.0f;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"weaponRackData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean tryAddingWeapon(ItemStack stack) {
        for (int i = 0; i < this.getStoredWeaponSlots(); ++i) {
            if (!this.tryAddingWeapon(stack, i)) continue;
            return true;
        }
        return false;
    }

    public int getHoveredSlot(Entity entity) {
        String info;
        List<IvRaytraceableObject> raytraceables = this.getRaytraceableObjects();
        IvRaytracedIntersection intersection = IvRaytracerMC.getFirstIntersection(raytraceables, (Entity)entity);
        if (intersection != null && (info = (String)intersection.getUserInfo()).startsWith("Slot")) {
            Integer number = Integer.valueOf(info.substring(4));
            return number;
        }
        return -1;
    }

    public List<IvRaytraceableObject> getRaytraceableObjects() {
        ArrayList<IvRaytraceableObject> raytraceables = new ArrayList<IvRaytraceableObject>();
        if (this.getWeaponRackType() == 0) {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot0", -0.45, -0.3, -0.3, 0.225, 0.7, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot1", -0.225, -0.3, -0.3, 0.225, 0.7, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot2", 0.0, -0.3, -0.3, 0.225, 0.7, 0.6));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot3", 0.225, -0.3, -0.3, 0.225, 0.7, 0.6));
        } else {
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot0", -0.5, 0.0, 0.1, 1.0, 0.5, 0.4));
            raytraceables.add((IvRaytraceableObject)this.getRotatedBox("Slot1", -0.5, -0.5, 0.1, 1.0, 0.5, 0.4));
        }
        return raytraceables;
    }

    public boolean tryDroppingWeapon(int slot) {
        if (this.storedWeapons[slot] != null) {
            if (!this.field_145850_b.field_72995_K) {
                float var7 = 0.7f;
                double var8 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
                double var10 = (double)this.field_145850_b.field_73012_v.nextFloat() * 0.2 + 1.1;
                double var12 = (double)(this.field_145850_b.field_73012_v.nextFloat() * var7) + (double)(1.0f - var7) * 0.5;
                EntityItem var14 = new EntityItem(this.field_145850_b, (double)this.field_145851_c + var8, (double)this.field_145848_d + var10, (double)this.field_145849_e + var12, this.storedWeapons[slot]);
                var14.field_145804_b = 10;
                this.field_145850_b.func_72838_d((Entity)var14);
                this.storedWeapons[slot] = null;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"weaponRackData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean tryEquippingItemOnPlayer(int slot, EntityPlayer entityLiving) {
        if (this.storedWeapons[slot] != null) {
            if (!this.field_145850_b.field_72995_K && IvEntityHelper.addAsCurrentItem((EntityPlayer)entityLiving, (ItemStack)this.storedWeapons[slot])) {
                this.storedWeapons[slot] = null;
                IvNetworkHelperServer.sendTileEntityUpdatePacket((TileEntity)this, (String)"weaponRackData", (SimpleNetworkWrapper)YeGamolChattels.network, (Object[])new Object[0]);
                this.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public boolean interactWithPlayer(EntityPlayer entity) {
        int slot = this.getHoveredSlot((Entity)entity);
        return slot >= 0 && this.tryEquippingItemOnPlayer(slot, entity);
    }

    public void dropAllWeapons() {
        for (int i = 0; i < this.storedWeapons.length; ++i) {
            this.tryDroppingWeapon(i);
        }
    }

    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        super.func_145839_a(par1nbtTagCompound);
        this.readWeaponRackDataFromNBT(par1nbtTagCompound);
    }

    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        this.writeWeaponRackDataToNBT(par1nbtTagCompound);
    }

    public void readWeaponRackDataFromNBT(NBTTagCompound compound) {
        NBTTagList items = compound.func_150295_c("Items", 10);
        this.storedWeapons = new ItemStack[this.storedWeapons.length];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound var4 = items.func_150305_b(i);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.storedWeapons.length) continue;
            this.storedWeapons[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            this.storedWeaponsSwinging[var5] = var4.func_74760_g("Swinging");
        }
        NBTTagList effects = compound.func_150295_c("Effects", 10);
        for (int i = 0; i < effects.func_74745_c(); ++i) {
            NBTTagCompound var4 = effects.func_150305_b(i);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            this.effectsApplied[var5] = var4.func_74767_n("Applied");
        }
    }

    public void writeWeaponRackDataToNBT(NBTTagCompound compound) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.storedWeapons.length; ++i) {
            if (this.storedWeapons[i] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            var4.func_74776_a("Swinging", (float)((byte)this.storedWeaponsSwinging[i]));
            this.storedWeapons[i].func_77955_b(var4);
            items.func_74742_a((NBTBase)var4);
        }
        compound.func_74782_a("Items", (NBTBase)items);
        NBTTagList effects = new NBTTagList();
        for (int i = 0; i < this.effectsApplied.length; ++i) {
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            var4.func_74757_a("Applied", this.effectsApplied[i]);
            effects.func_74742_a((NBTBase)var4);
        }
        compound.func_74782_a("Effects", (NBTBase)effects);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)this.field_145848_d - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 1.5));
    }

    public void writeUpdateData(ByteBuf buffer, String context, Object ... params) {
        if ("weaponRackData".equals(context)) {
            NBTTagCompound compound = new NBTTagCompound();
            this.writeWeaponRackDataToNBT(compound);
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)compound);
        }
    }

    public void readUpdateData(ByteBuf buffer, String context) {
        if ("weaponRackData".equals(context)) {
            this.readWeaponRackDataFromNBT(ByteBufUtils.readTag((ByteBuf)buffer));
        }
    }
}

