/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.client.rendering;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.YGCEntityRendererAccessor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.io.FileUtils;
import org.lwjgl.opengl.GL11;

public class EntityBlockTextureMerger {
    private static int[] cachedBlockTextureMap;

    public static BufferedImage getTexture(Block block, int metadata) {
        IIcon icon = block.func_149691_a(ForgeDirection.NORTH.ordinal(), metadata);
        if (icon instanceof TextureAtlasSprite) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)icon;
            if (sprite.func_110970_k() > 0) {
                int[][] textureData = sprite.func_147965_a(0);
                int[] textureRGB = textureData[0];
                BufferedImage image = new BufferedImage(sprite.func_94211_a(), sprite.func_94216_b(), 2);
                image.setRGB(0, 0, sprite.func_94211_a(), sprite.func_94216_b(), textureRGB, 0, 1);
                return image;
            }
            return EntityBlockTextureMerger.getStitchedTextureSubImage(icon);
        }
        return null;
    }

    public static BufferedImage getStitchedTextureSubImage(IIcon icon) {
        int textureWidth = MathHelper.func_76141_d((float)(1.0f / (icon.func_94212_f() - icon.func_94209_e()) + 0.5f)) * icon.func_94211_a();
        int textureHeight = MathHelper.func_76141_d((float)(1.0f / (icon.func_94210_h() - icon.func_94206_g()) + 0.5f)) * icon.func_94216_b();
        int minX = MathHelper.func_76141_d((float)(icon.func_94209_e() * (float)textureWidth + 0.5f));
        int minY = MathHelper.func_76141_d((float)(icon.func_94206_g() * (float)textureHeight + 0.5f));
        int[] subImage = EntityBlockTextureMerger.getStitchedTextureSubImage(minX, minY, icon.func_94211_a(), icon.func_94216_b(), textureWidth, textureHeight);
        BufferedImage image = new BufferedImage(icon.func_94211_a(), icon.func_94216_b(), 2);
        image.setRGB(0, 0, icon.func_94211_a(), icon.func_94216_b(), subImage, 0, icon.func_94211_a());
        return image;
    }

    public static int[] getStitchedTextureSubImage(int x, int y, int width, int height, int textureWidth, int textureHeight) {
        int[] stitched = EntityBlockTextureMerger.getStitchedTexture(textureWidth, textureHeight);
        int[] returnTex = new int[width * height];
        for (int curY = 0; curY < height; ++curY) {
            for (int curX = 0; curX < width; ++curX) {
                returnTex[curX + curY * width] = stitched[x + curX + (y + curY) * textureWidth];
            }
        }
        return returnTex;
    }

    public static int[] getStitchedTexture(int textureWidth, int textureHeight) {
        if (cachedBlockTextureMap == null) {
            TextureMap blocksTexture = (TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b);
            int blocksTextureID = blocksTexture.func_110552_b();
            cachedBlockTextureMap = EntityBlockTextureMerger.getStitchedTexture(textureWidth, textureHeight, blocksTextureID);
        }
        return cachedBlockTextureMap;
    }

    public static int[] getStitchedTexture(int textureWidth, int textureHeight, int textureID) {
        byte[] pixels = new byte[textureWidth * textureHeight * 4];
        ByteBuffer buffer = ByteBuffer.allocateDirect(pixels.length).order(ByteOrder.nativeOrder());
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        buffer.get(pixels);
        int[] texture = new int[pixels.length / 4];
        for (int i = 0; i < texture.length; ++i) {
            texture[i] = (pixels[i * 4 + 3] & 0xFF) << 24 | (pixels[i * 4] & 0xFF) << 16 | (pixels[i * 4 + 1] & 0xFF) << 8 | pixels[i * 4 + 2] & 0xFF;
        }
        return texture;
    }

    public static void clearCachedStitchedTexture() {
        cachedBlockTextureMap = null;
    }

    public static void saveCachedTexture(BufferedImage bufferedImage, String name) {
        try {
            String filename = "Rendered_" + Math.random();
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(Minecraft.func_71410_x().field_71412_D, filename + ".png"));
            FileUtils.writeStringToFile((File)new File(Minecraft.func_71410_x().field_71412_D, filename + ".txt"), (String)name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ResourceLocation getTexture(Entity entity) {
        Render renderObject = RenderManager.field_78727_a.func_78713_a(entity);
        return renderObject != null ? YGCEntityRendererAccessor.getResourceLocation(renderObject, entity) : new ResourceLocation("yegamolchattels", "textures/blocks/carpet.png");
    }
}

