/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.client.rendering;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.yegamolchattels.blocks.BlockMicroBlock;
import ivorius.yegamolchattels.blocks.TileEntityMicroBlock;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderMicroBlock
implements ISimpleBlockRenderingHandler {
    private int renderID;

    public RenderMicroBlock(int renderID) {
        this.renderID = renderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntityMicroBlock tileEntityMicroBlock = (TileEntityMicroBlock)world.func_147438_o(x, y, z);
        IvBlockCollection blockCollection = tileEntityMicroBlock.getBlockCollection();
        int brightness = block.func_149677_c(renderer.field_147845_a, x, y, z);
        RenderMicroBlock.renderMicroblocks(world, new BlockCoord(x, y, z), blockCollection, (BlockMicroBlock)block, renderer, brightness);
        return true;
    }

    public static void renderMicroblocks(IBlockAccess world, BlockCoord pos, IvBlockCollection blockCollection, BlockMicroBlock origBlock, RenderBlocks renderer, int innerBrightness) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int x = pos.x;
        int y = pos.y;
        int z = pos.z;
        float oneX = 1.0f / (float)blockCollection.width;
        float oneY = 1.0f / (float)blockCollection.height;
        float oneZ = 1.0f / (float)blockCollection.length;
        tessellator.func_78380_c(innerBrightness);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        renderer.field_152631_f = true;
        for (BlockCoord coord : blockCollection) {
            Block block = blockCollection.getBlock(coord);
            if (block.func_149688_o() == Material.field_151579_a) continue;
            byte meta = blockCollection.getMetadata(coord);
            origBlock.func_149676_a((float)coord.x * oneX, (float)coord.y * oneY, (float)coord.z * oneZ, (float)(coord.x + 1) * oneX, (float)(coord.y + 1) * oneY, (float)(coord.z + 1) * oneZ);
            renderer.func_147775_a((Block)origBlock);
            origBlock.renderSideCache[ForgeDirection.NORTH.ordinal()] = blockCollection.shouldRenderSide(coord, ForgeDirection.NORTH);
            origBlock.renderSideCache[ForgeDirection.SOUTH.ordinal()] = blockCollection.shouldRenderSide(coord, ForgeDirection.SOUTH);
            origBlock.renderSideCache[ForgeDirection.EAST.ordinal()] = blockCollection.shouldRenderSide(coord, ForgeDirection.EAST);
            origBlock.renderSideCache[ForgeDirection.WEST.ordinal()] = blockCollection.shouldRenderSide(coord, ForgeDirection.WEST);
            origBlock.renderSideCache[ForgeDirection.UP.ordinal()] = blockCollection.shouldRenderSide(coord, ForgeDirection.UP);
            origBlock.renderSideCache[ForgeDirection.DOWN.ordinal()] = blockCollection.shouldRenderSide(coord, ForgeDirection.DOWN);
            origBlock.renderBlockCache = block;
            origBlock.renderBlockMetaCache = meta;
            renderer.func_147784_q((Block)origBlock, x, y, z);
        }
        renderer.field_152631_f = false;
        origBlock.func_149719_a(world, x, y, z);
        origBlock.renderBlockCache = null;
        origBlock.renderBlockMetaCache = 0;
        Arrays.fill(origBlock.renderSideCache, false);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return this.renderID;
    }
}

