/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.client.rendering;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.MCRegistryDefault;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.TileEntitySnowGlobe;
import ivorius.yegamolchattels.client.rendering.ModelRealityGlobe;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererSnowGlobe
extends TileEntitySpecialRenderer {
    public ModelBase modelRealityGlobe = new ModelRealityGlobe();
    public ResourceLocation realityGlobeTexture = new ResourceLocation("yegamolchattels", YeGamolChattels.filePathTextures + "realityGlobeGlass.png");
    public ResourceLocation realityGlobeTextureClear = new ResourceLocation("yegamolchattels", YeGamolChattels.filePathTextures + "realityGlobeClear.png");
    private RenderBlocks blockRenderer;
    public static IvBlockCollection defaultGlobe;
    public static final int SIZE_X = 10;
    public static final int SIZE_Y = 9;
    public static final int SIZE_Z = 10;

    public TileEntityRendererSnowGlobe() {
        defaultGlobe = TileEntityRendererSnowGlobe.blockCollectionFromResourceLocation(new ResourceLocation("yegamolchattels", YeGamolChattels.filePathOther + "defaultGlobe.nbt"), (MCRegistry)MCRegistryDefault.INSTANCE);
    }

    public static IvBlockCollection blockCollectionFromResourceLocation(ResourceLocation resourceLocation, MCRegistry registry) {
        IResource globeResource = null;
        try {
            globeResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (globeResource != null) {
            NBTTagCompound compound = null;
            try {
                compound = CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(globeResource.func_110527_b()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (compound != null) {
                return new IvBlockCollection(compound, registry);
            }
        }
        return null;
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTicks) {
        int i;
        float rumble;
        int pass = MinecraftForgeClient.getRenderPass();
        TileEntitySnowGlobe realityGlobe = (TileEntitySnowGlobe)tileEntity;
        double playerDistSQ = x * x + y * y + z * z;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        float rumbling = realityGlobe.getRumbling();
        float f = rumble = rumbling > 0.0f ? -tileEntity.func_145831_w().field_73012_v.nextFloat() * rumbling : 0.0f;
        if (playerDistSQ < 16.0 && pass == 0) {
            if (realityGlobe.getGlCallListIndex() < 0) {
                TileEntityRendererSnowGlobe.constructCallList(realityGlobe, this.blockRenderer);
            } else if (realityGlobe.needsVisualUpdate) {
                TileEntityRendererSnowGlobe.updateCallList(realityGlobe, this.blockRenderer);
                realityGlobe.needsVisualUpdate = false;
            }
            double sizePX = 0.047619047619047616;
            double sizePY = 0.047619047619047616;
            double sizePZ = 0.047619047619047616;
            if (realityGlobe.getGlCallListIndex() >= 0) {
                GL11.glPushMatrix();
                this.setupWorldTransform(rumble);
                Tessellator var10 = Tessellator.field_78398_a;
                this.func_147499_a(TextureMap.field_110575_b);
                RenderHelper.func_74518_a();
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)3042);
                GL11.glDisable((int)2884);
                if (Minecraft.func_71379_u()) {
                    GL11.glShadeModel((int)7425);
                } else {
                    GL11.glShadeModel((int)7424);
                }
                if (realityGlobe.getGlCallListIndex() >= 0) {
                    GL11.glCallList((int)realityGlobe.getGlCallListIndex());
                    if (!realityGlobe.displaysDefaultHouse()) {
                        this.setupWorldTransform(rumble);
                        GL11.glCallList((int)realityGlobe.getGlCallListIndex());
                    }
                }
                RenderHelper.func_74519_b();
                GL11.glPopMatrix();
            }
            if (!realityGlobe.displaysDefaultHouse() && playerDistSQ < 16.0) {
                AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)((double)tileEntity.field_145851_c - 10.0), (double)((double)tileEntity.field_145848_d - 9.0), (double)((double)tileEntity.field_145849_e - 10.0), (double)((double)tileEntity.field_145851_c + 1.0 + 10.0), (double)((double)tileEntity.field_145848_d + 1.0 + 9.0), (double)((double)tileEntity.field_145849_e + 1.0 + 10.0));
                List entities = tileEntity.func_145831_w().func_72839_b(null, bb);
                if (entities.size() > 0) {
                    GL11.glPushMatrix();
                    this.setupWorldTransform(rumble);
                    GL11.glTranslated((double)((double)(-tileEntity.field_145851_c) - 0.5), (double)((double)(-tileEntity.field_145848_d) - 0.5), (double)((double)(-tileEntity.field_145849_e) - 0.5));
                    for (Object obj : entities) {
                        Entity entity = (Entity)obj;
                        AxisAlignedBB entityBB = entity.field_70121_D;
                        if (!(entityBB.field_72340_a > bb.field_72340_a) || !(entityBB.field_72336_d < bb.field_72336_d) || !(entityBB.field_72338_b > bb.field_72338_b) || !(entityBB.field_72337_e < bb.field_72337_e) || !(entityBB.field_72339_c > bb.field_72339_c) || !(entityBB.field_72334_f < bb.field_72334_f)) continue;
                        double rX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
                        double rY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
                        double rZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
                        float rYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
                        RenderManager.field_78727_a.func_147940_a(entity, rX, rY, rZ, rYaw, partialTicks);
                    }
                    GL11.glPopMatrix();
                }
            }
        }
        float globeAlpha = Math.max(Math.max(MathHelper.func_76129_c((float)((float)playerDistSQ)) - 3.0f, 0.0f) + 0.2f, realityGlobe.getObfuscationAlpha());
        int n = i = playerDistSQ < 16.0 && !realityGlobe.displaysDefaultHouse() ? 1 : 0;
        while (i >= 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPushMatrix();
            for (int n2 = 0; n2 < i; ++n2) {
                this.setupWorldTransform(rumble);
            }
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
            this.func_147499_a(this.realityGlobeTextureClear);
            if (pass == 0) {
                this.modelRealityGlobe.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glPushMatrix();
            this.func_147499_a(this.realityGlobeTexture);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)globeAlpha);
            if (pass == 1) {
                this.modelRealityGlobe.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            --i;
        }
        GL11.glPopMatrix();
    }

    public void func_147496_a(World par1World) {
        this.blockRenderer = new RenderBlocks((IBlockAccess)par1World);
    }

    public void setupWorldTransform(float rumble) {
        double sizePX = 0.047619047619047616;
        double sizePY = 0.047619047619047616;
        double sizePZ = 0.047619047619047616;
        GL11.glTranslated((double)0.0, (double)(0.175 + (double)rumble), (double)0.0);
        GL11.glScaled((double)0.85, (double)0.85, (double)0.85);
        GL11.glScaled((double)sizePX, (double)sizePY, (double)sizePZ);
    }

    public static void updateCallList(TileEntitySnowGlobe tileEntity, RenderBlocks blockRenderer) {
        TileEntityRendererSnowGlobe.drawInCallList(tileEntity, blockRenderer);
    }

    public static void constructCallList(TileEntitySnowGlobe tileEntity, RenderBlocks blockRenderer) {
        tileEntity.setGlCallListIndex(GLAllocation.func_74526_a((int)1));
        TileEntityRendererSnowGlobe.drawInCallList(tileEntity, blockRenderer);
    }

    public static void drawInCallList(TileEntitySnowGlobe tileEntity, RenderBlocks blockRenderer) {
        Tessellator var10 = Tessellator.field_78398_a;
        GL11.glNewList((int)tileEntity.getGlCallListIndex(), (int)4864);
        var10.func_78382_b();
        if (!tileEntity.displaysDefaultHouse()) {
            var10.func_78373_b((double)(-((float)tileEntity.field_145851_c)) - 0.5, (double)(-((float)tileEntity.field_145848_d)) - 0.5, (double)(-((float)tileEntity.field_145849_e)) - 0.5);
            var10.func_78386_a(1.0f, 1.0f, 1.0f);
            for (int i = 0; i < 2; ++i) {
                for (int x = -10; x <= 10; ++x) {
                    for (int y = -9; y <= 9; ++y) {
                        for (int z = -10; z <= 10; ++z) {
                            int blockX = x + tileEntity.field_145851_c;
                            int blockY = y + tileEntity.field_145848_d;
                            int blockZ = z + tileEntity.field_145849_e;
                            Block block = tileEntity.func_145831_w().func_147439_a(blockX, blockY, blockZ);
                            if (block == null || block.func_149701_w() != i) continue;
                            if (x == -10 || x == 10 || y == -9 || y == 9 || z == -10 || z == 10) {
                                blockRenderer.func_147769_a(block, blockX, blockY, blockZ);
                                continue;
                            }
                            blockRenderer.func_147805_b(block, blockX, blockY, blockZ);
                        }
                    }
                }
            }
            var10.func_78373_b(0.0, 0.0, 0.0);
        } else if (defaultGlobe != null) {
            BlockCoord lowerCoord = new BlockCoord(-10, -9, -10);
            BlockArea area = new BlockArea(lowerCoord, new BlockCoord(10, 9, 10));
            var10.func_78373_b((double)(-((float)tileEntity.field_145851_c)) - 0.5, (double)(-((float)tileEntity.field_145848_d)) - 0.5, (double)(-((float)tileEntity.field_145849_e)) - 0.5);
            var10.func_78386_a(1.0f, 1.0f, 1.0f);
            blockRenderer.field_147874_am = 255;
            blockRenderer.field_147876_an = 255;
            blockRenderer.field_147864_al = 255;
            blockRenderer.field_147870_ao = 255;
            for (int i = 0; i < 2; ++i) {
                for (BlockCoord internalCoord : area) {
                    BlockCoord worldCoord = internalCoord.add(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                    BlockCoord collectionCoord = internalCoord.subtract(lowerCoord);
                    Block block = defaultGlobe.getBlock(collectionCoord);
                    byte meta = defaultGlobe.getMetadata(collectionCoord);
                    int blColor = block != Blocks.field_150349_c ? block.func_149741_i((int)meta) : 0xFFFFFF;
                    float red = (float)(blColor >> 16 & 0xFF) / 255.0f;
                    float green = (float)(blColor >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(blColor & 0xFF) / 255.0f;
                    if (block != null && block.func_149701_w() == i && block.func_149645_b() >= 0) {
                        block.func_149683_g();
                        blockRenderer.func_147775_a(block);
                        var10.func_78386_a(red, green, blue);
                        if (defaultGlobe.shouldRenderSide(collectionCoord, ForgeDirection.DOWN)) {
                            blockRenderer.func_147768_a(block, (double)worldCoord.x, (double)worldCoord.y, (double)worldCoord.z, blockRenderer.func_147787_a(block, 0, (int)meta));
                        }
                        if (defaultGlobe.shouldRenderSide(collectionCoord, ForgeDirection.UP)) {
                            blockRenderer.func_147806_b(block, (double)worldCoord.x, (double)worldCoord.y, (double)worldCoord.z, blockRenderer.func_147787_a(block, 1, (int)meta));
                        }
                        if (defaultGlobe.shouldRenderSide(collectionCoord, ForgeDirection.NORTH)) {
                            blockRenderer.func_147761_c(block, (double)worldCoord.x, (double)worldCoord.y, (double)worldCoord.z, blockRenderer.func_147787_a(block, 2, (int)meta));
                        }
                        if (defaultGlobe.shouldRenderSide(collectionCoord, ForgeDirection.SOUTH)) {
                            blockRenderer.func_147734_d(block, (double)worldCoord.x, (double)worldCoord.y, (double)worldCoord.z, blockRenderer.func_147787_a(block, 3, (int)meta));
                        }
                        if (defaultGlobe.shouldRenderSide(collectionCoord, ForgeDirection.WEST)) {
                            blockRenderer.func_147798_e(block, (double)worldCoord.x, (double)worldCoord.y, (double)worldCoord.z, blockRenderer.func_147787_a(block, 4, (int)meta));
                        }
                        if (defaultGlobe.shouldRenderSide(collectionCoord, ForgeDirection.EAST)) {
                            blockRenderer.func_147764_f(block, (double)worldCoord.x, (double)worldCoord.y, (double)worldCoord.z, blockRenderer.func_147787_a(block, 5, (int)meta));
                        }
                    }
                    blockRenderer.field_147863_w = false;
                }
            }
            var10.func_78373_b(0.0, 0.0, 0.0);
        }
        var10.func_78381_a();
        GL11.glEndList();
    }

    public static void captureAndWriteToFile(String fileName, BlockCoord coord, World world) {
        BlockCoord lowerCoord = new BlockCoord(-10, -9, -10);
        BlockArea area = new BlockArea(lowerCoord, new BlockCoord(10, 9, 10));
        IvBlockCollection blockCollection = new IvBlockCollection(21, 19, 21);
        for (BlockCoord internalCoord : area) {
            BlockCoord worldCoord = internalCoord.add(coord);
            BlockCoord collectionCoord = internalCoord.subtract(lowerCoord);
            Block block = internalCoord.x != 0 || internalCoord.y != 0 || internalCoord.z != 0 ? worldCoord.getBlock(world) : Blocks.field_150350_a;
            blockCollection.setBlockAndMetadata(collectionCoord, block, (byte)worldCoord.getMetadata(world));
        }
        NBTTagCompound compound = blockCollection.createTagCompound();
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)compound, (File)new File(Minecraft.func_71410_x().field_71412_D, fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

