/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.entities;

import ivorius.yegamolchattels.items.YGCItems;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFlag
extends Entity {
    public float wind = 0.0f;
    public float simWind = 0.0f;

    public EntityFlag(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
    }

    public void updateBounds() {
        float f1 = this.getFlagHeight();
        this.field_70121_D.func_72324_b(this.field_70165_t + 0.4, this.field_70163_u, this.field_70161_v + 0.4, this.field_70165_t + 0.6, this.field_70163_u + (double)(f1 / 16.0f), this.field_70161_v + 0.6);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((this.field_70173_aa + 90) % 100 == 0) {
            if (!this.field_70170_p.field_72995_K) {
                if (!this.canStayAtPosition()) {
                    this.func_70106_y();
                    this.dropFlag();
                }
            } else {
                this.updateBounds();
            }
        }
        this.wind = EntityFlag.updateWind(this.wind, this.field_70170_p);
        this.simWind = EntityFlag.updateSimWind(this.wind, this.simWind);
    }

    public static float updateSimWind(float wind, float simWind) {
        return simWind + (wind - simWind) * 0.02f;
    }

    public static float getInterpolatedWind(float wind, float simWind, float t) {
        return simWind + (wind - simWind) * 0.02f * t;
    }

    public static float updateWind(float wind, World worldObj) {
        float globalWind = EntityFlag.getGlobalWind(worldObj.func_72820_D());
        if ((wind += (worldObj.field_73012_v.nextFloat() * globalWind - worldObj.field_73012_v.nextFloat() * (1.0f - globalWind)) * 0.2f) < 0.0f) {
            wind = 0.0f;
        }
        if (wind > 1.0f) {
            wind = 1.0f;
        }
        return wind;
    }

    public static float getGlobalWind(long time) {
        return (MathHelper.func_76126_a((float)((float)time * 0.001f)) + 1.0f) * 0.5f;
    }

    public boolean canStayAtPosition() {
        Block block = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u - 1, (int)this.field_70161_v);
        AxisAlignedBB bb = this.field_70121_D.func_72329_c();
        if (block == Blocks.field_150422_aJ || block == Blocks.field_150386_bk || block == Blocks.field_150463_bK) {
            bb.field_72338_b += 0.5;
        }
        if (this.field_70170_p.func_72945_a((Entity)this, bb).size() > 0) {
            return false;
        }
        Material material = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u - 1, (int)this.field_70161_v).func_149688_o();
        if (!material.func_76220_a() && block != Blocks.field_150422_aJ && block != Blocks.field_150386_bk && block != Blocks.field_150463_bK) {
            return false;
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        for (Object anObject : list) {
            if (!(anObject instanceof EntityFlag)) continue;
            return false;
        }
        return true;
    }

    public void func_145781_i(int p_145781_1_) {
        this.field_70170_p.func_147450_X();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.dropFlag();
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("TileX", (int)this.field_70165_t);
        nbttagcompound.func_74768_a("TileY", (int)this.field_70163_u);
        nbttagcompound.func_74768_a("TileZ", (int)this.field_70161_v);
        nbttagcompound.func_74768_a("FlagSize", this.getSize());
        nbttagcompound.func_74768_a("FlagColor", this.getColor());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.field_70165_t = nbttagcompound.func_74762_e("TileX");
        this.field_70163_u = nbttagcompound.func_74762_e("TileY");
        this.field_70161_v = nbttagcompound.func_74762_e("TileZ");
        this.setSize(nbttagcompound.func_74762_e("FlagSize"));
        this.setColor(nbttagcompound.func_74762_e("FlagColor"));
        this.updateBounds();
    }

    public void func_70091_d(double d, double d1, double d2) {
        if (!this.field_70170_p.field_72995_K && d * d + d1 * d1 + d2 * d2 > 0.0) {
            this.func_70106_y();
            this.dropFlag();
        }
    }

    public void func_70024_g(double d, double d1, double d2) {
        if (!this.field_70170_p.field_72995_K && d * d + d1 * d1 + d2 * d2 > 0.0) {
            this.func_70106_y();
            this.dropFlag();
        }
    }

    public int getFlagHeight() {
        if (this.getSize() == 0) {
            return 32;
        }
        if (this.getSize() == 2) {
            return 128;
        }
        return 96;
    }

    public void dropFlag() {
        if (this.getSize() == 0) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(YGCItems.flagSmall, 1, this.getColor())));
        } else if (this.getSize() == 2) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(YGCItems.flagLarge, 1, this.getColor())));
        } else {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(YGCItems.flagSmall, 1, this.getColor())));
        }
    }

    public int getSize() {
        return this.field_70180_af.func_75679_c(25);
    }

    public void setSize(int size) {
        this.field_70180_af.func_75692_b(25, (Object)size);
        this.updateBounds();
    }

    public int getColor() {
        return this.field_70180_af.func_75679_c(26);
    }

    public void setColor(int color) {
        this.field_70180_af.func_75692_b(26, (Object)color);
    }
}

