/*
 * Decompiled with CFR 0.152.
 */
package ivorius.yegamolchattels.items;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.tools.IvInventoryHelper;
import ivorius.yegamolchattels.YeGamolChattels;
import ivorius.yegamolchattels.blocks.StatueHelper;
import ivorius.yegamolchattels.blocks.TileEntityMicroBlock;
import ivorius.yegamolchattels.blocks.YGCBlocks;
import ivorius.yegamolchattels.items.ItemBlockFragment;
import ivorius.yegamolchattels.items.ItemClubHammer;
import ivorius.yegamolchattels.items.MicroblockSelector;
import ivorius.yegamolchattels.items.YGCItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemChisel
extends ItemTool
implements MicroblockSelector {
    private int carvingDistance;
    private float fragmentPickupChance;
    public boolean canCarveStatues;

    public ItemChisel(int carvingDistance, float fragmentPickupChance, float damage, Item.ToolMaterial material, Set damageVSBlocks, boolean canCarveStatues) {
        super(damage, material, damageVSBlocks);
        this.carvingDistance = carvingDistance;
        this.fragmentPickupChance = fragmentPickupChance;
        this.canCarveStatues = canCarveStatues;
    }

    public int getCarvingDistance() {
        return this.carvingDistance;
    }

    public float getFragmentPickupChance() {
        return this.fragmentPickupChance;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.field_71071_by.func_146028_b((Item)YGCItems.clubHammer)) {
            if (this.showMicroblockSelection((EntityLivingBase)player, itemStack)) {
                int clubHammerSlot = IvInventoryHelper.getInventorySlotContainItem((InventoryPlayer)player.field_71071_by, (Item)YGCItems.clubHammer);
                return ItemChisel.chiselAway(x, y, z, player, itemStack, player.field_71071_by.func_70301_a(clubHammerSlot), this.carvingDistance, this.fragmentPickupChance);
            }
            if (StatueHelper.isValidStatueBlock(world, x, y, z)) {
                if (!world.field_72995_K) {
                    player.openGui((Object)YeGamolChattels.instance, 2, world, x, y, z);
                }
                return true;
            }
        } else if (!world.field_72995_K) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("item.ygcChisel.noHammer", new Object[0]));
        }
        return false;
    }

    public static boolean chiselAway(int x, int y, int z, EntityPlayer player, ItemStack usedStack, ItemStack clubHammer, int range, float fragmentPickupChance) {
        List<BlockData> hitFragmentDatas = ItemChisel.chiselAway((Entity)player, x, y, z, range);
        if (hitFragmentDatas != null && hitFragmentDatas.size() > 0) {
            for (BlockData data : hitFragmentDatas) {
                if (!(field_77697_d.nextFloat() < fragmentPickupChance)) continue;
                usedStack.func_77972_a(1, (EntityLivingBase)player);
                clubHammer.func_77972_a(1, (EntityLivingBase)player);
                ItemStack fragment = new ItemStack(YGCItems.blockFragment);
                ItemBlockFragment.setFragment(fragment, data);
                player.field_71071_by.func_70441_a(fragment);
                player.field_71071_by.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public static List<BlockData> chiselAway(Entity entity, int hoverX, int hoverY, int hoverZ, int range) {
        World world = entity.field_70170_p;
        MicroBlockFragment hoveredFragment = ItemChisel.getHoveredFragment(entity, hoverX, hoverY, hoverZ);
        if (hoveredFragment != null) {
            TileEntity tileEntity = world.func_147438_o(((MicroBlockFragment)hoveredFragment).coord.x, ((MicroBlockFragment)hoveredFragment).coord.y, ((MicroBlockFragment)hoveredFragment).coord.z);
            if (!(tileEntity instanceof TileEntityMicroBlock)) {
                ItemChisel.convertToMicroBlock(world, hoveredFragment.coord);
                tileEntity = world.func_147438_o(((MicroBlockFragment)hoveredFragment).coord.x, ((MicroBlockFragment)hoveredFragment).coord.y, ((MicroBlockFragment)hoveredFragment).coord.z);
            }
            if (tileEntity instanceof TileEntityMicroBlock) {
                TileEntityMicroBlock tileEntityMicroBlock = (TileEntityMicroBlock)tileEntity;
                IvBlockCollection collection = tileEntityMicroBlock.getBlockCollection();
                ArrayList<BlockData> returnList = new ArrayList<BlockData>();
                for (BlockCoord carveCoord : new BlockArea(hoveredFragment.getInternalCoord().subtract(range, range, range), hoveredFragment.getInternalCoord().add(range, range, range))) {
                    Block hitInternalBlock = collection.getBlock(carveCoord);
                    if (hitInternalBlock.func_149688_o() == Material.field_151579_a) continue;
                    byte hitInternalMeta = collection.getMetadata(carveCoord);
                    collection.setBlockAndMetadata(carveCoord, Blocks.field_150350_a, (byte)0);
                    returnList.add(new BlockData(hitInternalBlock, hitInternalMeta));
                }
                if (tileEntityMicroBlock.validateBeingMicroblock()) {
                    tileEntityMicroBlock.markCacheInvalid();
                }
                return returnList;
            }
        }
        return null;
    }

    public static void convertToMicroBlock(World world, BlockCoord coord) {
        Block block = coord.getBlock(world);
        if (ItemClubHammer.isMicroblockable(world, coord.x, coord.y, coord.z) || block.func_149688_o() == Material.field_151579_a) {
            byte metadata = (byte)coord.getMetadata(world);
            world.func_147449_b(coord.x, coord.y, coord.z, YGCBlocks.microBlock);
            TileEntity tileEntity = world.func_147438_o(coord.x, coord.y, coord.z);
            TileEntityMicroBlock tileEntityMicroBlock = (TileEntityMicroBlock)tileEntity;
            IvBlockCollection blockCollection = tileEntityMicroBlock.getBlockCollection();
            if (block != Blocks.field_150350_a) {
                for (BlockCoord internalCoord : blockCollection) {
                    blockCollection.setBlockAndMetadata(internalCoord, block, metadata);
                }
            }
        }
    }

    public static MicroBlockFragment getHoveredFragment(Entity entity, int hoverX, int hoverY, int hoverZ) {
        float partialTicks = 1.0f;
        double entityX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
        double entityY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks + 1.62 - (double)entity.field_70129_M;
        double entityZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && entity.func_70093_af()) {
            entityY -= (double)0.1f;
        }
        Vec3 entityPos = Vec3.func_72443_a((double)entityX, (double)entityY, (double)entityZ);
        return ItemChisel.getHoveredFragment(entity.field_70170_p, hoverX, hoverY, hoverZ, entityPos, entity.func_70040_Z());
    }

    public static MicroBlockFragment getHoveredFragment(World world, int hoverX, int hoverY, int hoverZ, Vec3 entityPos, Vec3 entityLook) {
        BlockCoord hitCoord;
        Block hitInternalBlock;
        Vec3 rayStart;
        MovingObjectPosition hitPosition;
        TileEntity tileEntity = world.func_147438_o(hoverX, hoverY, hoverZ);
        Block origBlock = world.func_147439_a(hoverX, hoverY, hoverZ);
        IvBlockCollection collection = null;
        if (tileEntity instanceof TileEntityMicroBlock) {
            TileEntityMicroBlock tileEntityMicroBlock = (TileEntityMicroBlock)tileEntity;
            collection = tileEntityMicroBlock.getBlockCollection();
        } else if (ItemClubHammer.isMicroblockable(world, hoverX, hoverY, hoverZ)) {
            collection = new IvBlockCollection(8, 8, 8);
            for (BlockCoord coord : collection) {
                collection.setBlockAndMetadata(coord, origBlock, (byte)world.func_72805_g(hoverX, hoverY, hoverZ));
            }
        }
        if (collection != null && (hitPosition = collection.rayTrace(rayStart = ItemChisel.getPositionInBlockCollection(collection, new BlockCoord(hoverX, hoverY, hoverZ), entityPos), entityLook)) != null && (hitInternalBlock = collection.getBlock(hitCoord = new BlockCoord(hitPosition.field_72311_b, hitPosition.field_72312_c, hitPosition.field_72309_d))).func_149688_o() != Material.field_151579_a) {
            return new MicroBlockFragment(new BlockCoord(hoverX, hoverY, hoverZ), hitCoord, ForgeDirection.getOrientation((int)hitPosition.field_72310_e), hitPosition.field_72307_f);
        }
        return null;
    }

    public static Vec3 getPositionInBlockCollection(IvBlockCollection blockCollection, BlockCoord referenceCoord, Vec3 pos) {
        return Vec3.func_72443_a((double)((pos.field_72450_a - (double)referenceCoord.x) * (double)blockCollection.width), (double)((pos.field_72448_b - (double)referenceCoord.y) * (double)blockCollection.height), (double)((pos.field_72449_c - (double)referenceCoord.z) * (double)blockCollection.length));
    }

    @Override
    public boolean showMicroblockSelection(EntityLivingBase renderEntity, ItemStack stack) {
        return !this.canCarveStatues || !renderEntity.func_70093_af();
    }

    @Override
    public float microblockSelectionSize(ItemStack stack) {
        return 0.52f + (float)this.carvingDistance;
    }

    public static class BlockData {
        public Block block;
        public byte meta;

        public BlockData(Block block, byte meta) {
            this.block = block;
            this.meta = meta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockData blockData = (BlockData)o;
            return this.block == blockData.block && this.meta == blockData.meta;
        }

        public int hashCode() {
            int result = this.block.hashCode();
            result = 31 * result + this.meta;
            return result;
        }

        public String toString() {
            return "BlockData{block=" + this.block + ", meta=" + this.meta + '}';
        }
    }

    public static class MicroBlockFragment {
        private BlockCoord coord;
        private BlockCoord internalCoord;
        private ForgeDirection internalSide;
        private Vec3 hitPoint;

        public MicroBlockFragment(BlockCoord coord, BlockCoord internalCoord, ForgeDirection internalSide, Vec3 hitPoint) {
            this.coord = coord;
            this.internalCoord = internalCoord;
            this.internalSide = internalSide;
            this.hitPoint = hitPoint;
        }

        public BlockCoord getCoord() {
            return this.coord;
        }

        public BlockCoord getInternalCoord() {
            return this.internalCoord;
        }

        public ForgeDirection getInternalSide() {
            return this.internalSide;
        }

        public Vec3 getHitPoint() {
            return this.hitPoint;
        }

        public MicroBlockFragment getOpposite() {
            int blockX = this.coord.x;
            int blockY = this.coord.y;
            int blockZ = this.coord.z;
            int internalX = this.internalCoord.x + this.internalSide.offsetX;
            int internalY = this.internalCoord.y + this.internalSide.offsetY;
            int internalZ = this.internalCoord.z + this.internalSide.offsetZ;
            if (internalX < 0) {
                internalX = 7;
                --blockX;
            } else if (internalX >= 8) {
                internalX = 0;
                ++blockX;
            }
            if (internalY < 0) {
                internalY = 7;
                --blockY;
            } else if (internalY >= 8) {
                internalY = 0;
                ++blockY;
            }
            if (internalZ < 0) {
                internalZ = 7;
                --blockZ;
            } else if (internalZ >= 8) {
                internalZ = 0;
                ++blockZ;
            }
            return new MicroBlockFragment(new BlockCoord(blockX, blockY, blockZ), new BlockCoord(internalX, internalY, internalZ), this.internalSide.getOpposite(), this.hitPoint);
        }

        public String toString() {
            return "MicroBlockFragment{coord=" + this.coord + ", internalCoord=" + this.internalCoord + ", internalSide=" + this.internalSide + ", hitPoint=" + this.hitPoint + '}';
        }
    }
}

