/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.uv.MultiIconTransformation;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.BlockMicroMaterial;
import codechicken.microblock.CommonMicroblock;
import codechicken.microblock.HollowMicroblockClient;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.XUHelperClient;
import com.rwtema.extrautils.block.BlockDecoration;
import com.rwtema.extrautils.block.IconConnectedTexture;
import com.rwtema.extrautils.block.render.FakeRenderBlocks;
import com.rwtema.extrautils.block.render.RenderBlockConnectedTextures;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.collection.Iterator;

public class ConnectedTextureMicroMaterial
extends BlockMicroMaterial {
    public static final double[] u = new double[]{-1.0, 1.0, 1.0, -1.0};
    public static final double[] v = new double[]{1.0, 1.0, -1.0, -1.0};
    public boolean isGlass = true;
    public boolean[] isConnected;
    public boolean hasConnected;
    private int pass;
    private World world;
    int[] cols = new int[]{0x101010FF, -1, 0x1010FFFF, 0x10FF10FF, -15724289, -15663105, -61185};
    @SideOnly(value=Side.CLIENT)
    IconConnectedTexture resetIcons;

    public ConnectedTextureMicroMaterial(Block block, int meta) {
        super(block, meta);
        if (block instanceof BlockDecoration) {
            this.isGlass = !((BlockDecoration)block).field_149787_q[this.meta()];
            for (boolean b : this.isConnected = ((BlockDecoration)block).ctexture[this.meta()]) {
                if (!b) continue;
                this.hasConnected = true;
                break;
            }
        } else {
            this.isGlass = !block.func_149662_c();
            this.isConnected = new boolean[6];
            this.hasConnected = false;
        }
    }

    public int getLightValue() {
        if (this.block() instanceof BlockDecoration) {
            return ((BlockDecoration)this.block()).light[this.meta()];
        }
        return 0;
    }

    public boolean isHollow() {
        for (StackTraceElement a : new Throwable().getStackTrace()) {
            if (!"codechicken.microblock.HollowMicroblockClient".equals(a.getClassName())) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Cuboid6 getWorldHollowCube(Vector3 pos, Cuboid6 bounds) {
        World world = XUHelperClient.clientWorld();
        TileMultipart t = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(pos));
        if (t == null) {
            return bounds;
        }
        for (TMultiPart part : t.jPartList()) {
            if (!(part instanceof HollowMicroblockClient)) continue;
            for (Cuboid6 bound : ((HollowMicroblockClient)part).getOcclusionBoxes()) {
                if (!bound.intersects(bounds)) continue;
                return ((HollowMicroblockClient)part).getBounds();
            }
        }
        return bounds;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMicroFace(Vector3 pos, int pass, Cuboid6 b) {
        if (!CCRenderState.model.getClass().equals(BlockRenderer.BlockFace.class)) {
            super.renderMicroFace(pos, pass, b);
            return;
        }
        Cuboid6 bounds = b.copy();
        Cuboid6 renderBounds = bounds.copy();
        boolean isHollow = this.isHollow();
        int s = ((BlockRenderer.BlockFace)CCRenderState.model).side;
        if (isHollow && pass >= 0) {
            bounds = this.getWorldHollowCube(pos, bounds);
        }
        if (this.isGlass && (!isHollow || pass >= 0)) {
            this.glassChange(bounds);
        }
        if (!this.hasConnected || !this.renderConnected(pos, pass, bounds, renderBounds)) {
            super.renderMicroFace(pos, pass, bounds);
        }
        if (this.resetIcons != null) {
            this.resetIcons.resetType();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void glassChange(Cuboid6 c) {
        double v2;
        double v1;
        double u2;
        double u1;
        BlockRenderer.BlockFace face = (BlockRenderer.BlockFace)CCRenderState.model;
        int side = face.side;
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        switch (side) {
            case 0: {
                u1 = x1;
                u2 = x2;
                v1 = z1;
                v2 = z2;
                break;
            }
            case 1: {
                u1 = x1;
                u2 = x2;
                v1 = z1;
                v2 = z2;
                break;
            }
            case 2: {
                u1 = 1.0 - x2;
                u2 = 1.0 - x1;
                v1 = 1.0 - y2;
                v2 = 1.0 - y1;
                break;
            }
            case 3: {
                u1 = x1;
                u2 = x2;
                v1 = 1.0 - y2;
                v2 = 1.0 - y1;
                break;
            }
            case 4: {
                u1 = z1;
                v1 = 1.0 - y2;
                u2 = z2;
                v2 = 1.0 - y1;
                break;
            }
            case 5: {
                u1 = 1.0 - z2;
                u2 = 1.0 - z1;
                v1 = 1.0 - y2;
                v2 = 1.0 - y1;
                break;
            }
            default: {
                return;
            }
        }
        if (v1 == v2 || u1 == u2) {
            return;
        }
        for (Vertex5 v : face.verts) {
            v.uv.u = (v.uv.u - u1) / (u2 - u1);
            v.uv.v = (v.uv.v - v1) / (v2 - v1);
        }
        face.lcComputed = false;
        face.computeLightCoords();
    }

    public boolean isInt(double t) {
        return t == (double)((int)t);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderConnected(Vector3 pos, int pass, Cuboid6 bounds, Cuboid6 renderBounds) {
        IIcon icon;
        this.pass = pass;
        if (pass < 0) {
            return false;
        }
        if (!(this.isInt(pos.x) && this.isInt(pos.y) && this.isInt(pos.z))) {
            return false;
        }
        if (!CCRenderState.model.getClass().equals(BlockRenderer.BlockFace.class)) {
            return false;
        }
        if (!this.isFlush(bounds)) {
            return false;
        }
        int s = this.getSideFromBounds(bounds);
        BlockRenderer.BlockFace face = (BlockRenderer.BlockFace)CCRenderState.model;
        int side = face.side;
        if (!this.isConnected[side]) {
            return false;
        }
        if (s == -1) {
            s = side;
        }
        if (!((icon = this.icont().icons[side]) instanceof IconConnectedTexture)) {
            return false;
        }
        this.world = XUHelperClient.clientPlayer().func_130014_f_();
        if (s == side) {
            int c = this.getColour(pass);
            if (this.isGlass) {
                double h = 0.001;
                switch (s) {
                    case 0: {
                        this.renderHalfSide(this.block(), 0.5, h, 0.5, 1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                        break;
                    }
                    case 1: {
                        this.renderHalfSide(this.block(), 0.5, 1.0 - h, 0.5, -1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                        break;
                    }
                    case 2: {
                        this.renderHalfSide(this.block(), 0.5, 0.5, h, 1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                        break;
                    }
                    case 3: {
                        this.renderHalfSide(this.block(), 0.5, 0.5, 1.0 - h, -1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                        break;
                    }
                    case 4: {
                        this.renderHalfSide(this.block(), h, 0.5, 0.5, 0, 0, -1, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                        break;
                    }
                    case 5: {
                        this.renderHalfSide(this.block(), 1.0 - h, 0.5, 0.5, 0, 0, 1, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                    }
                }
            } else {
                FakeRenderBlocks fr = RenderBlockConnectedTextures.fakeRender;
                fr.setWorld((IBlockAccess)this.world);
                fr.curBlock = this.block();
                fr.curMeta = this.meta();
                switch (s) {
                    case 0: {
                        this.renderSide(this.block(), 0.5, 0.0, 0.5, 1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, side, pos, c, this.icont(), renderBounds, bounds);
                        break;
                    }
                    case 1: {
                        this.renderSide(this.block(), 0.5, 1.0, 0.5, -1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, side, pos, c, this.icont(), renderBounds, bounds);
                        break;
                    }
                    case 2: {
                        this.renderSide(this.block(), 0.5, 0.5, 0.0, 1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont(), renderBounds, bounds);
                        break;
                    }
                    case 3: {
                        this.renderSide(this.block(), 0.5, 0.5, 1.0, -1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont(), renderBounds, bounds);
                        break;
                    }
                    case 4: {
                        this.renderSide(this.block(), 0.0, 0.5, 0.5, 0, 0, -1, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont(), renderBounds, bounds);
                        break;
                    }
                    case 5: {
                        this.renderSide(this.block(), 1.0, 0.5, 0.5, 0, 0, 1, 0, 1, 0, (IconConnectedTexture)icon, side, pos, c, this.icont(), renderBounds, bounds);
                    }
                }
            }
            return true;
        }
        if (side == Facing.field_71588_a[s]) {
            double h = this.sideSize(bounds);
            switch (Facing.field_71588_a[s]) {
                case 0: {
                    this.renderHalfSide(this.block(), 0.5, h, 0.5, 1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                    break;
                }
                case 1: {
                    this.renderHalfSide(this.block(), 0.5, h, 0.5, -1, 0, 0, 0, 0, -1, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                    break;
                }
                case 2: {
                    this.renderHalfSide(this.block(), 0.5, 0.5, h, 1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                    break;
                }
                case 3: {
                    this.renderHalfSide(this.block(), 0.5, 0.5, h, -1, 0, 0, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                    break;
                }
                case 4: {
                    this.renderHalfSide(this.block(), h, 0.5, 0.5, 0, 0, -1, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                    break;
                }
                case 5: {
                    this.renderHalfSide(this.block(), h, 0.5, 0.5, 0, 0, 1, 0, 1, 0, (IconConnectedTexture)icon, bounds, side, pos, renderBounds);
                }
            }
            return true;
        }
        if (this.isGlass) {
            double d = renderBounds.getSide(side);
            return (d == 0.0 || d == 1.0) && this.hasMatchingPart(bounds, (int)pos.x + Facing.field_71586_b[side], (int)pos.y + Facing.field_71587_c[side], (int)pos.z + Facing.field_71585_d[side]);
        }
        return false;
    }

    public double dist(Vector3 a, Vector3 b) {
        return Math.sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y) + (a.z - b.z) * (a.z - b.z));
    }

    public boolean isFlush(Cuboid6 bounds) {
        int i = 0;
        if (bounds.max.y != 1.0) {
            ++i;
        }
        if (bounds.min.y != 0.0) {
            ++i;
        }
        if (bounds.max.z != 1.0) {
            ++i;
        }
        if (bounds.min.z != 0.0) {
            ++i;
        }
        if (bounds.max.x != 1.0) {
            ++i;
        }
        if (bounds.min.x != 0.0) {
            ++i;
        }
        return i <= 1;
    }

    public double sideSize(Cuboid6 bounds) {
        if (bounds.max.y != 1.0) {
            return bounds.max.y;
        }
        if (bounds.min.y != 0.0) {
            return bounds.min.y;
        }
        if (bounds.max.z != 1.0) {
            return bounds.max.z;
        }
        if (bounds.min.z != 0.0) {
            return bounds.min.z;
        }
        if (bounds.max.x != 1.0) {
            return bounds.max.x;
        }
        if (bounds.min.x != 0.0) {
            return bounds.min.x;
        }
        return 0.0;
    }

    public int getSideFromBounds(Cuboid6 bounds) {
        if (bounds.max.y != 1.0) {
            return 0;
        }
        if (bounds.min.y != 0.0) {
            return 1;
        }
        if (bounds.max.z != 1.0) {
            return 2;
        }
        if (bounds.min.z != 0.0) {
            return 3;
        }
        if (bounds.max.x != 1.0) {
            return 4;
        }
        if (bounds.min.x != 0.0) {
            return 5;
        }
        return -1;
    }

    public boolean isTransparent() {
        return this.isGlass;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSide(Block block, double ox, double oy, double oz, int ax, int ay, int az, int bx, int by, int bz, IconConnectedTexture icon, int side, Vector3 pos, int colour, MultiIconTransformation icont, Cuboid6 renderBounds, Cuboid6 bounds) {
        int[] tex = new int[4];
        boolean isDifferent = false;
        for (int j = 0; j < 4; ++j) {
            RenderBlockConnectedTextures.fakeRender.isOpaque = !this.isGlass;
            tex[j] = RenderBlockConnectedTextures.fakeRender.getType(block, side, (int)pos.x, (int)pos.y, (int)pos.z, ax * (int)u[j], ay * (int)u[j], az * (int)u[j], bx * (int)v[j], by * (int)v[j], bz * (int)v[j], (int)(ox * 2.0 - 1.0), (int)(oy * 2.0 - 1.0), (int)(oz * 2.0 - 1.0));
            if (tex[j] == tex[0]) continue;
            isDifferent = true;
        }
        BlockRenderer.BlockFace face = (BlockRenderer.BlockFace)CCRenderState.model;
        face.lcComputed = false;
        if (isDifferent) {
            for (int j = 0; j < 4; ++j) {
                double cx = ox + (double)ax * u[j] / 4.0 + (double)bx * v[j] / 4.0;
                double cy = oy + (double)ay * u[j] / 4.0 + (double)by * v[j] / 4.0;
                double cz = oz + (double)az * u[j] / 4.0 + (double)bz * v[j] / 4.0;
                Cuboid6 b = new Cuboid6(cx, cy, cz, cx, cy, cz);
                b.setSide(side, bounds.getSide(side));
                b.setSide(Facing.field_71588_a[side], bounds.getSide(Facing.field_71588_a[side]));
                for (int k = 0; k < 4; ++k) {
                    this.expandToInclude(b, new Vector3(cx + u[k] * (double)ax * 0.25 + v[k] * (double)bx * 0.25, cy + u[k] * (double)ay * 0.25 + v[k] * (double)by * 0.25, cz + u[k] * (double)az * 0.25 + v[k] * (double)bz * 0.25));
                }
                if (this.isEmpty(b = this.shrinkToEnclose(b.copy(), renderBounds))) continue;
                if (this.isGlass) {
                    for (int i = 0; i < 4; ++i) {
                        face.lightCoords[i].computeO(face.verts[i].vec, side);
                    }
                    face.lcComputed = true;
                } else {
                    face.lcComputed = false;
                }
                for (IIcon ic : this.icont().icons) {
                    if (!(ic instanceof IconConnectedTexture)) continue;
                    ((IconConnectedTexture)ic).setType(tex[j]);
                }
                face.loadCuboidFace(b, side);
                super.renderMicroFace(pos, this.pass, b);
                for (IIcon ic : this.icont().icons) {
                    if (!(ic instanceof IconConnectedTexture)) continue;
                    ((IconConnectedTexture)ic).resetType();
                }
            }
        } else {
            if (this.isEmpty(bounds = this.shrinkToEnclose(bounds.copy(), renderBounds))) {
                return;
            }
            face.loadCuboidFace(bounds, side);
            for (IIcon ic : this.icont().icons) {
                if (!(ic instanceof IconConnectedTexture)) continue;
                ((IconConnectedTexture)ic).setType(tex[0]);
            }
            super.renderMicroFace(pos, this.pass, bounds);
            for (IIcon ic : this.icont().icons) {
                if (!(ic instanceof IconConnectedTexture)) continue;
                ((IconConnectedTexture)ic).resetType();
            }
        }
    }

    private double interp(double v) {
        return v / 16.0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasMatchingPart(Cuboid6 part, int x, int y, int z) {
        TileEntity tile_base = this.world.func_147438_o(x, y, z);
        if (tile_base != null && tile_base instanceof TileMultipart) {
            Iterator parts = ((TileMultipart)tile_base).partList().toIterator();
            while (parts.hasNext()) {
                TMultiPart p = (TMultiPart)parts.next();
                if (!(p instanceof CommonMicroblock) || !this.equalCubes(((CommonMicroblock)p).getBounds(), part) || MicroMaterialRegistry.getMaterial((int)((CommonMicroblock)p).material()) != this) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equalCubes(Cuboid6 a, Cuboid6 b) {
        return this.getSideFromBounds(a) == this.getSideFromBounds(b) && this.sideSize(a) == this.sideSize(b);
    }

    @SideOnly(value=Side.CLIENT)
    public int getHalfType(Block block, int side, int x, int y, int z, int ax, int ay, int az, int bx, int by, int bz, Cuboid6 part) {
        boolean a = this.hasMatchingPart(part, x + ax, y + ay, z + az);
        boolean b = this.hasMatchingPart(part, x + bx, y + by, z + bz);
        if (a) {
            if (b) {
                if (this.hasMatchingPart(part, x + ax + bx, y + ay + by, z + az + bz)) {
                    return 3;
                }
                return 4;
            }
            return 2;
        }
        if (b) {
            return 1;
        }
        return 0;
    }

    public Cuboid6 getBounds(Cuboid6 b, int side) {
        return b;
    }

    public Cuboid6 expandToInclude(Cuboid6 a, Vector3 v) {
        if (a.min.x > v.x) {
            a.min.x = v.x;
        }
        if (a.min.y > v.y) {
            a.min.y = v.y;
        }
        if (a.min.z > v.z) {
            a.min.z = v.z;
        }
        if (a.max.y < v.y) {
            a.max.y = v.y;
        }
        if (a.max.x < v.x) {
            a.max.x = v.x;
        }
        if (a.max.z < v.z) {
            a.max.z = v.z;
        }
        return a;
    }

    public boolean isEmpty(Cuboid6 a) {
        return a.min.x >= a.max.x || a.min.y >= a.max.y || a.min.z >= a.max.z;
    }

    public Cuboid6 shrinkToEnclose(Cuboid6 a, Cuboid6 c) {
        if (a.min.x < c.min.x) {
            a.min.x = c.min.x;
        }
        if (a.min.y < c.min.y) {
            a.min.y = c.min.y;
        }
        if (a.min.z < c.min.z) {
            a.min.z = c.min.z;
        }
        if (a.max.x > c.max.x) {
            a.max.x = c.max.x;
        }
        if (a.max.y > c.max.y) {
            a.max.y = c.max.y;
        }
        if (a.max.z > c.max.z) {
            a.max.z = c.max.z;
        }
        return a;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHalfSide(Block block, double ox, double oy, double oz, int ax, int ay, int az, int bx, int by, int bz, IconConnectedTexture icon, Cuboid6 bounds, int side, Vector3 pos, Cuboid6 renderBounds) {
        int[] tex = new int[4];
        boolean isDifferent = false;
        int s = Facing.field_71588_a[this.getSideFromBounds(bounds)];
        for (int j = 0; j < 4; ++j) {
            RenderBlockConnectedTextures.fakeRender.isOpaque = !this.isGlass;
            tex[j] = this.getHalfType(block, side, (int)pos.x, (int)pos.y, (int)pos.z, ax * (int)u[j], ay * (int)u[j], az * (int)u[j], bx * (int)v[j], by * (int)v[j], bz * (int)v[j], bounds);
            if (tex[j] == tex[0]) continue;
            isDifferent = true;
        }
        BlockRenderer.BlockFace face = (BlockRenderer.BlockFace)CCRenderState.model;
        face.lcComputed = false;
        if (isDifferent) {
            for (int j = 0; j < 4; ++j) {
                double cx = ox + (double)ax * u[j] / 4.0 + (double)bx * v[j] / 4.0;
                double cy = oy + (double)ay * u[j] / 4.0 + (double)by * v[j] / 4.0;
                double cz = oz + (double)az * u[j] / 4.0 + (double)bz * v[j] / 4.0;
                Cuboid6 b = new Cuboid6(cx, cy, cz, cx, cy, cz);
                b.setSide(face.side, bounds.getSide(face.side));
                b.setSide(Facing.field_71588_a[face.side], bounds.getSide(Facing.field_71588_a[face.side]));
                for (int k = 0; k < 4; ++k) {
                    this.expandToInclude(b, new Vector3(cx + u[k] * (double)ax * 0.25 + v[k] * (double)bx * 0.25, cy + u[k] * (double)ay * 0.25 + v[k] * (double)by * 0.25, cz + u[k] * (double)az * 0.25 + v[k] * (double)bz * 0.25));
                }
                if (this.isEmpty(b = this.shrinkToEnclose(b.copy(), renderBounds))) continue;
                if (this.isGlass) {
                    for (int i = 0; i < 4; ++i) {
                        face.lightCoords[i].computeO(face.verts[i].vec, side);
                    }
                    face.lcComputed = true;
                } else {
                    face.lcComputed = false;
                }
                for (IIcon ic : this.icont().icons) {
                    if (!(ic instanceof IconConnectedTexture)) continue;
                    ((IconConnectedTexture)ic).setType(tex[j]);
                }
                face.loadCuboidFace(b, face.side);
                super.renderMicroFace(pos, this.pass, b);
                for (IIcon ic : this.icont().icons) {
                    if (!(ic instanceof IconConnectedTexture)) continue;
                    ((IconConnectedTexture)ic).resetType();
                }
            }
        } else {
            if (this.isEmpty(bounds = this.shrinkToEnclose(bounds.copy(), renderBounds))) {
                return;
            }
            face.loadCuboidFace(bounds, side);
            for (IIcon ic : this.icont().icons) {
                if (!(ic instanceof IconConnectedTexture)) continue;
                ((IconConnectedTexture)ic).setType(tex[0]);
            }
            super.renderMicroFace(pos, this.pass, bounds);
            for (IIcon ic : this.icont().icons) {
                if (!(ic instanceof IconConnectedTexture)) continue;
                ((IconConnectedTexture)ic).resetType();
            }
        }
    }
}

