/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.worldgen;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.tileentity.TileEntityPortal;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class UnderdarkTeleport
extends Teleporter {
    private final WorldServer worldServerInstance;
    private final Random random;
    private final LongHashMap destinationCoordinateCache = new LongHashMap();

    public UnderdarkTeleport(WorldServer par1WorldServer) {
        super(par1WorldServer);
        this.worldServerInstance = par1WorldServer;
        this.random = new Random(par1WorldServer.func_72905_C());
    }

    public void func_77185_a(Entity entity, double x, double y, double z, float r) {
        if (!this.func_77184_b(entity, x, y, z, r)) {
            if (this.worldServerInstance.field_73011_w.field_76574_g != ExtraUtils.dimID) {
                y = this.worldServerInstance.func_72825_h((int)x, (int)z);
                entity.func_70012_b(x, y, z, entity.field_70177_z, 0.0f);
            } else {
                this.func_85188_a(entity);
            }
        }
    }

    public TileEntity findPortalInChunk(double x, double z) {
        Chunk chunk = this.worldServerInstance.func_72938_d((int)x, (int)z);
        for (Object tile : chunk.field_150816_i.values()) {
            if (!(tile instanceof TileEntityPortal)) continue;
            return (TileEntity)tile;
        }
        return null;
    }

    public boolean func_77184_b(Entity entity, double x, double y, double z, float r) {
        TileEntity destPortal = null;
        for (int s = 0; s <= 5 && destPortal == null; ++s) {
            for (int dx = -s; dx <= s; ++dx) {
                for (int dz = -s; dz <= s; ++dz) {
                    if (destPortal != null) continue;
                    destPortal = this.findPortalInChunk(x + (double)(dx * 16), z + (double)(dz * 16));
                }
            }
        }
        if (destPortal != null) {
            entity.func_70012_b((double)destPortal.field_145851_c + 0.5, (double)(destPortal.field_145848_d + 1), (double)destPortal.field_145849_e + 0.5, entity.field_70177_z, entity.field_70125_A);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int ex = MathHelper.func_76128_c((double)entity.field_70165_t);
        int ey = MathHelper.func_76128_c((double)entity.field_70163_u) - 1;
        int ez = MathHelper.func_76128_c((double)entity.field_70161_v);
        ey /= 5;
        if ((ey += 139) > 247) {
            ey = 247;
        }
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -2; y <= 4; ++y) {
                    if (x == 0 && y == -1 && z == 0) {
                        this.worldServerInstance.func_147465_d(ex + x, ey + y, ez + z, ExtraUtils.portal, 1, 2);
                        this.worldServerInstance.func_147464_a(ex + x, ey + y, ez + z, ExtraUtils.portal, 1);
                        continue;
                    }
                    if (x == -3 || x == 3 || y <= -1 || y == 4 || z == -3 || z == 3) {
                        this.worldServerInstance.func_147449_b(ex + x, ey + y, ez + z, Blocks.field_150347_e);
                        continue;
                    }
                    if (y == 0 && (x == 2 || x == -2 || z == 2 || z == -2)) {
                        this.worldServerInstance.func_147465_d(ex + x, ey + y, ez + z, Blocks.field_150478_aa, 5, 3);
                        continue;
                    }
                    this.worldServerInstance.func_147449_b(ex + x, ey + y, ez + z, Blocks.field_150350_a);
                }
            }
        }
        entity.func_70012_b((double)ex + 0.5, (double)ey, (double)ez + 0.5, entity.field_70177_z, 0.0f);
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        return true;
    }

    public void func_85189_a(long par1) {
    }
}

