/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.worldgen;

import com.rwtema.extrautils.ChunkPos;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.LogHelper;
import com.rwtema.extrautils.block.BlockColorData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDoor;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;

public class WorldGenCastle
extends WorldGenerator {
    public static final int rad = 17;
    private int[][] block = new int[17][17];
    public static final int[] dx = new int[]{-1, 0, 1, 0};
    public static final int[] dy = new int[]{0, -1, 0, 1};
    public static final int d = 9;
    public static String[] dungeons = new String[]{"dungeonChest", "strongholdCorridor", "strongholdLibrary", "pyramidDesertyChest", "pyramidJungleChest", "mineshaftCorridor", "villageBlacksmith", "strongholdCrossing", "dungeonChest", "dungeonChest", "dungeonChest", "dungeonChest"};
    public static Random staticRand = new Random();
    public long timer = 0L;
    private int[] block_allocations = new int[16];
    private boolean colorbricks;
    private boolean colorWoods;
    private boolean lightGen;
    private ArrayList<ChunkPos> torchPos = new ArrayList();

    public static void setMobSpawner(World world, int x, int y, int z, Random rand) {
        world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 2);
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        if (tileentitymobspawner != null) {
            tileentitymobspawner.func_145881_a().func_98272_a(DungeonHooks.getRandomDungeonMob((Random)rand));
        } else {
            LogHelper.error("Failed to fetch mob spawner entity at (" + x + ", " + y + ", " + z + ")", new Object[0]);
        }
    }

    public int castleX(long seed, int x, int z) {
        staticRand.setSeed(seed + (long)(x >> 9) + (long)(65535 * (z >> 9)));
        return (x >> 9 << 9) + staticRand.nextInt(390) + 61;
    }

    public int castleZ(long seed, int x, int z) {
        staticRand.setSeed(seed + (long)(x >> 9) + (long)(65535 * (z >> 9)));
        staticRand.nextInt(390);
        return (z >> 9 << 9) + staticRand.nextInt(390) + 61;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int j;
        int cx = this.castleX(world.func_72905_C(), x, z);
        int cz = this.castleZ(world.func_72905_C(), x, z);
        if (cx >> 4 != x >> 4 || cz >> 4 != z >> 4) {
            return false;
        }
        for (int ax = 0; ax < 17; ++ax) {
            for (int ay = 0; ay < 17; ++ay) {
                this.s(ax, ay, -1);
            }
        }
        ArrayList<Vec2> initBlocks = new ArrayList<Vec2>();
        initBlocks.add(new Vec2(8, 8));
        for (int i = 0; i < initBlocks.size() && (double)initBlocks.size() < 68.0; ++i) {
            int ax = ((Vec2)initBlocks.get((int)i)).x;
            int ay = ((Vec2)initBlocks.get((int)i)).y;
            int dj = rand.nextInt(4);
            j = (dj + 1) % 4;
            while (j != dj) {
                Vec2 t;
                if (this.isValid(ax + dx[j], ay + dy[j]) && !initBlocks.contains(t = new Vec2(ax + dx[j], ay + dy[j]))) {
                    if (initBlocks.size() - 2 - i > 0) {
                        initBlocks.add(i + 1 + rand.nextInt(initBlocks.size() - 2 - i), t);
                    } else {
                        initBlocks.add(t);
                    }
                    this.s(ax + dx[j], ay + dy[j], 0);
                    this.s(16 - (ax + dx[j]), 16 - (ay + dy[j]), 0);
                    this.s(ax + dx[j], 16 - (ay + dy[j]), 0);
                    this.s(16 - (ax + dx[j]), ay + dy[j], 0);
                }
                j = (j + 1) % 4;
            }
        }
        x = cx - 24;
        z = cz - 24;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        this.colorbricks = ExtraUtils.colorBlockBrick != null;
        boolean bl = this.colorWoods = ExtraUtils.coloredWood != null;
        if (this.colorbricks) {
            int i = 0;
            while (i < 16) {
                j = rand.nextInt(1 + i);
                if (i != j) {
                    this.block_allocations[i] = this.block_allocations[j];
                }
                this.block_allocations[j] = i++;
            }
            float[][] cols = new float[16][3];
            g = b = 0.4f + 0.6f * rand.nextFloat();
            r = b;
            r *= (2.0f + rand.nextFloat()) / 3.0f;
            g *= (2.0f + rand.nextFloat()) / 3.0f;
            b *= (2.0f + rand.nextFloat()) / 3.0f;
            for (int i2 = 0; i2 < 16; ++i2) {
                float br = (1.0f + rand.nextFloat()) / 2.0f;
                cols[i2][0] = r * br * (5.0f + rand.nextFloat()) / 6.0f;
                cols[i2][1] = g * br * (5.0f + rand.nextFloat()) / 6.0f;
                cols[i2][2] = b * br * (5.0f + rand.nextFloat()) / 6.0f;
            }
            for (int dx = x - 16; dx <= x + 51 + 16; dx += 16) {
                for (int dz = z - 16; dz <= z + 51 + 16; dz += 16) {
                    for (int i3 = 0; i3 < 16; ++i3) {
                        BlockColorData.changeColorData(world, dx, y, dz, this.block_allocations[i3], cols[i3][0], cols[i3][1], cols[i3][2]);
                    }
                }
            }
        }
        this.torchPos.clear();
        for (int i = 0; i < 5; ++i) {
            this.genLevel(world, rand, x, y + i * 5, z, i);
        }
        for (ChunkPos torchPo1 : this.torchPos) {
            world.func_72938_d(torchPo1.x, torchPo1.z).func_150807_a(torchPo1.x & 0xF, torchPo1.y, torchPo1.z & 0xF, Blocks.field_150478_aa, 5);
        }
        for (ChunkPos torchPo : this.torchPos) {
            world.func_147451_t(torchPo.x, torchPo.y, torchPo.z);
        }
        return true;
    }

    public void genLevel(World world, Random rand, int x, int y, int z, int level) {
        int day;
        int dax;
        int ay;
        int ax;
        int j;
        for (int ax2 = 0; ax2 < 17; ++ax2) {
            for (int ay2 = 0; ay2 < 17; ++ay2) {
                this.block[ax2][ay2] = this.block[ax2][ay2] == -1 || ax2 <= level || 16 - ax2 <= level || ay2 <= level || 16 - ay2 <= level ? -1 : 0;
            }
        }
        ArrayList list = new ArrayList();
        ArrayList<Vec2> corridors = new ArrayList<Vec2>();
        this.block[8][8] = 1;
        corridors.add(new Vec2(8, 8));
        if (level == 0) {
            for (int ax3 = 1; ax3 < 17; ++ax3) {
                this.block[ax3][8] = 1;
                corridors.add(new Vec2(ax3, 8));
            }
            this.block[0][8] = -1;
        }
        int a = 0;
        while (a < 289) {
            ++a;
            Vec2 t = (Vec2)corridors.get(rand.nextInt(corridors.size()));
            int k = 1 + rand.nextInt(8);
            int d = rand.nextInt(4);
            boolean canAdd = true;
            for (int i = 1; i <= k && canAdd; ++i) {
                if (!this.isValid(t.x + dx[d] * i, t.y + dy[d] * i) || this.g(t.x + dx[d] * i, t.y + dy[d] * i) != 0) {
                    canAdd = false;
                    continue;
                }
                int c_n = 0;
                for (j = 0; j < 4; ++j) {
                    if (this.g(t.x + dx[d] * i + dx[j], t.y + dy[d] * i + dy[j]) == 0) continue;
                    ++c_n;
                }
                if (c_n >= 2) {
                    canAdd = false;
                    continue;
                }
                c_n = 0;
                for (int ddx = -2; ddx <= 2; ++ddx) {
                    for (int ddy = -2; ddy <= 2; ++ddy) {
                        if (this.g(t.x + dx[d] * i + ddx, t.y + dy[d] * i + ddy) == 0) continue;
                        ++c_n;
                    }
                }
                if (c_n >= 8) {
                    canAdd = false;
                    continue;
                }
                this.s(t.x + dx[d] * i, t.y + dy[d] * i, 1);
                corridors.add(new Vec2(t.x + dx[d] * i, t.y + dy[d] * i));
                a += 12;
            }
        }
        Collections.shuffle(corridors);
        for (int i = 0; i < corridors.size() && i < 10; ++i) {
            list.add(corridors.get(i));
        }
        int numDoors = 0;
        ArrayList<Integer> doorDirections = new ArrayList<Integer>();
        doorDirections.add(0);
        for (int i = 0; i < list.size(); ++i) {
            ax = ((Vec2)list.get((int)i)).x;
            ay = ((Vec2)list.get((int)i)).y;
            boolean added = false;
            if (this.g(ax, ay) == 0) {
                int j2;
                int k;
                for (j = 0; j < 4; ++j) {
                    if (this.g(ax + dx[j], ay + dy[j]) >> 1 <= 0 || this.g(ax + dx[j], ay + dy[j]) >> 1 != this.g(ax + dx[(j + 1) % 4], ay + dy[(j + 1) % 4]) >> 1) continue;
                    added = true;
                    this.s(ax, ay, (this.g(ax + dx[j], ay + dy[j]) >> 1) * 2 + 1);
                }
                if (!added) {
                    k = rand.nextInt(4);
                    for (j2 = 0; j2 < 4; ++j2) {
                        if (this.g(ax + dx[(j2 + k) % 4], ay + dy[(j2 + k) % 4]) >> 1 <= 0) continue;
                        added = true;
                        this.s(ax, ay, (this.g(ax + dx[(j2 + k) % 4], ay + dy[(j2 + k) % 4]) >> 1) * 2 + 1);
                    }
                }
                if (!added) {
                    k = rand.nextInt(4);
                    for (j2 = 0; j2 < 4; ++j2) {
                        if (this.g(ax + dx[(j2 + k) % 4], ay + dy[(j2 + k) % 4]) != 1) continue;
                        added = true;
                        doorDirections.add(j2);
                        this.s(ax, ay, ++numDoors * 2);
                    }
                }
            }
            for (j = 0; j < 4; ++j) {
                if (!this.isValid(ax + dx[j], ay + dy[j]) || list.contains(new Vec2(ax + dx[j], ay + dy[j]))) continue;
                if (list.size() - i >= 1) {
                    list.add(i + rand.nextInt(list.size() - i), new Vec2(ax + dx[j], ay + dy[j]));
                    continue;
                }
                list.add(new Vec2(ax + dx[j], ay + dy[j]));
            }
        }
        int doorDir = 0;
        for (ax = 0; ax < 17; ++ax) {
            for (ay = 0; ay < 17; ++ay) {
                int d = this.g(ax, ay);
                if (d >= 0) {
                    for (dax = -1; dax <= 1; ++dax) {
                        for (day = -1; day <= 1; ++day) {
                            this.setBrick(world, x + 1 + ax * 3 + dax, y, z + 1 + ay * 3 + day, 0);
                            Block id = Blocks.field_150350_a;
                            if (dax == 0 && day == 0) {
                                id = Blocks.field_150350_a;
                                if (d > 1) {
                                    this.setWood(world, x + 1 + ax * 3 + dax, y, z + 1 + ay * 3 + day, (d >> 1) % 16);
                                }
                            } else if (dax == 0 || day == 0) {
                                int n = dax == 0 ? (day == 1 ? 3 : 1) : (doorDir = dax == 1 ? 2 : 0);
                                if (this.g(ax + dax, ay + day) >> 1 == d >> 1 || d == 1 && this.g(ax + dax, ay + day) <= 0 || d == 1 && this.g(ax + dax, ay + day) % 2 == 0 || d % 2 == 0 && this.g(ax + dax, ay + day) == 1) {
                                    if (d % 2 == 0 && this.g(ax + dax, ay + day) == 1) {
                                        id = Blocks.field_150344_f;
                                    } else {
                                        id = Blocks.field_150350_a;
                                        if (d > 1) {
                                            this.setWood(world, x + 1 + ax * 3 + dax, y, z + 1 + ay * 3 + day, this.woodPattern(d, ax * 3 + dax, ay * 3 + day));
                                        }
                                    }
                                } else {
                                    id = Blocks.field_150417_aV;
                                }
                            } else if (d > 1 && this.g(ax + dax, ay) >> 1 == d >> 1 && this.g(ax, ay + day) >> 1 == d >> 1) {
                                id = Blocks.field_150350_a;
                                this.setWood(world, x + 1 + ax * 3 + dax, y, z + 1 + ay * 3 + day, this.woodPattern(d, ax * 3 + dax, ay * 3 + day));
                            } else {
                                id = Blocks.field_150417_aV;
                            }
                            if (id == Blocks.field_150344_f) {
                                ItemDoor.func_150924_a((World)world, (int)(x + 1 + ax * 3 + dax), (int)(y + 1), (int)(z + 1 + ay * 3 + day), (int)doorDir, (Block)Blocks.field_150466_ao);
                                this.setBrick(world, x + 1 + ax * 3 + dax, y + 3, z + 1 + ay * 3 + day, 2);
                                this.setBrick(world, x + 1 + ax * 3 + dax, y + 4, z + 1 + ay * 3 + day, 1);
                            } else {
                                for (int dh = 0; dh <= 3; ++dh) {
                                    if (id == Blocks.field_150417_aV) {
                                        this.setBrick(world, x + 1 + ax * 3 + dax, y + 1 + dh, z + 1 + ay * 3 + day, dh == 2 ? 2 : 1);
                                        continue;
                                    }
                                    world.func_147465_d(x + 1 + ax * 3 + dax, y + 1 + dh, z + 1 + ay * 3 + day, id, 0, 2);
                                }
                            }
                            if (d == 1) {
                                this.setBrick(world, x + 1 + ax * 3 + dax, y + 3, z + 1 + ay * 3 + day, 1);
                            }
                            this.setBrick(world, x + 1 + ax * 3 + dax, y + 4, z + 1 + ay * 3 + day, 3);
                        }
                    }
                    continue;
                }
                for (dax = -1; dax <= 1; ++dax) {
                    for (day = -1; day <= 1; ++day) {
                        if (this.g(ax + dax, ay + day) < 0 && this.g(ax + dax, ay) < 0 && this.g(ax, ay + day) < 0) continue;
                        this.setBrick(world, x + 1 + ax * 3 + dax, y, z + 1 + ay * 3 + day, 0);
                        this.setBrick(world, x + 1 + ax * 3 + dax, y + 4, z + 1 + ay * 3 + day, 4);
                        if ((ax + dax + ay + day) % 2 != 0) continue;
                        this.setBrick(world, x + 1 + ax * 3 + dax, y + 5, z + 1 + ay * 3 + day, 5);
                        this.torchPos.add(new ChunkPos(x + 1 + ax * 3 + dax, y + 6, z + 1 + ay * 3 + day));
                    }
                }
            }
        }
        ax = 8;
        ay = 8;
        for (int h = 0; h <= 4; ++h) {
            for (dax = -2; dax <= 2; ++dax) {
                for (day = -2; day <= 2; ++day) {
                    if (Math.abs(dax) >= 2 && Math.abs(day) >= 2) continue;
                    if (h > 0 && h < 4) {
                        world.func_147465_d(x + 1 + ax * 3 + dax, y + h, z + 1 + ay * 3 + day, Blocks.field_150350_a, 0, 2);
                        continue;
                    }
                    this.setBrick(world, x + 1 + ax * 3 + dax, y + h, z + 1 + ay * 3 + day, 3);
                }
            }
            this.setBrick(world, x + 1 + ax * 3 + 1, y + h, z + 1 + ay * 3, 0);
            world.func_147465_d(x + 1 + ax * 3, y + h, z + 1 + ay * 3, Blocks.field_150468_ap, 4, 2);
        }
        if (level == 0) {
            for (int dax2 = -1; dax2 <= 1; ++dax2) {
                for (int day2 = -1; day2 <= 1; ++day2) {
                    this.setBrick(world, x + 1 + ax * 3 + dax2, y, z + 1 + ay * 3 + day2, 1);
                }
            }
        }
        int numChests = (17 - 2 * level) * (17 - 2 * level) / 49;
        ArrayList<Vec2> chestPos = new ArrayList<Vec2>();
        for (int i = list.size() - 1; chestPos.size() < numChests && i >= 0; --i) {
            boolean add;
            Vec2 v = (Vec2)list.get(i);
            boolean bl = add = this.g(v.x, v.y) > 1;
            if (add) {
                for (int j3 = 0; add && j3 < chestPos.size(); ++j3) {
                    if (!(((Vec2)chestPos.get(j3)).distFrom(v) < 8.0)) continue;
                    add = false;
                }
            }
            if (!add) continue;
            chestPos.add(v);
        }
        for (Vec2 chestPo : chestPos) {
            world.func_147449_b(x + 1 + 3 * chestPo.x, y + 1, z + 1 + 3 * chestPo.y, (Block)Blocks.field_150486_ae);
            TileEntityChest tile = (TileEntityChest)world.func_147438_o(x + 1 + 3 * chestPo.x, y + 1, z + 1 + 3 * chestPo.y);
            if (tile != null) {
                ChestGenHooks info = ChestGenHooks.getInfo((String)dungeons[rand.nextInt(dungeons.length)]);
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)tile, (int)info.getCount(rand));
            }
            WorldGenCastle.setMobSpawner(world, x + 1 + 3 * chestPo.x, y + 2, z + 1 + 3 * chestPo.y, rand);
        }
    }

    public void setBrick(World world, int x, int y, int z, int type) {
        if (this.colorbricks) {
            world.func_147465_d(x, y, z, (Block)ExtraUtils.colorBlockBrick, this.block_allocations[type], 2);
        } else {
            world.func_147449_b(x, y, z, Blocks.field_150417_aV);
        }
    }

    public void setWood(World world, int x, int y, int z, int type) {
        if (this.colorWoods) {
            world.func_147465_d(x, y, z, (Block)ExtraUtils.coloredWood, this.block_allocations[type], 2);
        } else {
            world.func_147465_d(x, y, z, Blocks.field_150344_f, type % 4, 2);
        }
    }

    public int g(int x, int y) {
        return this.isValid(x, y) ? this.block[x][y] : -1;
    }

    public void s(int x, int y, int i) {
        if (this.isValid(x, y)) {
            this.block[x][y] = i;
        }
    }

    public boolean isValid(int x, int y) {
        return x >= 0 && y >= 0 && x < 17 & y < 17;
    }

    public int woodPattern(int d, int x, int y) {
        d = (d >> 1) % 16;
        switch (d) {
            case 0: {
                if (x % 2 != y % 2) break;
                ++d;
                break;
            }
            case 3: {
                if (x % 2 != 0) break;
                ++d;
                break;
            }
            case 4: {
                if (y % 2 != 0) break;
                ++d;
                break;
            }
            case 6: {
                if (x % 2 * (y % 2) != 0) break;
                ++d;
                break;
            }
            case 8: {
                if (x % 3 * (y % 3) != 0) break;
                ++d;
                break;
            }
            case 9: {
                if (x % 4 + y % 4 != 0) break;
                ++d;
                break;
            }
            case 11: {
                if (x % 4 + y % 2 != 0) break;
                ++d;
                break;
            }
            case 12: {
                if (x % 3 != 0) break;
                ++d;
                break;
            }
            case 13: {
                if (x % 6 == 0) {
                    ++d;
                    break;
                }
                if (x % 2 != 0) break;
                d += 2;
                break;
            }
        }
        return d % 16;
    }

    public static class Vec2 {
        int x;
        int y;

        public Vec2(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            return o instanceof Vec2 && ((Vec2)o).x == this.x && ((Vec2)o).y == this.y;
        }

        public double distFrom(Vec2 other) {
            return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y));
        }
    }
}

