/*
 * Decompiled with CFR 0.152.
 */
package deep_ci.mcmods.simpleflight;

import cpw.mods.fml.common.registry.GameRegistry;
import deep_ci.mcmods.simpleflight.SimpleFlight;
import deep_ci.mcmods.simpleflight.SimpleFlightAPI;
import deep_ci.mcmods.simpleflight.WingItem;
import deep_ci.mcmods.simpleflight.item.WingItemJetpack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public final class ModItems {
    private static boolean loaded = false;
    private static ModItems thiz;
    private HashMap<ItemStack, Object[]> recipeMap = new HashMap();
    private List<Item> itemList = new ArrayList<Item>();
    public Item glider_leather;
    public Item leatherWings;
    public Item goldFeatherWings;
    public Item goldLeatherWings;
    public Item ironFeatherWings;
    public Item ironLeatherWings;
    public Item jetpack;
    public Item jetglider;
    public Item diamondFeatherWings;
    public Item diamondLeatherWings;
    public Item boots_jump;
    public Item boots_fall;
    public Enchantment flyLonger;
    public Enchantment flyFaster;

    private ModItems() {
        this.initItems();
        this.initRecipes();
    }

    public static ModItems getMI() {
        if (thiz == null) {
            thiz = new ModItems();
        }
        return thiz;
    }

    public void load() {
        this.flyLonger = SimpleFlightAPI.moreFlaps;
        this.flyFaster = SimpleFlightAPI.quickerFlaps;
        this.registerItems();
        this.registerRecipes();
    }

    private void initItems() {
        this.initWings();
        this.initBoots();
    }

    private void initWings() {
        this.glider_leather = new WingItem(0, 0, true, ItemArmor.ArmorMaterial.CLOTH, 0, 1);
        this.glider_leather.func_111206_d("leather_glider").func_77655_b("leather_glider");
        this.leatherWings = new WingItem(5, 16, true, ItemArmor.ArmorMaterial.CLOTH, 0, 1);
        this.leatherWings.func_111206_d("leather_wings").func_77655_b("leather_wings");
        this.itemList.add(this.glider_leather);
        this.itemList.add(this.leatherWings);
        this.goldFeatherWings = new WingItem(16, 12, false, ItemArmor.ArmorMaterial.GOLD, 4, 1);
        this.goldFeatherWings.func_111206_d("golden_feather_wings").func_77655_b("gold_feather_wings");
        this.goldLeatherWings = new WingItem(15, 14, true, true, ItemArmor.ArmorMaterial.GOLD, 4, 1);
        this.goldLeatherWings.func_111206_d("golden_leather_wings").func_77655_b("gold_leather_wings");
        this.itemList.add(this.goldFeatherWings);
        this.itemList.add(this.goldLeatherWings);
        this.ironFeatherWings = new WingItem(21, 18, false, ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.ironFeatherWings.func_111206_d("iron_feather_wings").func_77655_b("iron_feather_wings");
        this.ironLeatherWings = new WingItem(24, 20, true, true, ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.ironLeatherWings.func_111206_d("iron_leather_wings").func_77655_b("iron_leather_wings");
        this.itemList.add(this.ironFeatherWings);
        this.itemList.add(this.ironLeatherWings);
        this.diamondFeatherWings = new WingItem(48, 14, false, ItemArmor.ArmorMaterial.DIAMOND, 3, 1);
        this.diamondFeatherWings.func_111206_d("diamond_feather_wings").func_77655_b("diamond_feather_wings");
        this.diamondLeatherWings = new WingItem(46, 16, true, true, ItemArmor.ArmorMaterial.DIAMOND, 3, 1);
        this.diamondLeatherWings.func_111206_d("diamond_leather_wings").func_77655_b("diamond_leather_wings");
        this.itemList.add(this.diamondFeatherWings);
        this.itemList.add(this.diamondLeatherWings);
        this.jetpack = new WingItemJetpack(20000, 0, false, ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.jetpack.func_111206_d("jetpack").func_77655_b("jetpack");
        this.jetglider = new WingItemJetpack(20000, 0, true, true, ItemArmor.ArmorMaterial.IRON, 2, 1);
        this.jetglider.func_111206_d("jetpack").func_77655_b("jetglider");
        this.itemList.add(this.jetpack);
        this.itemList.add(this.jetglider);
        SimpleFlight.logger.log(Level.INFO, "Initialized items.");
    }

    private void initBoots() {
    }

    private void initRecipes() {
        this.recipeMap.put(new ItemStack(this.glider_leather, 1, 0), new Object[]{"QQ ", "WQQ", "QWQ", Character.valueOf('Q'), Items.field_151055_y, Character.valueOf('W'), Items.field_151116_aA});
        this.recipeMap.put(new ItemStack(this.leatherWings, 1, 0), new Object[]{"Q Q", "WQW", "WCW", Character.valueOf('Q'), Items.field_151055_y, Character.valueOf('W'), Items.field_151116_aA, Character.valueOf('C'), Items.field_151027_R});
        this.recipeMap.put(new ItemStack(this.goldFeatherWings, 1, 0), new Object[]{"F F", "FFF", "FCF", Character.valueOf('F'), Items.field_151008_G, Character.valueOf('C'), Items.field_151171_ah});
        this.recipeMap.put(new ItemStack(this.goldLeatherWings, 1, 0), new Object[]{"I I", "LIL", "LCL", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('C'), Items.field_151171_ah, Character.valueOf('L'), Items.field_151116_aA});
        this.recipeMap.put(new ItemStack(this.ironFeatherWings, 1, 0), new Object[]{"F F", "FFF", "FCF", Character.valueOf('F'), Items.field_151008_G, Character.valueOf('C'), Items.field_151030_Z});
        this.recipeMap.put(new ItemStack(this.ironLeatherWings, 1, 0), new Object[]{"I I", "LIL", "LCL", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), Items.field_151030_Z, Character.valueOf('L'), Items.field_151116_aA});
        this.recipeMap.put(new ItemStack(this.diamondFeatherWings, 1, 0), new Object[]{"F F", "FFF", "FCF", Character.valueOf('F'), Items.field_151008_G, Character.valueOf('C'), Items.field_151163_ad});
        this.recipeMap.put(new ItemStack(this.diamondLeatherWings, 1, 0), new Object[]{"I I", "LIL", "LCL", Character.valueOf('I'), Items.field_151045_i, Character.valueOf('C'), Items.field_151163_ad, Character.valueOf('L'), Items.field_151116_aA});
        this.recipeMap.put(new ItemStack(this.jetpack, 1, 0), new Object[]{"I I", "BCB", "I I", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), Items.field_151030_Z, Character.valueOf('B'), Items.field_151065_br});
        this.recipeMap.put(new ItemStack(this.jetglider, 1, 0), new Object[]{"I I", "LCL", "LLL", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), this.jetpack, Character.valueOf('L'), Items.field_151116_aA});
    }

    private void registerItems() {
        for (Item item : this.itemList) {
            GameRegistry.registerItem((Item)item, (String)item.func_77658_a().substring(5));
        }
        SimpleFlight.logger.log(Level.DEBUG, "Item Registration COMPLETE.");
    }

    private void registerRecipes() {
        for (Map.Entry<ItemStack, Object[]> recipe : this.recipeMap.entrySet()) {
            GameRegistry.addShapedRecipe((ItemStack)recipe.getKey(), (Object[])recipe.getValue());
        }
        SimpleFlight.logger.log(Level.DEBUG, "Recipe Registration COMPLETE.");
    }
}

